/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.hornetq.core.server.JournalType;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class MessagingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final MessagingSubsystemParser INSTANCE = new MessagingSubsystemParser();

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    private MessagingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "messaging");
        list.add(operation);
        int tag = reader.getEventType();
        String localName = null;
        block77: do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPTORS: {
                    ModelNode acceptors = MessagingSubsystemParser.processAcceptors(reader);
                    operation.get("acceptor").set(acceptors);
                    break;
                }
                case ADDRESS_SETTINGS: {
                    ModelNode addressSettings = MessagingSubsystemParser.processAddressSettings(reader);
                    operation.get("address-setting").set(addressSettings);
                    break;
                }
                case ASYNC_CONNECTION_EXECUTION_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case BACKUP: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case BACKUP_CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case BINDINGS_DIRECTORY: {
                    ModelNode directory = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("bindings-directory").set(directory);
                    break;
                }
                case BROADCAST_PERIOD: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case CLUSTERED: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case CLUSTER_PASSWORD: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case CLUSTER_USER: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case CONNECTION_TTL_OVERRIDE: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case CONNECTORS: {
                    ModelNode connectors = MessagingSubsystemParser.processConnectors(reader);
                    operation.get("connector").set(connectors);
                    break;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case CREATE_BINDINGS_DIR: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case CREATE_JOURNAL_DIR: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case FILE_DEPLOYMENT_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUP_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUP_PORT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUPING_HANDLER: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case ID_CACHE_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JMX_DOMAIN: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JMX_MANAGEMENT_ENABLED: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JOURNAL_BUFFER_SIZE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case JOURNAL_BUFFER_TIMEOUT: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JOURNAL_COMPACT_MIN_FILES: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JOURNAL_COMPACT_PERCENTAGE: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JOURNAL_DIRECTORY: {
                    ModelNode directory = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("journal-directory").set(directory);
                    break;
                }
                case JOURNAL_MIN_FILES: {
                    operation.get("journal-min-files").set(reader.getElementText());
                    break;
                }
                case JOURNAL_SYNC_NON_TRANSACTIONAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JOURNAL_SYNC_TRANSACTIONAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case JOURNAL_TYPE: {
                    String journalType = reader.getElementText();
                    if (journalType == null || journalType.length() <= 0) continue block77;
                    JournalType.valueOf((String)journalType.trim());
                    operation.get("journal-type").set(journalType.trim());
                    break;
                }
                case JOURNAL_FILE_SIZE: {
                    String text = reader.getElementText();
                    if (text == null || text.length() <= 0) continue block77;
                    operation.get("journal-file-size").set(text.trim());
                    break;
                }
                case JOURNAL_MAX_IO: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case LARGE_MESSAGES_DIRECTORY: {
                    ModelNode dir = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("large-messages-directory").set(dir);
                    break;
                }
                case LOCAL_BIND_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case LOCAL_BIND_PORT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case LOG_JOURNAL_WRITE_RATE: {
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case MANAGEMENT_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MANAGEMENT_NOTIFICATION_ADDRESS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MEMORY_MEASURE_INTERVAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MEMORY_WARNING_THRESHOLD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_MAX_DAY_HISTORY: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_SAMPLE_PERIOD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_EXPIRY_SCAN_PERIOD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_EXPIRY_THREAD_PRIORITY: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PAGING_DIRECTORY: {
                    ModelNode directory = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("paging-directory").set(directory);
                    break;
                }
                case PERF_BLAST_PAGES: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PERSIST_ID_CACHE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PERSISTENCE_ENABLED: {
                    String value = reader.getElementText();
                    if (value == null || value.length() <= 0) continue block77;
                    boolean enabled = Boolean.valueOf(value.trim());
                    operation.get("persistence-enabled").set(enabled);
                    break;
                }
                case REFRESH_TIMEOUT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case REMOTING_INTERCEPTORS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case RUN_SYNC_SPEED_TEST: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SECURITY_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SECURITY_INVALIDATION_INTERVAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SECURITY_SETTINGS: {
                    ModelNode securitySettings = MessagingSubsystemParser.processSecuritySettings(reader);
                    operation.get("security-setting").set(securitySettings);
                    break;
                }
                case SERVER_DUMP_INTERVAL: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SHARED_STORE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case TRANSACTION_TIMEOUT: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case TRANSACTION_TIMEOUT_SCAN_PERIOD: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case WILD_CARD_ROUTING_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case DEAD_LETTER_ADDRESS_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case EXPIRY_ADDRESS_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case REDELIVERY_DELAY_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MAX_DELIVERY_ATTEMPTS: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MAX_SIZE_BYTES_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case PAGE_SIZE_BYTES_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case LVQ_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case REDISTRIBUTION_DELAY_NODE_NAME: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case SEND_TO_DLA_ON_NO_ROUTE: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case QUEUES: {
                    ModelNode queues = MessagingSubsystemParser.parseQueues(reader);
                    operation.get("queue").set(queues);
                    break;
                }
                case SUBSYSTEM: {
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        } while (reader.hasNext() && !localName.equals("subsystem"));
    }

    static ModelNode processAcceptors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode acceptors = new ModelNode();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPTOR: {
                    ModelNode acceptor = acceptors.get(name);
                    acceptor.get("type").set(MessagingServices.TransportConfigType.Generic.toString());
                    if (socketBinding != null) {
                        acceptor.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, true);
                    continue block10;
                }
                case NETTY_ACCEPTOR: {
                    ModelNode acceptor = acceptors.get(name);
                    acceptor.get("type").set(MessagingServices.TransportConfigType.Remote.toString());
                    if (socketBinding != null) {
                        acceptor.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, false);
                    continue block10;
                }
                case IN_VM_ACCEPTOR: {
                    ModelNode acceptor = acceptors.get(name);
                    acceptor.get("type").set(MessagingServices.TransportConfigType.InVM.toString());
                    acceptor.get("server-id").set(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, false);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return acceptors;
    }

    static ModelNode parseQueues(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode queues = new ModelNode();
        queues.setEmptyObject();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block7: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case QUEUE: {
                    if (name == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
                    }
                    MessagingSubsystemParser.parseQueue(reader, queues.get(name));
                    if (queues.get(name).has("address")) continue block6;
                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.ADDRESS.getLocalName()));
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return queues;
    }

    static void parseQueue(XMLExtendedStreamReader reader, ModelNode queue) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDRESS: {
                    queue.get("address").set(reader.getElementText().trim());
                    continue block5;
                }
                case FILTER: {
                    queue.get("filter").set(reader.getAttributeValue(0).trim());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block5;
                }
                case DURABLE: {
                    queue.get("durable").set(Boolean.valueOf(reader.getElementText()).booleanValue());
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode processSecuritySettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode security = new ModelNode();
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_SETTING: {
                    String match = reader.getAttributeValue(0);
                    MessagingSubsystemParser.parseSecurityRoles(reader, security.get(match));
                }
            }
        } while (reader.hasNext() && localName.equals(Element.SECURITY_SETTING.getLocalName()));
        return security;
    }

    static void parseSecurityRoles(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createNonDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element != Element.PERMISSION_ELEMENT_NAME) break;
            List roles = null;
            String type = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ROLES_ATTR_NAME: {
                        roles = reader.getListAttributeValue(i);
                        continue block5;
                    }
                    case TYPE_ATTR_NAME: {
                        type = reader.getAttributeValue(i);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            for (String role : roles) {
                if (Attribute.SEND_NAME.getLocalName().equals(type)) {
                    send.add(role.trim());
                } else if (Attribute.CONSUME_NAME.getLocalName().equals(type)) {
                    consume.add(role.trim());
                } else if (Attribute.CREATEDURABLEQUEUE_NAME.getLocalName().equals(type)) {
                    createDurableQueue.add(role);
                } else if (Attribute.DELETEDURABLEQUEUE_NAME.getLocalName().equals(type)) {
                    deleteDurableQueue.add(role);
                } else if (Attribute.CREATE_NON_DURABLE_QUEUE_NAME.getLocalName().equals(type)) {
                    createNonDurableQueue.add(role);
                } else if (Attribute.DELETE_NON_DURABLE_QUEUE_NAME.getLocalName().equals(type)) {
                    deleteNonDurableQueue.add(role);
                } else if (Attribute.CREATETEMPQUEUE_NAME.getLocalName().equals(type)) {
                    createNonDurableQueue.add(role);
                } else if (Attribute.DELETETEMPQUEUE_NAME.getLocalName().equals(type)) {
                    deleteNonDurableQueue.add(role);
                } else if (Attribute.MANAGE_NAME.getLocalName().equals(type)) {
                    manageRoles.add(role);
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
            reader.discardRemainder();
        } while (reader.hasNext());
        for (String role : allRoles) {
            node.get(new String[]{role, "send"}).set(send.contains(role));
            node.get(new String[]{role, "consume"}).set(consume.contains(role));
            node.get(new String[]{role, "createDurableQueue"}).set(createDurableQueue.contains(role));
            node.get(new String[]{role, "deleteDurableQueue"}).set(deleteDurableQueue.contains(role));
            node.get(new String[]{role, "createNonDurableQueue"}).set(createNonDurableQueue.contains(role));
            node.get(new String[]{role, "deleteNonDurableQueue"}).set(deleteNonDurableQueue.contains(role));
            node.get(new String[]{role, "manage"}).set(manageRoles.contains(role));
        }
    }

    static ModelNode processConnectors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode connectors = new ModelNode();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    ModelNode connector = connectors.get(name);
                    connector.get("type").set(MessagingServices.TransportConfigType.Generic.toString());
                    if (socketBinding != null) {
                        connector.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, true);
                    continue block10;
                }
                case NETTY_CONNECTOR: {
                    ModelNode connector = connectors.get(name);
                    connector.get("type").set(MessagingServices.TransportConfigType.Remote.toString());
                    if (socketBinding != null) {
                        connector.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, false);
                    continue block10;
                }
                case IN_VM_CONNECTOR: {
                    ModelNode connector = connectors.get(name);
                    connector.get("type").set(MessagingServices.TransportConfigType.InVM.toString());
                    connector.get("server-id").set(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, false);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return connectors;
    }

    static ModelNode processAddressSettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode settings = new ModelNode();
        String localName = null;
        int tag = reader.getEventType();
        do {
            reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case ADDRESS_SETTING: {
                    String match = reader.getAttributeValue(0);
                    settings.get(match).set(MessagingSubsystemParser.parseAddressSettings(reader));
                }
            }
        } while (reader.hasNext() && localName.equals(Element.ADDRESS_SETTING.getLocalName()));
        return settings;
    }

    static ModelNode parseAddressSettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addressSettingsSpec = new ModelNode();
        String localName = null;
        do {
            int tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case DEAD_LETTER_ADDRESS_NODE_NAME: 
                case EXPIRY_ADDRESS_NODE_NAME: 
                case REDELIVERY_DELAY_NODE_NAME: 
                case MAX_DELIVERY_ATTEMPTS: 
                case MAX_SIZE_BYTES_NODE_NAME: 
                case ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME: 
                case PAGE_SIZE_BYTES_NODE_NAME: 
                case MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME: 
                case LVQ_NODE_NAME: 
                case REDISTRIBUTION_DELAY_NODE_NAME: 
                case SEND_TO_DLA_ON_NO_ROUTE: {
                    MessagingSubsystemParser.handleElementText(reader, element, addressSettingsSpec);
                    break;
                }
            }
        } while (!reader.getLocalName().equals(Element.ADDRESS_SETTING.getLocalName()) && reader.getEventType() == 2);
        return addressSettingsSpec;
    }

    static void parseTransportConfigurationParams(XMLExtendedStreamReader reader, ModelNode transportConfig, boolean generic) throws XMLStreamException {
        ModelNode params = new ModelNode();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            int count = reader.getAttributeCount();
            String key = null;
            String value = null;
            block9: for (int n = 0; n < count; ++n) {
                String attrName = reader.getAttributeLocalName(n);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case KEY: {
                        key = reader.getAttributeValue(n);
                        continue block9;
                    }
                    case VALUE: {
                        value = reader.getAttributeValue(n);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)n);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FACTORY_CLASS: {
                    if (!generic) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    transportConfig.get("factory-class").set(reader.getElementText().trim());
                    continue block8;
                }
                case PARAM: {
                    params.add(key, value);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        transportConfig.get("param").set(params);
    }

    static ModelNode parseDirectory(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode directory = new ModelNode();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case RELATIVE_TO: {
                    directory.get("relative-to").set(value);
                    continue block4;
                }
                case PATH: {
                    directory.get("path").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return directory;
    }

    static void unhandledElement(XMLExtendedStreamReader reader, Element element) throws XMLStreamException {
        throw new XMLStreamException(String.format("Ignorning unhandled element: %s, at: %s", new Object[]{element, reader.getLocation().toString()}));
    }

    static void handleElementText(XMLExtendedStreamReader reader, Element element, ModelNode node) throws XMLStreamException {
        String value = reader.getElementText();
        if (value != null && value.length() > 0) {
            node.get(element.getLocalName()).set(value.trim());
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (this.has(node, "acceptor")) {
            this.writeAcceptors(writer, node.get("acceptor"));
        }
        if (this.has(node, "address-setting")) {
            this.writeAddressSettings(writer, node.get("address-setting"));
        }
        if (this.has(node, "async-connection-execution-enabled")) {
            // empty if block
        }
        if (this.has(node, "backup")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.BACKUP, node);
        }
        if (this.has(node, "backup-connector-ref")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.BACKUP_CONNECTOR_REF, node);
        }
        if (this.has(node, "bindings-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.BINDINGS_DIRECTORY, node);
        }
        if (this.has(node, "broadcast-period")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.BROADCAST_PERIOD, node);
        }
        if (this.has(node, "clustered")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.CLUSTERED, node);
        }
        if (this.has(node, "cluster-password")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.CLUSTER_PASSWORD, node);
        }
        if (this.has(node, "cluster-user")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.CLUSTER_USER, node);
        }
        if (this.has(node, "connection-ttl-override")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.CONNECTION_TTL_OVERRIDE, node);
        }
        if (this.has(node, "connector")) {
            this.writeConnectors(writer, node.get("connector"));
        }
        if (this.has(node, "connector-ref")) {
            // empty if block
        }
        if (this.has(node, "create-bindings-dir")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.CREATE_BINDINGS_DIR, node);
        }
        if (this.has(node, "create-journal-dir")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.CREATE_BINDINGS_DIR, node);
        }
        if (this.has(node, "file-deployment-enabled")) {
            // empty if block
        }
        if (this.has(node, "group-address")) {
            // empty if block
        }
        if (this.has(node, "group-port")) {
            // empty if block
        }
        if (this.has(node, "grouping-handler")) {
            // empty if block
        }
        if (this.has(node, "id-cache-size")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.ID_CACHE_SIZE, node);
        }
        if (this.has(node, "jmx-domain")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JMX_DOMAIN, node);
        }
        if (this.has(node, "jmx-management-enabled")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JMX_MANAGEMENT_ENABLED, node);
        }
        if (this.has(node, "journal-buffer-size")) {
            // empty if block
        }
        if (this.has(node, "journal-buffer-timeout")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_BUFFER_TIMEOUT, node);
        }
        if (this.has(node, "journal-compact-min-files")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_COMPACT_MIN_FILES, node);
        }
        if (this.has(node, "journal-compact-percentage")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_COMPACT_PERCENTAGE, node);
        }
        if (this.has(node, "journal-compact-percentage")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_COMPACT_PERCENTAGE, node);
        }
        if (this.has(node, "journal-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.JOURNAL_DIRECTORY, node);
        }
        if (this.has(node, "journal-min-files")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_MIN_FILES, node);
        }
        if (this.has(node, "journal-sync-non-transactional")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_SYNC_TRANSACTIONAL, node);
        }
        if (this.has(node, "journal-sync-transactional")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_SYNC_TRANSACTIONAL, node);
        }
        if (this.has(node, "journal-type")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_TYPE, node);
        }
        if (this.has(node, "journal-file-size")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_FILE_SIZE, node);
        }
        if (this.has(node, "journal-max-io")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.JOURNAL_MAX_IO, node);
        }
        if (this.has(node, "large-messages-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.LARGE_MESSAGES_DIRECTORY, node);
        }
        if (this.has(node, "local-bind-address")) {
            // empty if block
        }
        if (this.has(node, "local-bind-port")) {
            // empty if block
        }
        if (this.has(node, "log-journal-write-rate")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.LOG_JOURNAL_WRITE_RATE, node);
        }
        if (this.has(node, "management-address")) {
            // empty if block
        }
        if (this.has(node, "management-notification-address")) {
            // empty if block
        }
        if (this.has(node, "memory-measure-interval")) {
            // empty if block
        }
        if (this.has(node, "memory-warning-threshold")) {
            // empty if block
        }
        if (this.has(node, "message-counter-enabled")) {
            // empty if block
        }
        if (this.has(node, "message-counter-history-day-limit")) {
            // empty if block
        }
        if (this.has(node, "message-counter-max-day-history")) {
            // empty if block
        }
        if (this.has(node, "message-counter-sample-period")) {
            // empty if block
        }
        if (this.has(node, "message-expiry-scan-period")) {
            // empty if block
        }
        if (this.has(node, "message-expiry-thread-priority")) {
            // empty if block
        }
        if (this.has(node, "paging-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.PAGING_DIRECTORY, node);
        }
        if (this.has(node, "perf-blast-pages")) {
            // empty if block
        }
        if (this.has(node, "persist-delivery-count-before-delivery")) {
            // empty if block
        }
        if (this.has(node, "persist-id-cache")) {
            // empty if block
        }
        if (this.has(node, "persistence-enabled")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.PERSISTENCE_ENABLED, node);
        }
        if (this.has(node, "refresh-timeout")) {
            // empty if block
        }
        if (this.has(node, "remoting-interceptors")) {
            // empty if block
        }
        if (this.has(node, "run-sync-speed-test")) {
            // empty if block
        }
        if (this.has(node, "security-enabled")) {
            // empty if block
        }
        if (this.has(node, "security-invalidation-interval")) {
            // empty if block
        }
        if (this.has(node, "security-setting")) {
            this.writeSecuritySettings(writer, node.get("security-setting"));
        }
        if (this.has(node, "server-dump-interval")) {
            // empty if block
        }
        if (this.has(node, "shared-store")) {
            // empty if block
        }
        if (this.has(node, "transaction-timeout")) {
            // empty if block
        }
        if (this.has(node, "transaction-timeout-scan-period")) {
            // empty if block
        }
        if (this.has(node, "wild-card-routing-enabled")) {
            // empty if block
        }
        if (this.has(node, "dead-letter-address")) {
            // empty if block
        }
        if (this.has(node, "expiry-address")) {
            // empty if block
        }
        if (this.has(node, "redelivery-delay")) {
            // empty if block
        }
        if (this.has(node, "max-delivery-attempts")) {
            // empty if block
        }
        if (this.has(node, "max-size-bytes")) {
            // empty if block
        }
        if (this.has(node, "address-full-policy")) {
            // empty if block
        }
        if (this.has(node, "page-size-bytes")) {
            // empty if block
        }
        if (this.has(node, "message-counter-history-day-limit")) {
            // empty if block
        }
        if (this.has(node, "last-value-queue")) {
            // empty if block
        }
        if (this.has(node, "redistribution-delay")) {
            // empty if block
        }
        if (this.has(node, "send-to-dla-on-no-route")) {
            // empty if block
        }
        if (this.has(node, "queue")) {
            this.writeQueues(writer, node.get("queue"));
        }
        writer.writeEndElement();
    }

    private void writeAcceptors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.ACCEPTORS.getLocalName());
        for (Property property : node.asPropertyList()) {
            ModelNode value = property.getValue();
            if (!this.has(value, "type")) continue;
            switch (Enum.valueOf(MessagingServices.TransportConfigType.class, value.get("type").asString())) {
                case Generic: {
                    writer.writeStartElement(Element.ACCEPTOR.getLocalName());
                    break;
                }
                case Remote: {
                    writer.writeStartElement(Element.NETTY_ACCEPTOR.getLocalName());
                    break;
                }
                case InVM: {
                    writer.writeStartElement(Element.IN_VM_ACCEPTOR.getLocalName());
                }
            }
            this.writeAcceptorAndConnectorContent(writer, property);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeConnectors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.CONNECTORS.getLocalName());
        for (Property property : node.asPropertyList()) {
            ModelNode value = property.getValue();
            if (!this.has(value, "type")) continue;
            switch (Enum.valueOf(MessagingServices.TransportConfigType.class, value.get("type").asString())) {
                case Generic: {
                    writer.writeStartElement(Element.CONNECTOR.getLocalName());
                    break;
                }
                case Remote: {
                    writer.writeStartElement(Element.NETTY_CONNECTOR.getLocalName());
                    break;
                }
                case InVM: {
                    writer.writeStartElement(Element.IN_VM_CONNECTOR.getLocalName());
                }
            }
            this.writeAcceptorAndConnectorContent(writer, property);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeAcceptorAndConnectorContent(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        ModelNode value = property.getValue();
        if (this.has(value, "socket-binding")) {
            this.writeAttribute(writer, Attribute.SOCKET_BINDING, value.get("socket-binding"));
        }
        if (this.has(value, "server-id")) {
            this.writeAttribute(writer, Attribute.SERVER_ID, value.get("server-id"));
        }
        if (this.has(value, "factory-class")) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.FACTORY_CLASS, value);
        }
        if (this.has(value, "param")) {
            for (Property parameter : value.get("param").asPropertyList()) {
                writer.writeStartElement(Element.PARAM.getLocalName());
                writer.writeAttribute(Attribute.KEY.getLocalName(), parameter.getName());
                this.writeAttribute(writer, Attribute.VALUE, parameter.getValue());
                writer.writeEndElement();
            }
        }
    }

    private void writeSecuritySettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.SECURITY_SETTINGS.getLocalName());
        for (Property matchRoles : node.asPropertyList()) {
            writer.writeStartElement(Element.SECURITY_SETTING.getLocalName());
            writer.writeAttribute(Attribute.MATCH.getLocalName(), matchRoles.getName());
            ArrayList<String> send = new ArrayList<String>();
            ArrayList<String> consume = new ArrayList<String>();
            ArrayList<String> createDurableQueue = new ArrayList<String>();
            ArrayList<String> deleteDurableQueue = new ArrayList<String>();
            ArrayList<String> createNonDurableQueue = new ArrayList<String>();
            ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
            ArrayList<String> manageRoles = new ArrayList<String>();
            for (Property rolePerms : matchRoles.getValue().asPropertyList()) {
                String role = rolePerms.getName();
                ModelNode perms = rolePerms.getValue();
                if (perms.get("send").asBoolean()) {
                    send.add(role);
                }
                if (perms.get("consume").asBoolean()) {
                    consume.add(role);
                }
                if (perms.get("createDurableQueue").asBoolean()) {
                    createDurableQueue.add(role);
                }
                if (perms.get("deleteDurableQueue").asBoolean()) {
                    deleteDurableQueue.add(role);
                }
                if (perms.get("createNonDurableQueue").asBoolean()) {
                    createNonDurableQueue.add(role);
                }
                if (perms.get("deleteNonDurableQueue").asBoolean()) {
                    deleteNonDurableQueue.add(role);
                }
                if (!perms.get("manage").asBoolean()) continue;
                manageRoles.add(role);
            }
            this.writePermission(writer, "send", send);
            this.writePermission(writer, "consume", consume);
            this.writePermission(writer, "createDurableQueue", createDurableQueue);
            this.writePermission(writer, "deleteDurableQueue", deleteDurableQueue);
            this.writePermission(writer, "createNonDurableQueue", createNonDurableQueue);
            this.writePermission(writer, "deleteNonDurableQueue", deleteNonDurableQueue);
            this.writePermission(writer, "manage", manageRoles);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePermission(XMLExtendedStreamWriter writer, String type, List<String> roles) throws XMLStreamException {
        if (roles.size() == 0) {
            return;
        }
        writer.writeStartElement(Element.PERMISSION_ELEMENT_NAME.getLocalName());
        StringBuilder sb = new StringBuilder();
        for (String role : roles) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(role);
        }
        writer.writeAttribute(Attribute.TYPE_ATTR_NAME.getLocalName(), type);
        writer.writeAttribute(Attribute.ROLES_ATTR_NAME.getLocalName(), sb.toString());
        writer.writeEndElement();
    }

    private void writeAddressSettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.ADDRESS_SETTINGS.getLocalName());
        for (Property matchSetting : node.asPropertyList()) {
            writer.writeStartElement(Element.ADDRESS_SETTING.getLocalName());
            writer.writeAttribute(Attribute.MATCH.getLocalName(), matchSetting.getName());
            ModelNode setting = matchSetting.getValue();
            if (this.has(setting, "dead-letter-address")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.DEAD_LETTER_ADDRESS_NODE_NAME, setting);
            }
            if (this.has(setting, "expiry-address")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.EXPIRY_ADDRESS_NODE_NAME, setting);
            }
            if (this.has(setting, "redelivery-delay")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.REDELIVERY_DELAY_NODE_NAME, setting);
            }
            if (this.has(setting, "max-size-bytes")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.MAX_SIZE_BYTES_NODE_NAME, setting);
            }
            if (this.has(setting, "page-size-bytes")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.PAGE_SIZE_BYTES_NODE_NAME, setting);
            }
            if (this.has(setting, "message-counter-history-day-limit")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME, setting);
            }
            if (this.has(setting, "address-full-policy")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, setting);
            }
            if (this.has(setting, "last-value-queue")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.LVQ_NODE_NAME, setting);
            }
            if (this.has(setting, "max-delivery-attempts")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.MAX_DELIVERY_ATTEMPTS, setting);
            }
            if (this.has(setting, "redistribution-delay")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.REDISTRIBUTION_DELAY_NODE_NAME, setting);
            }
            if (this.has(setting, "send-to-dla-on-no-route")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.SEND_TO_DLA_ON_NO_ROUTE, setting);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.QUEUES.getLocalName());
        for (Property queueProp : node.asPropertyList()) {
            writer.writeStartElement(Element.QUEUE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), queueProp.getName());
            ModelNode queue = queueProp.getValue();
            if (this.has(queue, "address")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.ADDRESS, queue);
            }
            if (this.has(queue, "filter")) {
                writer.writeStartElement(Element.FILTER.getLocalName());
                this.writeAttribute(writer, Attribute.STRING, queue);
                writer.writeEndElement();
            }
            if (this.has(queue, "durable")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.DURABLE, queue);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    static void writeSimpleElement(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String content;
        String localName = element.getLocalName();
        if (node.has(localName) && (content = node.get(localName).asString()) != null) {
            writer.writeStartElement(localName);
            writer.writeCharacters(content);
            writer.writeEndElement();
        }
    }

    static void writeDirectory(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String localName = element.getLocalName();
        if (node.has(localName)) {
            String relativeTo;
            String path = node.get(localName).has("path") ? node.get(new String[]{localName, "path"}).asString() : null;
            String string = relativeTo = node.get(localName).has("relative-to") ? node.get(new String[]{localName, "relative-to"}).asString() : null;
            if (path != null || relativeTo != null) {
                writer.writeEmptyElement(localName);
                if (path != null) {
                    writer.writeAttribute("path", path);
                }
                if (relativeTo != null) {
                    writer.writeAttribute("relative-to", relativeTo);
                }
            }
        }
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }
}

