/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MessagingDescriptions {
    static final String RESOURCE_NAME = MessagingDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private MessagingDescriptions() {
    }

    public static ModelNode getRootResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("messaging"));
        node.get(new String[]{"attributes", "acceptor", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "acceptor", "description"}).set(bundle.getString("acceptor"));
        node.get(new String[]{"attributes", "address-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "address-setting", "description"}).set(bundle.getString("address-setting"));
        node.get(new String[]{"attributes", "bindings-directory"}).set(MessagingDescriptions.getPathDescription("bindings.directory", bundle));
        node.get(new String[]{"attributes", "journal-directory"}).set(MessagingDescriptions.getPathDescription("journal.directory", bundle));
        node.get(new String[]{"attributes", "large-messages-directory"}).set(MessagingDescriptions.getPathDescription("large.messages.directory", bundle));
        node.get(new String[]{"attributes", "paging-directory"}).set(MessagingDescriptions.getPathDescription("paging.directory", bundle));
        node.get(new String[]{"attributes", "connector", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "connector", "description"}).set(bundle.getString("connector"));
        node.get(new String[]{"attributes", "security-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "security-setting", "description"}).set(bundle.getString("security-setting"));
        node.get(new String[]{"children", "queue"}).set(MessagingDescriptions.getQueueResource(locale));
        return node;
    }

    public static ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("messaging.add"));
        node.get(new String[]{"request-properties", "acceptor", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "acceptor", "description"}).set(bundle.getString("acceptor"));
        node.get(new String[]{"request-properties", "address-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "address-setting", "description"}).set(bundle.getString("address-setting"));
        node.get(new String[]{"request-properties", "bindings-directory"}).set(MessagingDescriptions.getPathDescription("bindings.directory", bundle));
        node.get(new String[]{"request-properties", "journal-directory"}).set(MessagingDescriptions.getPathDescription("journal.directory", bundle));
        node.get(new String[]{"request-properties", "large-messages-directory"}).set(MessagingDescriptions.getPathDescription("large.messages.directory", bundle));
        node.get(new String[]{"request-properties", "paging-directory"}).set(MessagingDescriptions.getPathDescription("paging.directory", bundle));
        node.get(new String[]{"request-properties", "connector", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "connector", "description"}).set(bundle.getString("connector"));
        node.get(new String[]{"request-properties", "security-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "security-setting", "description"}).set(bundle.getString("security-setting"));
        return node;
    }

    public static ModelNode getSubsystemRemove(Locale locale) {
        return new ModelNode();
    }

    public static ModelNode getSubsystemDescribe(Locale locale) {
        return new ModelNode();
    }

    public static ModelNode getQueueResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("queue"));
        node.get(new String[]{"attributes", "queue-address", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "queue-address", "description"}).set(bundle.getString("queue.address"));
        node.get(new String[]{"attributes", "filter", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "filter", "description"}).set(bundle.getString("queue.filter"));
        node.get(new String[]{"attributes", "durable", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"attributes", "durable", "description"}).set(bundle.getString("queue.durable"));
        return node;
    }

    public static ModelNode getQueueAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("queue.add"));
        node.get(new String[]{"request-properties", "queue-address", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "queue-address", "description"}).set(bundle.getString("queue.address"));
        node.get(new String[]{"request-properties", "filter", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "filter", "description"}).set(bundle.getString("queue.filter"));
        node.get(new String[]{"request-properties", "durable", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "durable", "description"}).set(bundle.getString("queue.durable"));
        return node;
    }

    public static ModelNode getQueueRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("queue.remove"));
        return node;
    }

    private static ModelNode getPathDescription(String description, ResourceBundle bundle) {
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString(description));
        node.get(new String[]{"attributes", "path", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "path", "description"}).set(bundle.getString("path.path"));
        node.get(new String[]{"attributes", "path", "required"}).set(false);
        node.get(new String[]{"attributes", "relative-to", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "relative-to", "description"}).set(bundle.getString("path.relative-to"));
        node.get(new String[]{"attributes", "relative-to", "required"}).set(false);
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

