/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Map;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.naming.MockContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ValueManagedObject;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Values;

class JMSQueueService
implements Service<Void> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private String queueName;
    private String selectorString;
    private boolean durable;
    private String[] jndi;

    public JMSQueueService(String queueName, String selectorString, boolean durable, String[] jndi) {
        this.queueName = queueName;
        this.selectorString = selectorString;
        this.durable = durable;
        this.jndi = jndi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            MockContext.pushBindingTrap();
            try {
                jmsManager.createQueue(false, this.queueName, this.selectorString, this.durable, this.jndi);
            }
            catch (Throwable throwable) {
                ServiceTarget target = context.getChildTarget();
                Map bindings = MockContext.popTrappedBindings();
                for (Map.Entry binding : bindings.entrySet()) {
                    BinderService binderService = new BinderService((String)binding.getKey());
                    target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{(String)binding.getKey()}), (Service)binderService).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, binderService.getNamingStoreInjector()).addInjection(binderService.getManagedObjectInjector(), (Object)new ValueManagedObject(Values.immediateValue(binding.getValue()))).setInitialMode(ServiceController.Mode.ACTIVE).install();
                }
                throw throwable;
            }
            ServiceTarget target = context.getChildTarget();
            Map bindings = MockContext.popTrappedBindings();
            for (Map.Entry binding : bindings.entrySet()) {
                BinderService binderService = new BinderService((String)binding.getKey());
                target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{(String)binding.getKey()}), (Service)binderService).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, binderService.getNamingStoreInjector()).addInjection(binderService.getManagedObjectInjector(), (Object)new ValueManagedObject(Values.immediateValue(binding.getValue()))).setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
        catch (Exception e) {
            throw new StartException("failed to create queue", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.destroyQueue(this.queueName);
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").warnf((Throwable)e, "failed to destroy jms queue: %s", (Object)this.queueName);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }
}

