/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MessagingDescriptions {
    static final String RESOURCE_NAME = MessagingDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private MessagingDescriptions() {
    }

    public static ModelNode getRootResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("messaging"));
        node.get(new String[]{"attributes", "acceptor", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "acceptor", "description"}).set(bundle.getString("acceptor"));
        node.get(new String[]{"attributes", "address-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "address-setting", "description"}).set(bundle.getString("address-setting"));
        node.get(new String[]{"attributes", "bindings-directory"}).set(MessagingDescriptions.getPathDescription("bindings.directory", bundle));
        node.get(new String[]{"attributes", "journal-directory"}).set(MessagingDescriptions.getPathDescription("journal.directory", bundle));
        node.get(new String[]{"attributes", "large-messages-directory"}).set(MessagingDescriptions.getPathDescription("large.messages.directory", bundle));
        node.get(new String[]{"attributes", "paging-directory"}).set(MessagingDescriptions.getPathDescription("paging.directory", bundle));
        node.get(new String[]{"attributes", "connector", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "connector", "description"}).set(bundle.getString("connector"));
        node.get(new String[]{"attributes", "security-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "security-setting", "description"}).set(bundle.getString("security-setting"));
        node.get(new String[]{"children", "queue"}).set(MessagingDescriptions.getQueueResource(locale));
        node.get(new String[]{"children", "connection-factory"}).set(MessagingDescriptions.getConnectionFactory(locale));
        node.get(new String[]{"children", "pooled-connection-factory"}).set(MessagingDescriptions.getPooledConnectionFactory(locale));
        node.get(new String[]{"children", "jms-queue"}).set(MessagingDescriptions.getJmsQueueResource(locale));
        node.get(new String[]{"children", "jms-topic"}).set(MessagingDescriptions.getTopic(locale));
        return node;
    }

    public static ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("messaging.add"));
        node.get(new String[]{"request-properties", "acceptor", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "acceptor", "description"}).set(bundle.getString("acceptor"));
        node.get(new String[]{"request-properties", "address-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "address-setting", "description"}).set(bundle.getString("address-setting"));
        node.get(new String[]{"request-properties", "bindings-directory"}).set(MessagingDescriptions.getPathDescription("bindings.directory", bundle));
        node.get(new String[]{"request-properties", "journal-directory"}).set(MessagingDescriptions.getPathDescription("journal.directory", bundle));
        node.get(new String[]{"request-properties", "large-messages-directory"}).set(MessagingDescriptions.getPathDescription("large.messages.directory", bundle));
        node.get(new String[]{"request-properties", "paging-directory"}).set(MessagingDescriptions.getPathDescription("paging.directory", bundle));
        node.get(new String[]{"request-properties", "connector", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "connector", "description"}).set(bundle.getString("connector"));
        node.get(new String[]{"request-properties", "security-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "security-setting", "description"}).set(bundle.getString("security-setting"));
        return node;
    }

    public static ModelNode getSubsystemRemove(Locale locale) {
        return new ModelNode();
    }

    public static ModelNode getSubsystemDescribe(Locale locale) {
        return new ModelNode();
    }

    public static ModelNode getQueueResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("queue"));
        node.get(new String[]{"attributes", "queue-address", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "queue-address", "description"}).set(bundle.getString("queue.address"));
        node.get(new String[]{"attributes", "filter", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "filter", "description"}).set(bundle.getString("queue.filter"));
        node.get(new String[]{"attributes", "durable", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"attributes", "durable", "description"}).set(bundle.getString("queue.durable"));
        return node;
    }

    public static ModelNode getQueueAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("queue.add"));
        node.get(new String[]{"request-properties", "queue-address", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "queue-address", "description"}).set(bundle.getString("queue.address"));
        node.get(new String[]{"request-properties", "filter", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "filter", "description"}).set(bundle.getString("queue.filter"));
        node.get(new String[]{"request-properties", "durable", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "durable", "description"}).set(bundle.getString("queue.durable"));
        return node;
    }

    public static ModelNode getQueueRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("queue.remove"));
        return node;
    }

    static ModelNode getJmsQueueResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("jms-queue"));
        MessagingDescriptions.addQueueProperties(bundle, node, "attributes");
        return node;
    }

    static ModelNode getJmsQueueAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("jms-queue.add"));
        MessagingDescriptions.addQueueProperties(bundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addQueueProperties(ResourceBundle bundle, ModelNode node, String propType) {
        node.get(new String[]{propType, "entries", "description"}).set(bundle.getString("jms-queue.entries"));
        node.get(new String[]{propType, "entries", "type"}).set(ModelType.LIST);
        node.get(new String[]{propType, "entries", "min-length"}).set(1);
        node.get(new String[]{propType, "entries", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{propType, "selector", "description"}).set(bundle.getString("jms-queue.selector"));
        node.get(new String[]{propType, "selector", "type"}).set(ModelType.STRING);
        node.get(new String[]{propType, "selector", "nillable"}).set(true);
        node.get(new String[]{propType, "selector", "required"}).set(false);
        node.get(new String[]{propType, "durable", "description"}).set(bundle.getString("jms-queue.durable"));
        node.get(new String[]{propType, "durable", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{propType, "durable", "required"}).set(false);
        node.get(new String[]{propType, "durable", "default"}).set(false);
    }

    static ModelNode getJmsQueueRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("jms-queue.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getTopic(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("topic"));
        MessagingDescriptions.addTopicProperties(bundle, node, "attributes");
        return node;
    }

    static ModelNode getTopicAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("topic.add"));
        MessagingDescriptions.addTopicProperties(bundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addTopicProperties(ResourceBundle bundle, ModelNode node, String propType) {
        node.get(new String[]{propType, "entries", "description"}).set(bundle.getString("topic.entries"));
        node.get(new String[]{propType, "entries", "type"}).set(ModelType.LIST);
        node.get(new String[]{propType, "entries", "min-length"}).set(1);
        node.get(new String[]{propType, "entries", "value-type"}).set(ModelType.STRING);
    }

    static ModelNode getTopicRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("topic.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectionFactory(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("connection-factory"));
        MessagingDescriptions.addConnectionFactoryProperties(bundle, node, "attributes");
        return node;
    }

    static ModelNode getConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("connection-factory.add"));
        MessagingDescriptions.addConnectionFactoryProperties(bundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getPooledConnectionFactory(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("pooled-connection-factory"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle, node, "attributes");
        return node;
    }

    static ModelNode getPooledConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("pooled-connection-factory.add"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addPooledConnectionFactoryProperties(ResourceBundle bundle, ModelNode node, String propType) {
        for (JMSServices.NodeAttribute attr : JMSServices.POOLED_CONNECTION_FACTORY_ATTRS) {
            node.get(new String[]{propType, attr.getName(), "description"}).set(bundle.getString("pooled-connection-factory." + attr.getName()));
            node.get(new String[]{propType, attr.getName(), "type"}).set(attr.getType());
            node.get(new String[]{propType, attr.getName(), "required"}).set(attr.isRequired());
            if (attr.getName().equals("connector")) {
                node.get(new String[]{propType, attr.getName(), "value-type"}).set(MessagingDescriptions.getConnectionFactoryConnectionValueType(bundle, propType));
                continue;
            }
            if (attr.getValueType() == null) continue;
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(attr.getValueType());
        }
    }

    static ModelNode getPooledConnectionFactoryRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("pooled-connection-factory.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    private static void addConnectionFactoryProperties(ResourceBundle bundle, ModelNode node, String propType) {
        for (JMSServices.NodeAttribute attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            node.get(new String[]{propType, attr.getName(), "description"}).set(bundle.getString("connection-factory." + attr.getName()));
            node.get(new String[]{propType, attr.getName(), "type"}).set(attr.getType());
            node.get(new String[]{propType, attr.getName(), "required"}).set(attr.isRequired());
            if (attr.getName().equals("connector")) {
                node.get(new String[]{propType, attr.getName(), "value-type"}).set(MessagingDescriptions.getConnectionFactoryConnectionValueType(bundle, propType));
                continue;
            }
            if (attr.getValueType() == null) continue;
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(attr.getValueType());
        }
    }

    private static ModelNode getConnectionFactoryConnectionValueType(ResourceBundle bundle, String propType) {
        ModelNode node = new ModelNode().set("TBD");
        return node;
    }

    static ModelNode getConnectionFactoryRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("connection-factory.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    private static ModelNode getPathDescription(String description, ResourceBundle bundle) {
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString(description));
        node.get(new String[]{"attributes", "path", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "path", "description"}).set(bundle.getString("path.path"));
        node.get(new String[]{"attributes", "path", "required"}).set(false);
        node.get(new String[]{"attributes", "relative-to", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "relative-to", "description"}).set(bundle.getString("path.relative-to"));
        node.get(new String[]{"attributes", "relative-to", "required"}).set(false);
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

