/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import java.util.Locale;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class AddressSettingAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final OperationStepHandler INSTANCE = new AddressSettingAdd();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{CommonAttributes.ADDRESS_FULL_MESSAGE_POLICY, CommonAttributes.DEAD_LETTER_ADDRESS, CommonAttributes.LVQ, CommonAttributes.MAX_DELIVERY_ATTEMPTS, CommonAttributes.MAX_SIZE_BYTES_NODE_NAME, CommonAttributes.MESSAGE_COUNTER_HISTORY_DAY_LIMIT, CommonAttributes.EXPIRY_ADDRESS, CommonAttributes.REDELIVERY_DELAY, CommonAttributes.REDISTRIBUTION_DELAY, CommonAttributes.PAGE_SIZE_BYTES_NODE_NAME, CommonAttributes.SEND_TO_DLA_ON_NO_ROUTE};

    AddressSettingAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        HornetQServer server = AddressSettingAdd.getServer(context, operation);
        if (server != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            AddressSettings settings = AddressSettingAdd.createSettings(context, model);
            server.getAddressSettingsRepository().addMatch(address.getLastElement().getValue(), (Object)settings);
        }
    }

    static ModelNode createAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (SimpleAttributeDefinition definition : ATTRIBUTES) {
            String attribute = definition.getName();
            if (!subModel.hasDefined(attribute)) continue;
            operation.get(attribute).set(subModel.get(attribute));
        }
        return operation;
    }

    static AddressSettings createSettings(OperationContext context, ModelNode config) throws OperationFailedException {
        AddressSettings settings = new AddressSettings();
        AddressFullMessagePolicy addressPolicy = AddressFullMessagePolicy.valueOf((String)CommonAttributes.ADDRESS_FULL_MESSAGE_POLICY.resolveModelAttribute(context, config).asString());
        settings.setAddressFullMessagePolicy(addressPolicy);
        settings.setDeadLetterAddress(AddressSettingAdd.asSimpleString(CommonAttributes.DEAD_LETTER_ADDRESS.resolveModelAttribute(context, config), null));
        settings.setLastValueQueue(CommonAttributes.LVQ.resolveModelAttribute(context, config).asBoolean());
        settings.setMaxDeliveryAttempts(CommonAttributes.MAX_DELIVERY_ATTEMPTS.resolveModelAttribute(context, config).asInt());
        settings.setMaxSizeBytes((long)CommonAttributes.MAX_SIZE_BYTES_NODE_NAME.resolveModelAttribute(context, config).asInt());
        settings.setMessageCounterHistoryDayLimit(CommonAttributes.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.resolveModelAttribute(context, config).asInt());
        settings.setExpiryAddress(AddressSettingAdd.asSimpleString(CommonAttributes.EXPIRY_ADDRESS.resolveModelAttribute(context, config), null));
        settings.setRedeliveryDelay((long)CommonAttributes.REDELIVERY_DELAY.resolveModelAttribute(context, config).asInt());
        settings.setRedistributionDelay(CommonAttributes.REDISTRIBUTION_DELAY.resolveModelAttribute(context, config).asLong());
        settings.setPageSizeBytes(CommonAttributes.PAGE_SIZE_BYTES_NODE_NAME.resolveModelAttribute(context, config).asLong());
        settings.setSendToDLAOnNoRoute(CommonAttributes.SEND_TO_DLA_ON_NO_ROUTE.resolveModelAttribute(context, config).asBoolean());
        return settings;
    }

    static SimpleString asSimpleString(ModelNode node, String defVal) {
        return SimpleString.toSimpleString((String)(node.getType() != ModelType.UNDEFINED ? node.asString() : defVal));
    }

    static HornetQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(hqServiceName);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getAddressSettingAdd(locale);
    }
}

