/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAttribute;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MessagingDescriptions {
    static final String RESOURCE_NAME = MessagingDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private MessagingDescriptions() {
    }

    public static ModelNode getGetLastSentMessageId(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, "get-last-sent-message-id", "jms-server", "session-id", ModelType.STRING, false, ModelType.STRING, true);
        ModelNode addr = result.get(new String[]{"request-properties", "address-name"});
        addr.get("description").set(bundle2.getString("jms-server.address-name"));
        addr.get("type").set(ModelType.STRING);
        addr.get("required").set(true);
        addr.get("nillable").set(false);
        return result;
    }

    public static ModelNode getGetRoles(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getSingleParamSimpleReplyOperation((ResourceBundle)bundle2, (String)"get-roles", (String)"hornetq-server", (String)"address-match", (ModelType)ModelType.STRING, (boolean)false, (ModelType)ModelType.LIST, (boolean)true);
        ModelNode valueType = result.get(new String[]{"reply-properties", "value-type"});
        ModelNode roleName = valueType.get("name");
        roleName.get("description").set(bundle2.getString("security-role.name"));
        roleName.get("type").set(ModelType.STRING);
        roleName.get("nillable").set(false);
        roleName.get("min-length").set(1);
        for (AttributeDefinition attr : SecurityRoleAdd.ROLE_ATTRIBUTES) {
            String attrName = attr.getName();
            ModelNode attrNode = valueType.get(attrName);
            attrNode.get("description").set(bundle2.getString("security-role." + attrName));
            attrNode.get("type").set(ModelType.BOOLEAN);
            attrNode.get("nillable").set(false);
        }
        return result;
    }

    public static ModelNode getQueueResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("queue"));
        for (AttributeDefinition attr : CommonAttributes.CORE_QUEUE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "queue", node);
        }
        ModelNode attributes = node.get("attributes");
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "id", ModelType.LONG, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "paused", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "temporary", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "message-count", ModelType.LONG, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "scheduled-count", ModelType.LONG, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "consumer-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "delivering-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "queue", attributes, "messages-added", ModelType.LONG, false, MeasurementUnit.NONE);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getQueueAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("queue.add"));
        for (AttributeDefinition attr : CommonAttributes.CORE_QUEUE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "queue", node);
        }
        return node;
    }

    public static ModelNode getQueueRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "queue");
    }

    public static ModelNode getListScheduledMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"list-scheduled-messages", (String)"queue");
        ModelNode repProps = result.get("reply-properties");
        repProps.get("description").set(bundle2.getString("queue.list-scheduled-messages.reply"));
        repProps.get("type").set(ModelType.LIST);
        MessagingDescriptions.populateCoreMessageDescription(bundle2, repProps.get("value-type"));
        return result;
    }

    public static ModelNode getListMessages(Locale locale, boolean forJMS, boolean json) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        String opName = json ? "list-messages-as-json" : "list-messages";
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)opName, (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        ModelNode repProps = result.get("reply-properties");
        repProps.get("description").set(bundle2.getString("queue.list-messages.reply"));
        if (json) {
            repProps.get("type").set(ModelType.STRING);
        } else {
            repProps.get("type").set(ModelType.LIST);
            if (forJMS) {
                MessagingDescriptions.populateJMSMessageDescription(bundle2, repProps.get("value-type"));
            } else {
                MessagingDescriptions.populateCoreMessageDescription(bundle2, repProps.get("value-type"));
            }
        }
        return result;
    }

    private static void populateFilterParam(ResourceBundle bundle2, ModelNode filter) {
        filter.get("description").set(bundle2.getString("queue.filter"));
        filter.get("type").set(ModelType.STRING);
        filter.get("required").set(false);
        filter.get("nillable").set(true);
    }

    private static void populateCoreMessageDescription(ResourceBundle bundle2, ModelNode node) {
        ModelNode msgId = node.get("messageID");
        msgId.get("description").set(bundle2.getString("queue.message.messageID"));
        msgId.get("type").set(ModelType.STRING);
        msgId.get("nillable").set(false);
        ModelNode userId = node.get("userID");
        userId.get("description").set(bundle2.getString("queue.message.userID"));
        userId.get("type").set(ModelType.STRING);
        userId.get("nillable").set(true);
        ModelNode address = node.get("address");
        address.get("description").set(bundle2.getString("queue.message.address"));
        address.get("type").set(ModelType.STRING);
        address.get("nillable").set(false);
        ModelNode type = node.get("type");
        type.get("description").set(bundle2.getString("queue.message.type"));
        type.get("type").set(ModelType.INT);
        type.get("nillable").set(false);
        type.get("allowed").add(0);
        type.get("allowed").add(2);
        type.get("allowed").add(3);
        type.get("allowed").add(4);
        type.get("allowed").add(5);
        type.get("allowed").add(6);
        ModelNode durable = node.get("durable");
        durable.get("description").set(bundle2.getString("queue.message.durable"));
        durable.get("type").set(ModelType.INT);
        durable.get("nillable").set(false);
        ModelNode expiration = node.get("expiration");
        expiration.get("description").set(bundle2.getString("queue.message.expiration"));
        expiration.get("type").set(ModelType.LONG);
        expiration.get("nillable").set(false);
        ModelNode timestamp = node.get("timestamp");
        timestamp.get("description").set(bundle2.getString("queue.message.timestamp"));
        timestamp.get("type").set(ModelType.LONG);
        timestamp.get("nillable").set(false);
        ModelNode priority = node.get("priority");
        priority.get("description").set(bundle2.getString("queue.message.priority"));
        priority.get("type").set(ModelType.INT);
        priority.get("nillable").set(false);
        priority.get("min").set(0);
        priority.get("max").set(9);
    }

    public static ModelNode getCountMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"count-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.LONG);
        return result;
    }

    public static ModelNode getRemoveMessage(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"remove-message", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.remove-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    private static void populateMessageIDParam(ResourceBundle bundle2, ModelNode messageID, boolean forJMS) {
        messageID.get("description").set(bundle2.getString("queue.message-id"));
        messageID.get("type").set(forJMS ? ModelType.STRING : ModelType.LONG);
        messageID.get("required").set(false);
        messageID.get("nillable").set(true);
    }

    public static ModelNode getRemoveMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"remove-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.remove-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getExpireMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"expire-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.expire-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getExpireMessage(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"expire-message", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.expire-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    public static ModelNode getSendMessageToDeadLetterAddress(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"send-message-to-dead-letter-address", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.send-message-to-dead-letter-address.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    public static ModelNode getSendMessagesToDeadLetterAddress(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"send-messages-to-dead-letter-address", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.send-messages-to-dead-letter-address.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getChangeMessagePriority(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"change-message-priority", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        MessagingDescriptions.populatePriorityParam(bundle2, result.get(new String[]{"request-properties", "new-priority"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.expire-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    public static ModelNode getChangeMessagesPriority(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"change-messages-priority", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        MessagingDescriptions.populatePriorityParam(bundle2, result.get(new String[]{"request-properties", "new-priority"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.remove-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    private static void populatePriorityParam(ResourceBundle bundle2, ModelNode priority) {
        priority.get("description").set(bundle2.getString("queue.change-message-priority.new-priority"));
        priority.get("type").set(ModelType.INT);
        priority.get("required").set(true);
        priority.get("min").set(0);
        priority.get("max").set(9);
    }

    public static ModelNode getMoveMessage(Locale locale, boolean forJMS) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"move-message", (String)"queue");
        MessagingDescriptions.populateMessageIDParam(bundle2, result.get(new String[]{"request-properties", "message-id"}), forJMS);
        MessagingDescriptions.populateOtherQueueParam(bundle2, result.get(new String[]{"request-properties", "other-queue-name"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.move-message.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.BOOLEAN);
        return result;
    }

    private static void populateOtherQueueParam(ResourceBundle bundle2, ModelNode otherQueue) {
        otherQueue.get("description").set(bundle2.getString("queue.move-message.other-queue-name"));
        otherQueue.get("type").set(ModelType.STRING);
        otherQueue.get("required").set(true);
        otherQueue.get("nillable").set(false);
    }

    public static ModelNode getMoveMessages(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)"move-messages", (String)"queue");
        MessagingDescriptions.populateFilterParam(bundle2, result.get(new String[]{"request-properties", CommonAttributes.FILTER.getName()}));
        MessagingDescriptions.populateOtherQueueParam(bundle2, result.get(new String[]{"request-properties", "other-queue-name"}));
        result.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("queue.move-messages.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    static ModelNode getJmsQueueResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("jms-queue"));
        for (AttributeDefinition attr : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "jms-queue", node);
        }
        ModelNode attributes = node.get("attributes");
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, CommonAttributes.QUEUE_ADDRESS.getName(), ModelType.STRING, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, CommonAttributes.EXPIRY_ADDRESS.getName(), ModelType.STRING, true, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, CommonAttributes.DEAD_LETTER_ADDRESS.getName(), ModelType.STRING, true, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, "paused", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, "temporary", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, "message-count", ModelType.LONG, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, "scheduled-count", ModelType.LONG, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, "consumer-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, "delivering-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-queue", attributes, "messages-added", ModelType.LONG, false, MeasurementUnit.NONE);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getJmsQueueAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("jms-queue.add"));
        for (AttributeDefinition attr : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "jms-queue", node);
        }
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getJmsQueueRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "jms-queue");
    }

    static ModelNode getTopic(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("jms-topic"));
        CommonAttributes.ENTRIES.addResourceAttributeDescription(bundle2, "jms-topic", node);
        ModelNode attributes = node.get("attributes");
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "topic-address", ModelType.STRING, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "temporary", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "message-count", ModelType.LONG, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "delivering-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "messages-added", ModelType.LONG, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "durable-message-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "non-durable-message-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "subscription-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "durable-subscription-count", ModelType.INT, false, MeasurementUnit.NONE);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "jms-topic", attributes, "non-durable-subscription-count", ModelType.INT, false, MeasurementUnit.NONE);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getTopicAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("jms-topic.add"));
        CommonAttributes.ENTRIES.addOperationParameterDescription(bundle2, "jms-topic", node);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getTopicRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "jms-topic");
    }

    public static ModelNode getListSubscriptionsOperation(Locale locale, String operationName) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = CommonDescriptions.getNoArgSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)"jms-topic", (ModelType)ModelType.LIST, (boolean)true);
        ModelNode queueName = result.get(new String[]{"reply-properties", "value-type", "queueName"});
        queueName.get("description").set(bundle2.getString("jms-topic.list-subscriptions.queueName"));
        queueName.get("type").set(ModelType.STRING);
        queueName.get("nillable").set(false);
        ModelNode clientID = result.get(new String[]{"reply-properties", "value-type", "clientID"});
        clientID.get("description").set(bundle2.getString("jms-topic.list-subscriptions.clientID"));
        clientID.get("type").set(ModelType.STRING);
        clientID.get("nillable").set(false);
        ModelNode selector = result.get(new String[]{"reply-properties", "value-type", "selector"});
        selector.get("description").set(bundle2.getString("jms-topic.list-subscriptions.selector"));
        selector.get("type").set(ModelType.STRING);
        selector.get("nillable").set(true);
        ModelNode name = result.get(new String[]{"reply-properties", "value-type", "name"});
        name.get("description").set(bundle2.getString("jms-topic.list-subscriptions.name"));
        name.get("type").set(ModelType.STRING);
        name.get("nillable").set(false);
        ModelNode durable = result.get(new String[]{"reply-properties", "value-type", "durable"});
        durable.get("description").set(bundle2.getString("jms-topic.list-subscriptions.durable"));
        durable.get("type").set(ModelType.BOOLEAN);
        durable.get("nillable").set(false);
        ModelNode messageCount = result.get(new String[]{"reply-properties", "value-type", "messageCount"});
        messageCount.get("description").set(bundle2.getString("jms-topic.list-subscriptions.messageCount"));
        messageCount.get("type").set(ModelType.LONG);
        messageCount.get("nillable").set(false);
        messageCount.get("unit").set(MeasurementUnit.NONE.getName());
        ModelNode deliveringCount = result.get(new String[]{"reply-properties", "value-type", "deliveringCount"});
        deliveringCount.get("description").set(bundle2.getString("jms-topic.list-subscriptions.deliveringCount"));
        deliveringCount.get("type").set(ModelType.INT);
        deliveringCount.get("nillable").set(false);
        deliveringCount.get("unit").set(MeasurementUnit.NONE.getName());
        ModelNode consumers = result.get(new String[]{"reply-properties", "value-type", "consumers"});
        consumers.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers"));
        consumers.get("type").set(ModelType.LIST);
        consumers.get("nillable").set(false);
        consumers.get("min-length").set(0);
        ModelNode consumerId = consumers.get(new String[]{"value-type", "consumerID"});
        consumerId.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.consumerID"));
        consumerId.get("type").set(ModelType.LONG);
        consumerId.get("nillable").set(false);
        ModelNode connectionId = consumers.get(new String[]{"value-type", "connectionID"});
        connectionId.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.connectionID"));
        connectionId.get("type").set(ModelType.STRING);
        connectionId.get("nillable").set(false);
        ModelNode sessionId = consumers.get(new String[]{"value-type", "sessionID"});
        sessionId.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.sessionID"));
        sessionId.get("type").set(ModelType.STRING);
        sessionId.get("nillable").set(true);
        ModelNode browseOnly = consumers.get(new String[]{"value-type", "browseOnly"});
        browseOnly.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.browseOnly"));
        browseOnly.get("type").set(ModelType.BOOLEAN);
        browseOnly.get("nillable").set(false);
        ModelNode creationTime = consumers.get(new String[]{"value-type", "creationTime"});
        creationTime.get("description").set(bundle2.getString("jms-topic.list-subscriptions.consumers.creationTime"));
        creationTime.get("type").set(ModelType.LONG);
        creationTime.get("nillable").set(false);
        return result;
    }

    public static ModelNode getListMessagesForSubscription(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = MessagingDescriptions.getListMessagesBase(bundle2, "list-messages-for-subscription");
        ModelNode replyProps = result.get("reply-properties");
        replyProps.get("description").set(bundle2.getString("jms-topic.list-messages-for-subscription.reply"));
        replyProps.get("type").set(ModelType.LIST);
        MessagingDescriptions.populateJMSMessageDescription(bundle2, replyProps.get("value-type"));
        return result;
    }

    private static void populateJMSMessageDescription(ResourceBundle bundle2, ModelNode node) {
        ModelNode priority = node.get("JMSPriority");
        priority.get("description").set(bundle2.getString("jms-queue.message.JMSPriority"));
        priority.get("type").set(ModelType.INT);
        ModelNode timestamp = node.get("JMSTimestamp");
        timestamp.get("description").set(bundle2.getString("jms-queue.message.JMSTimestamp"));
        timestamp.get("type").set(ModelType.LONG);
        ModelNode expiration = node.get("JMSExpiration");
        expiration.get("description").set(bundle2.getString("jms-queue.message.JMSExpiration"));
        expiration.get("type").set(ModelType.LONG);
        ModelNode deliveryMode = node.get("JMSDeliveryMode");
        deliveryMode.get("description").set(bundle2.getString("jms-queue.message.JMSDeliveryMode"));
        deliveryMode.get("type").set(ModelType.STRING);
        deliveryMode.get("nillable").set(false);
        deliveryMode.get("allowed").add("PERSISTENT");
        deliveryMode.get("allowed").add("NON_PERSISTENT");
        ModelNode messageId = node.get("JMSMessageID");
        messageId.get("description").set(bundle2.getString("jms-queue.message.JMSMessageID"));
        messageId.get("type").set(ModelType.STRING);
        messageId.get("nillable").set(true);
    }

    public static ModelNode getListMessagesForSubscriptionAsJSON(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = MessagingDescriptions.getListMessagesBase(bundle2, "list-messages-for-subscription-as-json");
        ModelNode replyProps = result.get("reply-properties");
        replyProps.get("description").set("jms-topic.list-messages-for-subscription-as-json.reply");
        replyProps.get("type").set(ModelType.STRING);
        return result;
    }

    private static ModelNode getListMessagesBase(ResourceBundle bundle2, String operationName) {
        ModelNode result = new ModelNode();
        result.get("operation-name").set(operationName);
        result.get("description").set(bundle2.getString("jms-topic." + operationName));
        ModelNode nameProp = result.get(new String[]{"request-properties", CommonAttributes.QUEUE_NAME.getName()});
        nameProp.get("description").set(bundle2.getString("jms-topic.list-messages-for-subscription.queue-name"));
        nameProp.get("type").set(ModelType.STRING);
        nameProp.get("required").set(true);
        nameProp.get("nillable").set(false);
        return result;
    }

    public static ModelNode getCountMessagesForSubscription(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("count-messages-for-subscription");
        result.get("description").set(bundle2.getString("jms-topic.count-messages-for-subscription"));
        ModelNode reqProps = result.get("request-properties");
        ModelNode clientId = reqProps.get(CommonAttributes.CLIENT_ID.getName());
        clientId.get("description").set(bundle2.getString("jms-topic.client-id"));
        clientId.get("type").set(ModelType.STRING);
        clientId.get("nillable").set(false);
        ModelNode subscriptionName = reqProps.get("subscription-name");
        subscriptionName.get("description").set(bundle2.getString("jms-topic.subscription-name"));
        subscriptionName.get("type").set(ModelType.STRING);
        subscriptionName.get("nillable").set(false);
        ModelNode filter = reqProps.get(CommonAttributes.FILTER.getName());
        filter.get("description").set(bundle2.getString("jms-topic.filter"));
        filter.get("type").set(ModelType.STRING);
        filter.get("nillable").set(true);
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.INT);
        return result;
    }

    public static ModelNode getDropDurableSubscription(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("drop-durable-subscription");
        result.get("description").set(bundle2.getString("jms-topic.drop-durable-subscription"));
        ModelNode reqProps = result.get("request-properties");
        ModelNode clientId = reqProps.get(CommonAttributes.CLIENT_ID.getName());
        clientId.get("description").set(bundle2.getString("jms-topic.client-id"));
        clientId.get("type").set(ModelType.STRING);
        clientId.get("nillable").set(false);
        ModelNode subscriptionName = reqProps.get("subscription-name");
        subscriptionName.get("description").set(bundle2.getString("jms-topic.subscription-name"));
        subscriptionName.get("type").set(ModelType.STRING);
        subscriptionName.get("nillable").set(false);
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    static ModelNode getConnectionFactory(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("connection-factory"));
        MessagingDescriptions.addConnectionFactoryProperties(bundle2, node, true);
        ModelNode attributes = node.get("attributes");
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "connection-factory", attributes, CommonAttributes.HA.getName(), ModelType.BOOLEAN, false, null);
        CommonAttributes.CONNECTION_FACTORY_TYPE.addResourceAttributeDescription(bundle2, "connection-factory", node);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "connection-factory", attributes, "initial-message-packet-size", ModelType.INT, false, MeasurementUnit.BYTES);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    static ModelNode getConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("connection-factory.add"));
        MessagingDescriptions.addConnectionFactoryProperties(bundle2, node, false);
        CommonAttributes.CONNECTION_FACTORY_TYPE.addOperationParameterDescription(bundle2, "connection-factory", node);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getConnectionFactoryRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "connection-factory");
    }

    static ModelNode getPooledConnectionFactory(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("pooled-connection-factory"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle2, node, true);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    static ModelNode getPooledConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("pooled-connection-factory.add"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle2, node, false);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addPooledConnectionFactoryProperties(ResourceBundle bundle2, ModelNode node, boolean resource) {
        for (AttributeDefinition attr : PooledConnectionFactoryAttribute.getDefinitions(JMSServices.POOLED_CONNECTION_FACTORY_ATTRS)) {
            if (resource) {
                attr.addResourceAttributeDescription(bundle2, "pooled-connection-factory", node);
            } else {
                attr.addOperationParameterDescription(bundle2, "pooled-connection-factory", node);
            }
            if (!attr.getName().equals("connector")) continue;
            String propType = resource ? "attributes" : "request-properties";
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(ModelType.STRING);
        }
    }

    static ModelNode getPooledConnectionFactoryRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "pooled-connection-factory");
    }

    private static void addConnectionFactoryProperties(ResourceBundle bundle2, ModelNode node, boolean resource) {
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            if (resource) {
                attr.addResourceAttributeDescription(bundle2, "connection-factory", node);
            } else {
                attr.addOperationParameterDescription(bundle2, "connection-factory", node);
            }
            if (!attr.getName().equals("connector")) continue;
            String propType = resource ? "attributes" : "request-properties";
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(ModelType.STRING);
        }
    }

    static ModelNode getDivertResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("divert"));
        for (AttributeDefinition attr : CommonAttributes.DIVERT_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "divert", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    static ModelNode getDivertAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("divert.add"));
        for (AttributeDefinition attr : CommonAttributes.DIVERT_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "divert", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getDivertRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "divert");
    }

    static ModelNode getBroadcastGroupResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("broadcast-group"));
        for (AttributeDefinition attr : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "broadcast-group", root);
        }
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "broadcast-group", root.get("attributes"), "started", ModelType.BOOLEAN, false, null);
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    static ModelNode getBroadcastGroupAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("broadcast-group.add"));
        for (AttributeDefinition attr : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "broadcast-group", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getBroadcastGroupRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "broadcast-group");
    }

    static ModelNode getDiscoveryGroupResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("discovery-group"));
        for (AttributeDefinition attr : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "discovery-group", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    static ModelNode getDiscoveryGroupAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("discovery-group.add"));
        for (AttributeDefinition attr : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "discovery-group", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getDiscoveryGroupRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "discovery-group");
    }

    static ModelNode getGroupingHandlerResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("grouping-handler"));
        for (AttributeDefinition attr : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "grouping-handler", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getGroupingHandlerAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("grouping-handler.add"));
        for (AttributeDefinition attr : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "grouping-handler", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getGroupingHandlerRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "grouping-handler");
    }

    static ModelNode getBridgeResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("bridge"));
        for (AttributeDefinition attr : CommonAttributes.BRIDGE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "bridge", root);
        }
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "bridge", root.get("attributes"), "started", ModelType.BOOLEAN, false, null);
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getBridgeAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("bridge.add"));
        for (AttributeDefinition attr : CommonAttributes.BRIDGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "bridge", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getBridgeRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "bridge");
    }

    static ModelNode getClusterConnectionResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("cluster-connection"));
        for (AttributeDefinition attr : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "cluster-connection", root);
        }
        ModelNode attrs = root.get("attributes");
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "cluster-connection", attrs, "node-id", ModelType.STRING, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "cluster-connection", attrs, "topology", ModelType.STRING, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "cluster-connection", attrs, "started", ModelType.BOOLEAN, false, null);
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getClusterConnectionAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("cluster-connection.add"));
        for (AttributeDefinition attr : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "cluster-connection", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getClusterConnectionRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "cluster-connection");
    }

    public static ModelNode getGetNodes(Locale locale) {
        ModelNode result = MessagingDescriptions.getDescriptionOnlyOperation(locale, "get-nodes", "cluster-connection");
        result.get(new String[]{"reply-properties", "description"}).set(MessagingDescriptions.getResourceBundle(locale).getString("cluster-connection.get-nodes.reply"));
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.OBJECT);
        result.get(new String[]{"reply-properties", "value-type"}).set(ModelType.STRING);
        return result;
    }

    static ModelNode getConnectorServiceResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("connector-service"));
        for (AttributeDefinition attr : CommonAttributes.CONNECTOR_SERVICE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "connector-service", root);
        }
        root.get("operations");
        MessagingDescriptions.getParamChildrenDescription(bundle2, root, "connector-service");
        return root;
    }

    private static void getParamChildrenDescription(ResourceBundle bundle2, ModelNode parent, String prefix) {
        parent.get(new String[]{"children", "param", "description"}).set(bundle2.getString(prefix + ".param"));
        parent.get(new String[]{"children", "param", "min-occurs"}).set(0);
        parent.get(new String[]{"children", "param", "model-description"});
    }

    public static ModelNode getConnectorServiceAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("connector-service.add"));
        for (AttributeDefinition attr : CommonAttributes.CONNECTOR_SERVICE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "connector-service", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorServiceRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "connector-service");
    }

    static ModelNode getConnectorServiceParamResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("connector-service.param"));
        CommonAttributes.VALUE.addResourceAttributeDescription(bundle2, "connector-service.param", root);
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getConnectorServiceParamAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("connector-service.param.add"));
        CommonAttributes.VALUE.addOperationParameterDescription(bundle2, "connector-service.param", op);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorServiceParamRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "connector-service.param");
    }

    private static ModelNode addParamsParameterDescription(ModelNode operation, String description, ResourceBundle bundle2) {
        ModelNode node = operation.get(new String[]{"request-properties", "param"});
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle2.getString(description));
        node.get("required").set(false);
        node.get("value-type").set(ModelType.STRING);
        return node;
    }

    static ModelNode getAcceptor(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("acceptor"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.GENERIC) {
            attr.addResourceAttributeDescription(bundle2, null, root);
        }
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "acceptor", root.get("attributes"), "started", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.getParamChildrenDescription(bundle2, root, "acceptor");
        return root;
    }

    static ModelNode getAcceptorAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("acceptor.add"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.GENERIC) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "acceptor.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getAcceptorRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "acceptor");
    }

    static ModelNode getAddressSetting(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("address-setting"));
        for (SimpleAttributeDefinition def : AddressSettingAdd.ATTRIBUTES) {
            def.addResourceAttributeDescription(bundle2, "address-setting", root);
        }
        return root;
    }

    static ModelNode getAddressSettingAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("address-setting.add"));
        for (SimpleAttributeDefinition def : AddressSettingAdd.ATTRIBUTES) {
            def.addOperationParameterDescription(bundle2, "address-setting", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getAddressSettingRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "address-setting");
    }

    static ModelNode getRemoteAcceptor(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("remote-acceptor"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.REMOTE) {
            attr.addResourceAttributeDescription(bundle2, null, root);
        }
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "acceptor", root.get("attributes"), "started", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.getParamChildrenDescription(bundle2, root, "acceptor");
        return root;
    }

    static ModelNode getRemoteAcceptorAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("acceptor.add"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.REMOTE) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "acceptor.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getInVMAcceptor(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("in-vm-acceptor"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.IN_VM) {
            attr.addResourceAttributeDescription(bundle2, null, root);
        }
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "acceptor", root.get("attributes"), "started", ModelType.BOOLEAN, false, null);
        MessagingDescriptions.getParamChildrenDescription(bundle2, root, "acceptor");
        return root;
    }

    static ModelNode getInVMAcceptorAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("acceptor.add"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.IN_VM) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "acceptor.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnector(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("connector"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.GENERIC) {
            attr.addResourceAttributeDescription(bundle2, null, root);
        }
        MessagingDescriptions.getParamChildrenDescription(bundle2, root, "connector");
        return root;
    }

    static ModelNode getConnectorAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("connector.add"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.GENERIC) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "connector.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "connector");
    }

    static ModelNode getRemoteConnector(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("remote-connector"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.REMOTE) {
            attr.addResourceAttributeDescription(bundle2, null, root);
        }
        MessagingDescriptions.getParamChildrenDescription(bundle2, root, "connector");
        return root;
    }

    static ModelNode getRemoteConnectorAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("connector.add"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.REMOTE) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "connector.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getInVMConnector(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("in-vm-connector"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.IN_VM) {
            attr.addResourceAttributeDescription(bundle2, null, root);
        }
        MessagingDescriptions.getParamChildrenDescription(bundle2, root, "connector");
        return root;
    }

    static ModelNode getInVMConnectorAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("connector.add"));
        for (AttributeDefinition attr : TransportConfigOperationHandlers.IN_VM) {
            attr.addOperationParameterDescription(bundle2, null, op);
        }
        MessagingDescriptions.addParamsParameterDescription(op, "connector.add.params", bundle2);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getParam(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("transport-config.param"));
        root.get(new String[]{"attributes", "value", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "value", "description"}).set(bundle2.getString("transport-config.param.value"));
        return root;
    }

    static ModelNode getParamAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle2.getString("transport-config.param.add"));
        op.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
        op.get(new String[]{"request-properties", "value", "description"}).set(bundle2.getString("transport-config.param.value"));
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getParamRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "transport-config.param");
    }

    public static ModelNode getPathResource(Locale locale, String pathType) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString(pathType + ".path"));
        for (AttributeDefinition attr : MessagingPathHandlers.ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle2, "path", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getPathAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("path.add"));
        for (AttributeDefinition attr : MessagingPathHandlers.ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle2, "path", node);
        }
        return node;
    }

    public static ModelNode getPathRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "path");
    }

    public static ModelNode getSecuritySettingResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("security-setting"));
        root.get(new String[]{"children", "role", "description"}).set(bundle2.getString("security-role"));
        root.get(new String[]{"children", "role", "min-occurs"}).set(0);
        root.get(new String[]{"children", "role", "model-description"});
        return root;
    }

    public static ModelNode getSecuritySettingAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("security-setting.add"));
        return node;
    }

    public static ModelNode getSecuritySettingRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "security-setting");
    }

    public static ModelNode getSecurityRoleResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("security-role"));
        for (AttributeDefinition def : SecurityRoleAdd.ROLE_ATTRIBUTES) {
            def.addResourceAttributeDescription(bundle2, "security-role", root);
        }
        return root;
    }

    public static ModelNode getSecurityRoleAdd(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("security-role.add"));
        for (AttributeDefinition def : SecurityRoleAdd.ROLE_ATTRIBUTES) {
            def.addOperationParameterDescription(bundle2, "security-role", node);
        }
        return node;
    }

    public static ModelNode getSecurityRoleRemove(Locale locale) {
        return MessagingDescriptions.getDescriptionOnlyOperation(locale, "remove", "security-role");
    }

    public static ModelNode getDescriptionOnlyOperation(Locale locale, String operationName, String descriptionPrefix) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getDescriptionOnlyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix);
    }

    public static ModelNode getNoArgSimpleReplyOperation(Locale locale, String operationName, String descriptionPrefix, ModelType replyType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getNoArgSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (ModelType)replyType, (boolean)describeReply);
    }

    public static ModelNode getSingleParamSimpleReplyOperation(Locale locale, String operationName, String descriptionPrefix, String paramName, ModelType paramType, boolean paramNillable, ModelType replyType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSingleParamSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (String)paramName, (ModelType)paramType, (boolean)paramNillable, (ModelType)replyType, (boolean)describeReply);
    }

    public static ModelNode getSingleParamSimpleListReplyOperation(Locale locale, String operationName, String descriptionPrefix, String paramName, ModelType paramType, boolean paramNillable, ModelType listValueType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSingleParamSimpleReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (String)paramName, (ModelType)paramType, (boolean)paramNillable, (ModelType)listValueType, (boolean)describeReply);
    }

    public static ModelNode getNoArgSimpleListReplyOperation(Locale locale, String operationName, String descriptionPrefix, ModelType listValueType, boolean describeReply) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getNoArgSimpleListReplyOperation((ResourceBundle)bundle2, (String)operationName, (String)descriptionPrefix, (ModelType)listValueType, (boolean)describeReply);
    }

    public static ModelNode getAddJndiOperation(Locale locale, String resourceType) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("add-jndi");
        result.get("description").set(bundle2.getString(resourceType + "." + "add-jndi"));
        ModelNode binding = result.get(new String[]{"request-properties", "jndi-binding"});
        binding.get("description").set(bundle2.getString("jndi-binding"));
        binding.get("type").set(ModelType.STRING);
        binding.get("required").set(true);
        binding.get("nillable").set(false);
        binding.get("min-length").set(1);
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    public static ModelNode getCoreAddressResource(Locale locale) {
        ResourceBundle bundle2 = MessagingDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("description").set(bundle2.getString("core-address"));
        ModelNode attrs = result.get("attributes");
        ModelNode roles = MessagingDescriptions.addResourceAttributeDescription(bundle2, "core-address", attrs, "roles", ModelType.LIST, false, null);
        ModelNode rolesValue = roles.get("value-type");
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, "name", ModelType.STRING, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, SecurityRoleAdd.SEND.getName(), ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, SecurityRoleAdd.CONSUME.getName(), ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, SecurityRoleAdd.CREATE_DURABLE_QUEUE.getName(), ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, SecurityRoleAdd.DELETE_DURABLE_QUEUE.getName(), ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, SecurityRoleAdd.CREATE_NON_DURABLE_QUEUE.getName(), ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, SecurityRoleAdd.DELETE_NON_DURABLE_QUEUE.getName(), ModelType.BOOLEAN, false, null);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "security-role", rolesValue, SecurityRoleAdd.MANAGE.getName(), ModelType.BOOLEAN, false, null);
        ModelNode queues = MessagingDescriptions.addResourceAttributeDescription(bundle2, "core-address", attrs, "queue-names", ModelType.LIST, false, null);
        queues.get("value-type").set(ModelType.STRING);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "core-address", attrs, "number-of-bytes-per-page", ModelType.LONG, false, MeasurementUnit.BYTES);
        MessagingDescriptions.addResourceAttributeDescription(bundle2, "core-address", attrs, "number-of-pages", ModelType.INT, false, MeasurementUnit.NONE);
        ModelNode bindings = MessagingDescriptions.addResourceAttributeDescription(bundle2, "core-address", attrs, "binding-names", ModelType.LIST, false, null);
        bindings.get("value-type").set(ModelType.STRING);
        result.get("operations");
        result.get("children").setEmptyObject();
        return result;
    }

    private static ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode attributes, String attrName, ModelType type, boolean nillable, MeasurementUnit measurementUnit) {
        ModelNode attr = attributes.get(attrName);
        attr.get("description").set(bundle2.getString(prefix + "." + attrName));
        attr.get("type").set(type);
        attr.get("nillable").set(nillable);
        if (measurementUnit != null) {
            attr.get("unit").set(measurementUnit.getName());
        }
        return attr;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

