/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import java.util.Locale;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.as.messaging.jms.JndiEntriesAttribute;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JMSTopicAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final JMSTopicAdd INSTANCE = new JMSTopicAdd();

    public static ModelNode getOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (existing.hasDefined(CommonAttributes.ENTRIES.getName())) {
            op.get(CommonAttributes.ENTRIES.getName()).set(existing.get(CommonAttributes.ENTRIES.getName()));
        }
        return op;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.ENTRIES.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode entries = CommonAttributes.ENTRIES.resolveModelAttribute(context, model);
        String[] jndiBindings = JndiEntriesAttribute.getJndiBindings(entries);
        this.installServices(verificationHandler, newControllers, name, hqServiceName, serviceTarget, jndiBindings);
    }

    public void installServices(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ServiceName hqServiceName, ServiceTarget serviceTarget, String[] jndiBindings) {
        JMSTopicService service = new JMSTopicService(name, jndiBindings);
        ServiceName serviceName = JMSServices.getJmsTopicBaseServiceName(hqServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.getJmsServer()).setInitialMode(ServiceController.Mode.ACTIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.getExecutorInjector(), (boolean)false);
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getTopicAdd(locale);
    }
}

