/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;

public enum Attribute {
    UNKNOWN((String)null),
    ALLOW_DIRECT_CONNECTIONS_ONLY((AttributeDefinition)ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY),
    BACKUP_CONNECTOR_NAME("backup-connector-name"),
    CONNECTOR_NAME("connector-name"),
    KEY("key"),
    MATCH("match"),
    NAME("name"),
    PATH("path"),
    RELATIVE_TO((AttributeDefinition)MessagingPathHandlers.RELATIVE_TO),
    ROLES_ATTR_NAME("roles"),
    SERVER_ID((AttributeDefinition)InVMTransportDefinition.SERVER_ID),
    SOCKET_BINDING((AttributeDefinition)RemoteTransportDefinition.SOCKET_BINDING),
    STRING("string"),
    TYPE_ATTR_NAME("type"),
    VALUE((AttributeDefinition)ConnectorServiceParamDefinition.VALUE),
    MODULE((AttributeDefinition)JMSBridgeDefinition.MODULE);

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
        this.definition = null;
    }

    private Attribute(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

