/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class ModClusterSubsystemAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final ModClusterSubsystemAdd INSTANCE = new ModClusterSubsystemAdd();
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.modcluster");

    ModClusterSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.set(operation.get("mod-cluster-config"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode node;
        String bindingRef = null;
        if (operation.hasDefined("mod-cluster-config") && (node = operation.get("mod-cluster-config")).hasDefined("advertise-socket")) {
            bindingRef = node.get("advertise-socket").asString();
        }
        try {
            ModClusterService service = new ModClusterService(operation.get("mod-cluster-config").clone());
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(ModClusterService.NAME, (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE);
            if (bindingRef != null) {
                serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding());
            }
            newControllers.add(serviceBuilder.install());
        }
        catch (Throwable t) {
            log.error((Object)("Error: " + t));
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getSubsystemAddDescription(locale);
    }
}

