/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class ModClusterAddMetric
implements OperationStepHandler,
DescriptionProvider {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.modcluster");
    static final ModClusterAddMetric INSTANCE = new ModClusterAddMetric();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getAddMetricDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode dynamicLoadProvider = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("dynamic-load-provider");
                    ModelNode metric = new ModelNode();
                    List list = operation.asPropertyList();
                    for (Property prop : list) {
                        if (prop.getName().equals("property")) {
                            String properties = prop.getValue().asString();
                            ModelNode props = ModelNode.fromString((String)properties);
                            metric.get("property").set(props);
                            continue;
                        }
                        metric.get(prop.getName()).set(prop.getValue().asString());
                    }
                    if (!metric.get("type").isDefined()) {
                        throw new OperationFailedException(new ModelNode().set("A type attribute is needed for add-metric"));
                    }
                    if (!dynamicLoadProvider.isDefined()) {
                        dynamicLoadProvider.get("history").set(9);
                        dynamicLoadProvider.get("decay").set(2);
                    }
                    this.replaceMetric(dynamicLoadProvider, metric);
                    context.completeStep();
                }

                private void replaceMetric(ModelNode dynamicLoadProvider, ModelNode metric) {
                    List newlist = Collections.emptyList();
                    if (dynamicLoadProvider.get("load-metric").isDefined()) {
                        List list = dynamicLoadProvider.get("load-metric").asList();
                        String type = metric.get("type").asString();
                        Iterator it = list.iterator();
                        dynamicLoadProvider.get("load-metric").set(newlist);
                        while (it.hasNext()) {
                            ModelNode node = (ModelNode)it.next();
                            if (node.get("type").asString().equals(type)) continue;
                            dynamicLoadProvider.get("load-metric").add(node);
                        }
                    } else {
                        dynamicLoadProvider.get("load-metric").set(newlist);
                    }
                    dynamicLoadProvider.get("load-metric").add(metric);
                }
            }, OperationContext.Stage.MODEL);
        }
        context.completeStep();
    }
}

