/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.modcluster.ModClusterAddCustomMetric;
import org.jboss.as.modcluster.ModClusterAddMetric;
import org.jboss.as.modcluster.ModClusterAddProxy;
import org.jboss.as.modcluster.ModClusterDisable;
import org.jboss.as.modcluster.ModClusterDisableContext;
import org.jboss.as.modcluster.ModClusterEnable;
import org.jboss.as.modcluster.ModClusterEnableContext;
import org.jboss.as.modcluster.ModClusterGetProxyConfiguration;
import org.jboss.as.modcluster.ModClusterGetProxyInfo;
import org.jboss.as.modcluster.ModClusterListProxies;
import org.jboss.as.modcluster.ModClusterRefresh;
import org.jboss.as.modcluster.ModClusterRemoveCustomMetric;
import org.jboss.as.modcluster.ModClusterRemoveMetric;
import org.jboss.as.modcluster.ModClusterRemoveProxy;
import org.jboss.as.modcluster.ModClusterReset;
import org.jboss.as.modcluster.ModClusterStop;
import org.jboss.as.modcluster.ModClusterStopContext;
import org.jboss.as.modcluster.ModClusterSubsystemAdd;
import org.jboss.as.modcluster.ModClusterSubsystemDescribe;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptionProviders;
import org.jboss.as.modcluster.ModClusterSubsystemElementParser;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ModClusterExtension
implements XMLStreamConstants,
Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.modcluster");
    public static final String SUBSYSTEM_NAME = "modcluster";
    public static final String NAMESPACE = "urn:jboss:domain:modcluster:1.0";
    final ModClusterSubsystemElementParser parser = new ModClusterSubsystemElementParser();
    private static final DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    };

    public void initialize(ExtensionContext context) {
        log.debugf("Activating Mod_cluster Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(ModClusterSubsystemDescriptionProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)ModClusterSubsystemAdd.INSTANCE, (DescriptionProvider)ModClusterSubsystemAdd.INSTANCE, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)ModClusterSubsystemDescribe.INSTANCE, (DescriptionProvider)ModClusterSubsystemDescribe.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("list-proxies", (OperationStepHandler)ModClusterListProxies.INSTANCE, (DescriptionProvider)ModClusterListProxies.INSTANCE, false);
        registration.registerOperationHandler("read-proxies-info", (OperationStepHandler)ModClusterGetProxyInfo.INSTANCE, (DescriptionProvider)ModClusterGetProxyInfo.INSTANCE, false);
        registration.registerOperationHandler("read-proxies-configuration", (OperationStepHandler)ModClusterGetProxyConfiguration.INSTANCE, (DescriptionProvider)ModClusterGetProxyConfiguration.INSTANCE, false);
        registration.registerOperationHandler("add-proxy", (OperationStepHandler)ModClusterAddProxy.INSTANCE, (DescriptionProvider)ModClusterAddProxy.INSTANCE, false);
        registration.registerOperationHandler("remove-proxy", (OperationStepHandler)ModClusterRemoveProxy.INSTANCE, (DescriptionProvider)ModClusterRemoveProxy.INSTANCE, false);
        registration.registerOperationHandler("refresh", (OperationStepHandler)ModClusterRefresh.INSTANCE, (DescriptionProvider)ModClusterRefresh.INSTANCE, false);
        registration.registerOperationHandler("reset", (OperationStepHandler)ModClusterReset.INSTANCE, (DescriptionProvider)ModClusterReset.INSTANCE, false);
        registration.registerOperationHandler("enable", (OperationStepHandler)ModClusterEnable.INSTANCE, (DescriptionProvider)ModClusterEnable.INSTANCE, false);
        registration.registerOperationHandler("disable", (OperationStepHandler)ModClusterDisable.INSTANCE, (DescriptionProvider)ModClusterDisable.INSTANCE, false);
        registration.registerOperationHandler("stop", (OperationStepHandler)ModClusterStop.INSTANCE, (DescriptionProvider)ModClusterStop.INSTANCE, false);
        registration.registerOperationHandler("enable-context", (OperationStepHandler)ModClusterEnableContext.INSTANCE, (DescriptionProvider)ModClusterEnableContext.INSTANCE, false);
        registration.registerOperationHandler("disable-context", (OperationStepHandler)ModClusterDisableContext.INSTANCE, (DescriptionProvider)ModClusterDisableContext.INSTANCE, false);
        registration.registerOperationHandler("stop-context", (OperationStepHandler)ModClusterStopContext.INSTANCE, (DescriptionProvider)ModClusterStopContext.INSTANCE, false);
        registration.registerReadWriteAttribute("advertise-socket", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("proxy-list", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("proxy-url", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("advertise", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("advertise-security-key", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("excluded-contexts", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("auto-enable-contexts", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("stop-context-timeout", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("socket-timeout", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("sticky-session", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("sticky-session-remove", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("sticky-session-force", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("worker-timeout", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("max-attemps", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("flush-packets", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("flush-wait", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("ping", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("smax", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("ttl", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("node-timeout", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("balancer", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("domain", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("dynamic-load-provider", null, (OperationStepHandler)new WriteDynamicLoadProviderOperationHandler(), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("simple-load-provider", null, (OperationStepHandler)new WriteSimpleLoadProviderOperationHandler(), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("ssl", null, (OperationStepHandler)new WriteSSLProviderOperationHandler(), AttributeAccess.Storage.CONFIGURATION);
        registration.registerOperationHandler("add-metric", (OperationStepHandler)ModClusterAddMetric.INSTANCE, (DescriptionProvider)ModClusterAddMetric.INSTANCE, false);
        registration.registerOperationHandler("add-custom-metric", (OperationStepHandler)ModClusterAddCustomMetric.INSTANCE, (DescriptionProvider)ModClusterAddCustomMetric.INSTANCE, false);
        registration.registerOperationHandler("remove-metric", (OperationStepHandler)ModClusterRemoveMetric.INSTANCE, (DescriptionProvider)ModClusterRemoveMetric.INSTANCE, false);
        registration.registerOperationHandler("remove-custom-metric", (OperationStepHandler)ModClusterRemoveCustomMetric.INSTANCE, (DescriptionProvider)ModClusterRemoveCustomMetric.INSTANCE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)this.parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)this.parser);
    }

    public static class WriteSSLProviderOperationHandler
    implements OperationStepHandler {
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode currentValue = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
            this.setSSLNodeAttribute(currentValue, operation, "password");
            this.setSSLNodeAttribute(currentValue, operation, "certificate-key-file");
            this.setSSLNodeAttribute(currentValue, operation, "cipher-suite");
            this.setSSLNodeAttribute(currentValue, operation, "protocol");
            this.setSSLNodeAttribute(currentValue, operation, "verify-client");
            this.setSSLNodeAttribute(currentValue, operation, "ca-certificate-file");
            this.setSSLNodeAttribute(currentValue, operation, "ca-revocation-url");
            context.completeStep();
        }

        public void setSSLNodeAttribute(ModelNode currentnode, ModelNode operation, String attribute) {
            ModelNode node = operation.get(attribute);
            if (node.isDefined()) {
                currentnode.get("ssl").get(attribute).set(node);
            }
        }
    }

    public static class WriteSimpleLoadProviderOperationHandler
    implements OperationStepHandler {
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode factor = operation.get("factor");
            ModelNode submodel = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode currentValue = submodel.get("simple-load-provider").clone();
            if (!factor.isDefined()) {
                factor = currentValue.get("history");
            }
            submodel.get("factor").set(factor);
            submodel.get("simple-load-provider").get("factor").set(factor);
            context.completeStep();
        }
    }

    public static class WriteDynamicLoadProviderOperationHandler
    implements OperationStepHandler {
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode history = operation.get("history");
            ModelNode decay = operation.get("decay");
            ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode currentValue = submodel.get("dynamic-load-provider").clone();
            if (!history.isDefined()) {
                history = currentValue.get("history");
            }
            submodel.get("history").set(history);
            if (!decay.isDefined()) {
                decay = currentValue.get("decay");
            }
            submodel.get("decay").set(decay);
            submodel.get("dynamic-load-provider").get("history").set(history);
            submodel.get("dynamic-load-provider").get("decay").set(decay);
            context.completeStep();
        }
    }
}

