/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;

public class ModClusterGetProxyConfiguration
implements OperationStepHandler,
DescriptionProvider {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.modcluster");
    static final ModClusterGetProxyConfiguration INSTANCE = new ModClusterGetProxyConfiguration();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getProxyConfigurationDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    ModCluster modcluster = (ModCluster)controller.getValue();
                    Map<InetSocketAddress, String> map = modcluster.getProxyConfiguration();
                    log.debugf("Mod_cluster ProxyConfiguration " + map, new Object[0]);
                    if (!map.isEmpty()) {
                        ModelNode result = new ModelNode();
                        Object[] addr = map.keySet().toArray();
                        for (int i = 0; i < addr.length; ++i) {
                            InetSocketAddress address = (InetSocketAddress)addr[i];
                            result.add(address.getHostName() + ":" + address.getPort());
                            result.add(map.get(addr[i]));
                        }
                        context.getResult().set(result);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

