/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ModClusterSubsystemDescriptions {
    static final String RESOURCE_NAME = ModClusterSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    ModClusterSubsystemDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("modcluster"));
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("namespace").set(Namespace.MODCLUSTER.getUriString());
        ModClusterSubsystemDescriptions.getConfigurationCommonDescription(node.get(new String[]{"attributes", "mod-cluster-config"}), "attributes", bundle);
        return node;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("modcluster.add"));
        return node;
    }

    static ModelNode getListProxiesDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("list-proxies");
        node.get("description").set(bundle.getString("modcluster.list-proxies"));
        node.get("request-properties").setEmptyObject();
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("modcluster.proxy-list"));
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        return node;
    }

    static ModelNode getProxyInfoDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-proxies-info");
        node.get("description").set(bundle.getString("modcluster.read-proxies-info"));
        node.get("request-properties").setEmptyObject();
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("modcluster.proxies-info"));
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        return node;
    }

    static ModelNode getProxyConfigurationDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("read-proxies-configuration");
        node.get("description").set(bundle.getString("modcluster.read-proxies-configuration"));
        node.get("request-properties").setEmptyObject();
        node.get(new String[]{"reply-properties", "description"}).set(bundle.getString("modcluster.proxies-configuration"));
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        return node;
    }

    static void AddHostPortDescription(ModelNode node, ResourceBundle bundle) {
        node.get(new String[]{"request-properties", "host", "description"}).set(bundle.getString("modcluster.proxy-host"));
        node.get(new String[]{"request-properties", "host", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "host", "required"}).set(true);
        node.get(new String[]{"request-properties", "port", "description"}).set(bundle.getString("modcluster.proxy-port"));
        node.get(new String[]{"request-properties", "port", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "port", "required"}).set(true);
    }

    static void addCommonMetricDescription(ModelNode node, ResourceBundle bundle) {
        node.get(new String[]{"request-properties", "weight", "description"}).set(bundle.getString("modcluster.configuration.metric.weight"));
        node.get(new String[]{"request-properties", "weight", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "weight", "required"}).set(false);
        node.get(new String[]{"request-properties", "capacity", "description"}).set(bundle.getString("modcluster.configuration.metric.capacity"));
        node.get(new String[]{"request-properties", "capacity", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "capacity", "required"}).set(false);
        node.get(new String[]{"request-properties", "property", "description"}).set(bundle.getString("modcluster.configuration.metric.property"));
        node.get(new String[]{"request-properties", "property", "type"}).set(ModelType.PROPERTY);
        node.get(new String[]{"request-properties", "property", "required"}).set(false);
    }

    static ModelNode getAddMetricDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-metric");
        node.get("description").set(bundle.getString("modcluster.configuration.add-metric"));
        node.get(new String[]{"request-properties", "type", "description"}).set(bundle.getString("modcluster.configuration.metric.type"));
        node.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "type", "required"}).set(true);
        ModClusterSubsystemDescriptions.addCommonMetricDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getRemoveMetricDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-metric");
        node.get("description").set(bundle.getString("modcluster.configuration.add-metric"));
        node.get(new String[]{"request-properties", "type", "description"}).set(bundle.getString("modcluster.configuration.metric.type"));
        node.get(new String[]{"request-properties", "type", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "type", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getAddCustomMetricDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-custom-metric");
        node.get("description").set(bundle.getString("modcluster.configuration.add-custom-metric"));
        node.get(new String[]{"request-properties", "class", "description"}).set(bundle.getString("modcluster.configuration.metric.class"));
        node.get(new String[]{"request-properties", "class", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "class", "required"}).set(true);
        ModClusterSubsystemDescriptions.addCommonMetricDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getRemoveCustomMetricDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove-custom-metric");
        node.get("description").set(bundle.getString("modcluster.configuration.remove-custom-metric"));
        node.get(new String[]{"request-properties", "class", "description"}).set(bundle.getString("modcluster.configuration.metric.class"));
        node.get(new String[]{"request-properties", "class", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "class", "required"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getAddProxyDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-proxy");
        node.get("description").set(bundle.getString("modcluster.add-proxy"));
        ModClusterSubsystemDescriptions.AddHostPortDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getRemoveProxyDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove-proxy");
        node.get("description").set(bundle.getString("modcluster.remove-proxy"));
        ModClusterSubsystemDescriptions.AddHostPortDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getRefreshDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("refresh");
        node.get("description").set(bundle.getString("modcluster.refresh"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getResetDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("reset");
        node.get("description").set(bundle.getString("modcluster.reset"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getEnableDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("enable");
        node.get("description").set(bundle.getString("modcluster.enable"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static void AddWaitTimeDescription(ModelNode node, ResourceBundle bundle) {
        node.get(new String[]{"request-properties", "waittime", "description"}).set(bundle.getString("modcluster.waittime"));
        node.get(new String[]{"request-properties", "waittime", "type"}).set(ModelType.INT);
        node.get(new String[]{"request-properties", "waittime", "required"}).set(false);
    }

    static ModelNode getStopDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("stop");
        node.get("description").set(bundle.getString("modcluster.stop"));
        ModClusterSubsystemDescriptions.AddWaitTimeDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getDisableDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("disable");
        node.get("description").set(bundle.getString("modcluster.disable"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static void addHostContextDescription(ModelNode node, ResourceBundle bundle) {
        node.get(new String[]{"request-properties", "virtualhost", "description"}).set(bundle.getString("modcluster.virtualhost"));
        node.get(new String[]{"request-properties", "virtualhost", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "virtualhost", "required"}).set(true);
        node.get(new String[]{"request-properties", "context", "description"}).set(bundle.getString("modcluster.context"));
        node.get(new String[]{"request-properties", "context", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "context", "required"}).set(true);
    }

    static ModelNode getEnableContextDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("enable-context");
        node.get("description").set(bundle.getString("modcluster.enable-context"));
        ModClusterSubsystemDescriptions.addHostContextDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getDisableContextDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("disable-context");
        node.get("description").set(bundle.getString("modcluster.disable-context"));
        ModClusterSubsystemDescriptions.addHostContextDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getStopContextDescription(Locale locale) {
        ResourceBundle bundle = ModClusterSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("stop-context");
        node.get("description").set(bundle.getString("modcluster.stop-context"));
        ModClusterSubsystemDescriptions.addHostContextDescription(node, bundle);
        ModClusterSubsystemDescriptions.AddWaitTimeDescription(node, bundle);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    static ModelNode getConfigurationCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("modcluster.configuration"));
        node.get("required").set(false);
        node.get(new String[]{type, "advertise-socket", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "advertise-socket", "description"}).set(bundle.getString("modcluster.configuration.advertise-socket"));
        node.get(new String[]{type, "advertise-socket", "required"}).set(false);
        node.get(new String[]{type, "advertise-socket", "max-occurs"}).set(1);
        node.get(new String[]{type, "proxy-list", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "proxy-list", "description"}).set(bundle.getString("modcluster.configuration.proxy-list"));
        node.get(new String[]{type, "proxy-list", "required"}).set(false);
        node.get(new String[]{type, "proxy-list", "max-occurs"}).set(1);
        node.get(new String[]{type, "proxy-url", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "proxy-url", "description"}).set(bundle.getString("modcluster.configuration.proxy-url"));
        node.get(new String[]{type, "proxy-url", "required"}).set(false);
        node.get(new String[]{type, "proxy-url", "max-occurs"}).set(1);
        node.get(new String[]{type, "advertise", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "advertise", "description"}).set(bundle.getString("modcluster.configuration.advertise"));
        node.get(new String[]{type, "advertise", "required"}).set(false);
        node.get(new String[]{type, "advertise", "max-occurs"}).set(1);
        node.get(new String[]{type, "advertise-security-key", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "advertise-security-key", "description"}).set(bundle.getString("modcluster.configuration.advertise-security-key"));
        node.get(new String[]{type, "advertise-security-key", "required"}).set(false);
        node.get(new String[]{type, "advertise-security-key", "max-occurs"}).set(1);
        node.get(new String[]{type, "excluded-contexts", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "excluded-contexts", "description"}).set(bundle.getString("modcluster.configuration.excluded-contexts"));
        node.get(new String[]{type, "excluded-contexts", "required"}).set(false);
        node.get(new String[]{type, "excluded-contexts", "max-occurs"}).set(1);
        node.get(new String[]{type, "auto-enable-contexts", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "auto-enable-contexts", "description"}).set(bundle.getString("modcluster.configuration.auto-enable-contexts"));
        node.get(new String[]{type, "auto-enable-contexts", "required"}).set(false);
        node.get(new String[]{type, "auto-enable-contexts", "max-occurs"}).set(1);
        node.get(new String[]{type, "stop-context-timeout", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "stop-context-timeout", "description"}).set(bundle.getString("modcluster.configuration.stop-context-timeout"));
        node.get(new String[]{type, "stop-context-timeout", "required"}).set(false);
        node.get(new String[]{type, "stop-context-timeout", "max-occurs"}).set(1);
        node.get(new String[]{type, "socket-timeout", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "socket-timeout", "description"}).set(bundle.getString("modcluster.configuration.socket-timeout"));
        node.get(new String[]{type, "socket-timeout", "required"}).set(false);
        node.get(new String[]{type, "socket-timeout", "max-occurs"}).set(1);
        node.get(new String[]{type, "sticky-session", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "sticky-session", "description"}).set(bundle.getString("modcluster.configuration.sticky-session"));
        node.get(new String[]{type, "sticky-session", "required"}).set(false);
        node.get(new String[]{type, "sticky-session", "max-occurs"}).set(1);
        node.get(new String[]{type, "sticky-session-remove", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "sticky-session-remove", "description"}).set(bundle.getString("modcluster.configuration.sticky-session-remove"));
        node.get(new String[]{type, "sticky-session-remove", "required"}).set(false);
        node.get(new String[]{type, "sticky-session-remove", "max-occurs"}).set(1);
        node.get(new String[]{type, "sticky-session-force", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "sticky-session-force", "description"}).set(bundle.getString("modcluster.configuration.sticky-session-force"));
        node.get(new String[]{type, "sticky-session-force", "required"}).set(false);
        node.get(new String[]{type, "sticky-session-force", "max-occurs"}).set(1);
        node.get(new String[]{type, "worker-timeout", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "worker-timeout", "description"}).set(bundle.getString("modcluster.configuration.worker-timeout"));
        node.get(new String[]{type, "worker-timeout", "required"}).set(false);
        node.get(new String[]{type, "worker-timeout", "max-occurs"}).set(1);
        node.get(new String[]{type, "max-attemps", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-attemps", "description"}).set(bundle.getString("modcluster.configuration.max-attemps"));
        node.get(new String[]{type, "max-attemps", "required"}).set(false);
        node.get(new String[]{type, "max-attemps", "max-occurs"}).set(1);
        node.get(new String[]{type, "flush-packets", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "flush-packets", "description"}).set(bundle.getString("modcluster.configuration.flush-packets"));
        node.get(new String[]{type, "flush-packets", "required"}).set(false);
        node.get(new String[]{type, "flush-packets", "max-occurs"}).set(1);
        node.get(new String[]{type, "flush-wait", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "flush-wait", "description"}).set(bundle.getString("modcluster.configuration.flush-wait"));
        node.get(new String[]{type, "flush-wait", "required"}).set(false);
        node.get(new String[]{type, "flush-wait", "max-occurs"}).set(1);
        node.get(new String[]{type, "ping", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "ping", "description"}).set(bundle.getString("modcluster.configuration.ping"));
        node.get(new String[]{type, "ping", "required"}).set(false);
        node.get(new String[]{type, "ping", "max-occurs"}).set(1);
        node.get(new String[]{type, "smax", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "smax", "description"}).set(bundle.getString("modcluster.configuration.smax"));
        node.get(new String[]{type, "smax", "required"}).set(false);
        node.get(new String[]{type, "smax", "max-occurs"}).set(1);
        node.get(new String[]{type, "ttl", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "ttl", "description"}).set(bundle.getString("modcluster.configuration.ttl"));
        node.get(new String[]{type, "ttl", "required"}).set(false);
        node.get(new String[]{type, "ttl", "max-occurs"}).set(1);
        node.get(new String[]{type, "node-timeout", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "node-timeout", "description"}).set(bundle.getString("modcluster.configuration.node-timeout"));
        node.get(new String[]{type, "node-timeout", "required"}).set(false);
        node.get(new String[]{type, "node-timeout", "max-occurs"}).set(1);
        node.get(new String[]{type, "balancer", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "balancer", "description"}).set(bundle.getString("modcluster.configuration.balancer"));
        node.get(new String[]{type, "balancer", "required"}).set(false);
        node.get(new String[]{type, "balancer", "max-occurs"}).set(1);
        node.get(new String[]{type, "domain", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "domain", "description"}).set(bundle.getString("modcluster.configuration.domain"));
        node.get(new String[]{type, "domain", "required"}).set(false);
        node.get(new String[]{type, "domain", "max-occurs"}).set(1);
        ModClusterSubsystemDescriptions.getSSLCommonDescription(node.get(new String[]{"children", "ssl"}), "attributes", bundle);
        return node;
    }

    private static void getSSLCommonDescription(ModelNode node, String type, ResourceBundle bundle) {
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("web.connector.ssl"));
        node.get("required").set(false);
        node.get(new String[]{type, "key-alias", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "key-alias", "description"}).set(bundle.getString("web.connector.ssl.key-alias"));
        node.get(new String[]{type, "key-alias", "required"}).set(false);
        node.get(new String[]{type, "password", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "password", "description"}).set(bundle.getString("web.connector.ssl.password"));
        node.get(new String[]{type, "password", "required"}).set(false);
        node.get(new String[]{type, "certificate-key-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "certificate-key-file", "description"}).set(bundle.getString("web.connector.ssl.certificate-key-file"));
        node.get(new String[]{type, "certificate-key-file", "required"}).set(false);
        node.get(new String[]{type, "cipher-suite", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "cipher-suite", "description"}).set(bundle.getString("web.connector.ssl.cipher-suite"));
        node.get(new String[]{type, "cipher-suite", "required"}).set(false);
        node.get(new String[]{type, "protocol", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "protocol", "description"}).set(bundle.getString("web.connector.ssl.protocol"));
        node.get(new String[]{type, "protocol", "required"}).set(false);
        node.get(new String[]{type, "ca-certificate-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "ca-certificate-file", "description"}).set(bundle.getString("web.connector.ssl.ca-certificate-file"));
        node.get(new String[]{type, "ca-certificate-file", "required"}).set(false);
        node.get(new String[]{type, "ca-revocation-url", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "ca-revocation-url", "description"}).set(bundle.getString("web.connector.ssl.ca-revocation-url"));
        node.get(new String[]{type, "ca-revocation-url", "required"}).set(false);
    }
}

