/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.modcluster.Attribute;
import org.jboss.as.modcluster.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ModClusterSubsystemXMLReader_1_0
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "modcluster");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MOD_CLUSTER_CONFIG: {
                    ModelNode config = ModClusterSubsystemXMLReader_1_0.parseModClusterConfig(reader);
                    subsystem.get("mod-cluster-config").set(config);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode parseModClusterConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode config = new ModelNode();
        ModClusterSubsystemXMLReader_1_0.parsePropConf(reader, config);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SIMPLE_LOAD_PROVIDER: {
                    ModelNode load = ModClusterSubsystemXMLReader_1_0.parseSimpleLoadProvider(reader);
                    config.get("simple-load-provider").set(load);
                    continue block5;
                }
                case DYNAMIC_LOAD_PROVIDER: {
                    ModelNode dynload = ModClusterSubsystemXMLReader_1_0.parseDynamicLoadProvider(reader);
                    config.get("dynamic-load-provider").set(dynload);
                    continue block5;
                }
                case SSL: {
                    ModelNode ssl = ModClusterSubsystemXMLReader_1_0.parseSSL(reader);
                    config.get("ssl").set(ssl);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return config;
    }

    static void parsePropConf(XMLExtendedStreamReader reader, ModelNode conf) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block24: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ADVERTISE_SOCKET: {
                    conf.get("advertise-socket").set(value);
                    continue block24;
                }
                case PROXY_LIST: {
                    conf.get("proxy-list").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block24;
                }
                case PROXY_URL: {
                    conf.get("proxy-url").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block24;
                }
                case ADVERTISE: {
                    conf.get("advertise").set(value);
                    continue block24;
                }
                case ADVERTISE_SECURITY_KEY: {
                    conf.get("advertise-security-key").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block24;
                }
                case EXCLUDED_CONTEXTS: {
                    conf.get("excluded-contexts").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block24;
                }
                case AUTO_ENABLE_CONTEXTS: {
                    conf.get("auto-enable-contexts").set(Boolean.parseBoolean(value));
                    continue block24;
                }
                case STOP_CONTEXT_TIMEOUT: {
                    conf.get("stop-context-timeout").set(Integer.parseInt(value));
                    continue block24;
                }
                case SOCKET_TIMEOUT: {
                    conf.get("socket-timeout").set(Integer.parseInt(value));
                    continue block24;
                }
                case STICKY_SESSION: {
                    conf.get("sticky-session").set(Boolean.parseBoolean(value));
                    continue block24;
                }
                case STICKY_SESSION_REMOVE: {
                    conf.get("sticky-session-remove").set(Boolean.parseBoolean(value));
                    continue block24;
                }
                case STICKY_SESSION_FORCE: {
                    conf.get("sticky-session-force").set(Boolean.parseBoolean(value));
                    continue block24;
                }
                case WORKER_TIMEOUT: {
                    conf.get("worker-timeout").set(Integer.parseInt(value));
                    continue block24;
                }
                case MAX_ATTEMPTS: {
                    conf.get("max-attemps").set(Integer.parseInt(value));
                    continue block24;
                }
                case FLUSH_PACKETS: {
                    conf.get("flush-packets").set(Boolean.parseBoolean(value));
                    continue block24;
                }
                case FLUSH_WAIT: {
                    conf.get("flush-wait").set(Integer.parseInt(value));
                    continue block24;
                }
                case PING: {
                    conf.get("ping").set(Integer.parseInt(value));
                    continue block24;
                }
                case SMAX: {
                    conf.get("smax").set(Integer.parseInt(value));
                    continue block24;
                }
                case TTL: {
                    conf.get("ttl").set(Integer.parseInt(value));
                    continue block24;
                }
                case NODE_TIMEOUT: {
                    conf.get("node-timeout").set(Integer.parseInt(value));
                    continue block24;
                }
                case BALANCER: {
                    conf.get("balancer").set(value);
                    continue block24;
                }
                case DOMAIN: {
                    conf.get("domain").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block24;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    static ModelNode parseSSL(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.setEmptyObject();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_ALIAS: {
                    ssl.get("key-alias").set(value);
                    continue block9;
                }
                case PASSWORD: {
                    ssl.get("password").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block9;
                }
                case CERTIFICATE_KEY_FILE: {
                    ssl.get("certificate-key-file").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block9;
                }
                case CIPHER_SUITE: {
                    ssl.get("cipher-suite").set(value);
                    continue block9;
                }
                case PROTOCOL: {
                    ssl.get("protocol").set(value);
                    continue block9;
                }
                case CA_CERTIFICATE_FILE: {
                    ssl.get("ca-certificate-file").set(ParseUtils.parsePossibleExpression((String)value));
                    continue block9;
                }
                case CA_REVOCATION_URL: {
                    ssl.get("ca-revocation-url").set(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return ssl;
    }

    static ModelNode parseSimpleLoadProvider(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTOR: {
                    load.get("factor").set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return load;
    }

    static ModelNode parseDynamicLoadProvider(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HISTORY: {
                    load.get("history").set(value);
                    continue block8;
                }
                case DECAY: {
                    load.get("decay").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOAD_METRIC: {
                    ModelNode loadmetric = ModClusterSubsystemXMLReader_1_0.parseLoadMetric(reader);
                    load.get("load-metric").add(loadmetric);
                    continue block9;
                }
                case CUSTOM_LOAD_METRIC: {
                    ModelNode customloadmetric = ModClusterSubsystemXMLReader_1_0.parseCustomLoadMetric(reader);
                    load.get("custom-load-metric").add(customloadmetric);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static ModelNode parseLoadMetric(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    load.get("type").set(value);
                    continue block8;
                }
                case CAPACITY: {
                    load.get("capacity").set(value);
                    continue block8;
                }
                case WEIGHT: {
                    load.get("weight").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ModClusterSubsystemXMLReader_1_0.parseProperty(reader);
                    load.get("property").add(property.getName(), property.getValue());
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static ModelNode parseCustomLoadMetric(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode load = new ModelNode();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CAPACITY: {
                    load.get("capacity").set(value);
                    continue block8;
                }
                case WEIGHT: {
                    load.get("weight").set(value);
                    continue block8;
                }
                case CLASS: {
                    load.get("class").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ModClusterSubsystemXMLReader_1_0.parseProperty(reader);
                    load.get("property").add(property.getName(), property.getValue());
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return load;
    }

    static Property parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        String value = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new Property(name, new ModelNode().set(value == null ? "" : value));
    }
}

