/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.context;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.naming.util.NamingUtils;

public class NamespaceObjectFactory
implements ObjectFactory {
    public static Reference createReference(String contextIdentifier) {
        return new Reference(Context.class.getName(), new StringRefAddr("nns", contextIdentifier), NamespaceObjectFactory.class.getName(), null);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference reference = NamingUtils.asReference(obj);
        StringRefAddr nameAdr = (StringRefAddr)reference.get("nns");
        if (nameAdr == null) {
            throw new NamingException("Invalid context reference.  Not a 'nns' reference.");
        }
        String contextName = (String)nameAdr.getContent();
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NamingException("Failed to get context with name " + contextName);
        }
        return selector.getContext(contextName);
    }
}

