/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class BinderService<T>
implements Service<T> {
    private final InjectedValue<Context> namingContextValue = new InjectedValue();
    private final String name;
    private final Value<T> value;

    public BinderService(String name, Value<T> value) {
        this.name = name;
        this.value = value;
    }

    public synchronized void start(StartContext context) throws StartException {
        Context namingContext = (Context)this.namingContextValue.getValue();
        try {
            namingContext.rebind(this.name, this.value.getValue());
        }
        catch (NamingException e) {
            throw new StartException("Failed to bind resource into context [" + namingContext + "] at location [" + this.name + "]", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        Context namingContext = (Context)this.namingContextValue.getValue();
        try {
            namingContext.unbind(this.name);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to unbind resource from context [" + namingContext + "] at location [" + this.name + "]", e);
        }
    }

    public synchronized T getValue() throws IllegalStateException {
        Context namingContext = (Context)this.namingContextValue.getValue();
        try {
            return (T)namingContext.lookup(this.name);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup value from context [" + namingContext + "] at location [" + this.name + "]", e);
        }
    }

    public Injector<Context> getContextInjector() {
        return this.namingContextValue;
    }
}

