/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.osgi.service.BundleContextService;
import org.jboss.as.osgi.service.BundleManagerService;
import org.jboss.as.osgi.service.FrameworkService;
import org.jboss.as.osgi.service.PackageAdminService;
import org.jboss.as.osgi.service.StartLevelService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class OSGiDeploymentService
implements Service<Deployment> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private static final OSGiDeploymentListener listener = new OSGiDeploymentListener();
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"osgi", "deployment"});
    private final Deployment deployment;
    private InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();
    private InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();

    private OSGiDeploymentService(Deployment deployment) {
        this.deployment = deployment;
    }

    public static void addService(DeploymentPhaseContext phaseContext, Deployment deployment) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        OSGiDeploymentService service = new OSGiDeploymentService(deployment);
        String contextName = deploymentUnit.getName();
        ServiceName serviceName = OSGiDeploymentService.getServiceName(contextName);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.addDependency(BundleContextService.SERVICE_NAME, BundleContext.class, service.injectedBundleContext);
        serviceBuilder.addDependency(BundleManagerService.SERVICE_NAME, BundleManager.class, service.injectedBundleManager);
        serviceBuilder.addDependency(Services.deploymentUnitName((String)contextName));
        serviceBuilder.addDependency(PackageAdminService.SERVICE_NAME);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.addListener((ServiceListener)listener);
        serviceBuilder.install();
    }

    public static void removeService(DeploymentUnit context) {
        ServiceName serviceName = OSGiDeploymentService.getServiceName(context.getName());
        ServiceController serviceController = context.getServiceRegistry().getService(serviceName);
        if (serviceController != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public static ServiceName getServiceName(String contextName) {
        ServiceName deploymentServiceName = Services.deploymentUnitName((String)contextName);
        return SERVICE_NAME_BASE.append(new String[]{deploymentServiceName.getSimpleName()});
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        ServiceContainer serviceContainer = controller.getServiceContainer();
        ServiceController contextController = serviceContainer.getService(FrameworkService.SERVICE_NAME);
        contextController.setMode(ServiceController.Mode.ACTIVE);
        log.tracef("Installing deployment: %s", (Object)this.deployment);
        try {
            boolean autoStart = this.deployment.isAutoStart();
            this.deployment.setAutoStart(false);
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleManager.installBundle(this.deployment);
            this.deployment.setAutoStart(autoStart);
        }
        catch (Throwable t) {
            throw new StartException("Failed to install deployment: " + this.deployment, t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.tracef("Uninstalling deployment: %s", (Object)this.deployment);
        try {
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleManager.uninstallBundle(this.deployment);
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to uninstall deployment: %s", (Object)this.deployment);
        }
        ServiceName serviceName = Services.deploymentUnitName((String)context.getController().getName().getSimpleName());
        ServiceController deploymentController = context.getController().getServiceContainer().getService(serviceName);
        if (deploymentController != null) {
            deploymentController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public Deployment getValue() throws IllegalStateException {
        return this.deployment;
    }

    static class OSGiDeploymentListener
    extends AbstractServiceListener<Deployment> {
        private final Set<Deployment> startedDeployments = new CopyOnWriteArraySet<Deployment>();
        private final Set<Deployment> pendingDeployments = new CopyOnWriteArraySet<Deployment>();

        OSGiDeploymentListener() {
        }

        public void listenerAdded(ServiceController<? extends Deployment> controller) {
            this.pendingDeployments.add((Deployment)controller.getValue());
        }

        public void serviceStarted(ServiceController<? extends Deployment> controller) {
            log.debugf("OSGiDeploymentService started: %s", controller);
            this.startedDeployments.add((Deployment)controller.getValue());
            this.processDeployment(controller);
        }

        public void serviceFailed(ServiceController<? extends Deployment> controller, StartException reason) {
            log.errorf((Throwable)reason, "OSGiDeploymentService failed: %s", controller);
            this.processDeployment(controller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDeployment(ServiceController<? extends Deployment> controller) {
            controller.removeListener((ServiceListener)this);
            HashSet<Deployment> bundlesToStart = null;
            OSGiDeploymentListener oSGiDeploymentListener = this;
            synchronized (oSGiDeploymentListener) {
                this.pendingDeployments.remove(controller.getValue());
                if (this.pendingDeployments.isEmpty()) {
                    bundlesToStart = new HashSet<Deployment>(this.startedDeployments);
                    this.startedDeployments.clear();
                }
            }
            if (bundlesToStart != null) {
                ServiceContainer serviceContainer = controller.getServiceContainer();
                PackageAdmin packageAdmin = PackageAdminService.getServiceValue(serviceContainer);
                StartLevel startLevel = StartLevelService.getServiceValue(serviceContainer);
                for (Deployment dep : bundlesToStart) {
                    Bundle bundle = (Bundle)dep.getAttachment(Bundle.class);
                    if (packageAdmin.getBundleType(bundle) == 1) continue;
                    boolean autoStart = dep.isAutoStart();
                    String contextName = DeploymentHolderService.getContextName(dep);
                    ServiceName serviceName = DeploymentHolderService.getServiceName(contextName);
                    ServiceController holderService = serviceContainer.getService(serviceName);
                    if (holderService != null) {
                        Deployment initiatingDeployment = (Deployment)holderService.getValue();
                        autoStart = initiatingDeployment.isAutoStart();
                        Integer startlevel = initiatingDeployment.getStartLevel();
                        if (startlevel != null) {
                            startLevel.setBundleStartLevel(bundle, startlevel.intValue());
                        }
                    }
                    if (!autoStart) continue;
                    log.tracef("Starting bundle: %s", (Object)bundle);
                    try {
                        bundle.start();
                    }
                    catch (BundleException ex) {
                        log.errorf((Throwable)ex, "Cannot start bundle: %s", (Object)bundle);
                    }
                }
            }
        }
    }
}

