/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.service.BundleManagerService;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.BundleManager;

public class DeploymentHolderService
extends AbstractService<Deployment> {
    private static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"osgi", "deployment", "holder"});
    private final Deployment deployment;
    private InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();

    private DeploymentHolderService(Deployment deployment) {
        this.deployment = deployment;
    }

    public static void addService(ServiceTarget serviceTarget, String contextName, Deployment dep) {
        DeploymentHolderService service = new DeploymentHolderService(dep);
        ServiceBuilder serviceBuilder = serviceTarget.addService(DeploymentHolderService.getServiceName(contextName), (Service)service);
        serviceBuilder.addDependency(BundleManagerService.SERVICE_NAME, BundleManager.class, service.injectedBundleManager);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.install();
    }

    public static void removeService(ServiceContainer container, String contextName) {
        ServiceController controller = container.getService(DeploymentHolderService.getServiceName(contextName));
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public static Deployment getDeployment(ServiceRegistry registry, String contextName) {
        ServiceController controller = registry.getService(DeploymentHolderService.getServiceName(contextName));
        return controller != null ? (Deployment)controller.getValue() : null;
    }

    public static String getContextName(Deployment dep) {
        int idx;
        String prefix;
        String name = dep.getLocation();
        if (name.startsWith(prefix = "module:deployment.")) {
            name = name.substring(prefix.length());
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((idx = name.lastIndexOf("/")) > 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static ServiceName getServiceName(String contextName) {
        ServiceName deploymentServiceName = Services.deploymentUnitName((String)contextName);
        return SERVICE_NAME_BASE.append(new String[]{deploymentServiceName.getSimpleName()});
    }

    public Deployment getValue() throws IllegalStateException {
        return this.deployment;
    }
}

