/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.deployment.BundleInfoAttachment;
import org.jboss.as.osgi.deployment.DeploymentHolderService;
import org.jboss.as.osgi.deployment.OSGiDeploymentAttachment;
import org.jboss.as.osgi.deployment.OSGiDeploymentService;
import org.jboss.as.osgi.deployment.OSGiMetaDataAttachment;
import org.jboss.as.osgi.deployment.XModuleAttachment;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Version;

public class OSGiDeploymentInstallProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Deployment deployment = OSGiDeploymentAttachment.getDeployment(deploymentUnit);
        String contextName = deploymentUnit.getName();
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        Deployment holderDep = DeploymentHolderService.getDeployment(serviceRegistry, contextName);
        org.jboss.vfs.VirtualFile virtualFile = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        String location = holderDep != null ? holderDep.getLocation() : contextName;
        boolean autoStart = holderDep != null ? holderDep.isAutoStart() : true;
        BundleInfo info = BundleInfoAttachment.getBundleInfo(deploymentUnit);
        if (deployment == null && info != null) {
            deployment = DeploymentFactory.createDeployment((BundleInfo)info);
            deployment.addAttachment(BundleInfo.class, (Object)info);
            OSGiDeploymentAttachment.attachDeployment(deploymentUnit, deployment);
        }
        OSGiMetaData metadata = OSGiMetaDataAttachment.getOSGiMetaData(deploymentUnit);
        if (deployment == null && metadata != null) {
            String symbolicName = metadata.getBundleSymbolicName();
            Version version = metadata.getBundleVersion();
            deployment = DeploymentFactory.createDeployment((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)location, (String)symbolicName, (Version)version);
            deployment.addAttachment(OSGiMetaData.class, (Object)metadata);
            OSGiDeploymentAttachment.attachDeployment(deploymentUnit, deployment);
        }
        XModule resModule = XModuleAttachment.getXModuleAttachment(deploymentUnit);
        if (deployment == null && resModule != null) {
            String symbolicName = resModule.getName();
            Version version = resModule.getVersion();
            deployment = DeploymentFactory.createDeployment((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)location, (String)symbolicName, (Version)version);
            deployment.addAttachment(XModule.class, (Object)resModule);
            OSGiDeploymentAttachment.attachDeployment(deploymentUnit, deployment);
        }
        if (deployment != null) {
            MountHandle mount = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getMountHandle();
            deployment.addAttachment(MountHandle.class, (Object)mount);
            deployment.setAutoStart(autoStart);
            OSGiDeploymentService.addService(phaseContext, deployment);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        OSGiDeploymentService.removeService(deploymentUnit);
    }
}

