/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Hashtable;
import java.util.Set;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.osgi.deployment.BundleStartTracker;
import org.jboss.as.osgi.deployment.OSGiDeploymentActivator;
import org.jboss.as.osgi.parser.SecurityActions;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.ConfigAdminServiceImpl;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.osgi.service.InstallHandlerIntegration;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceTarget;

class OSGiSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private static final SubsystemState.Activation DEFAULT_ACTIVATION = SubsystemState.Activation.LAZY;
    static final OSGiSubsystemAdd INSTANCE = new OSGiSubsystemAdd();

    private OSGiSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        this.populateSubModel(context.getSubModel(), operation);
        if (context instanceof BootOperationContext) {
            final BootOperationContext updateContext = (BootOperationContext)context;
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    log.infof("Activating OSGi Subsystem", new Object[0]);
                    long begin = System.currentTimeMillis();
                    SubsystemState subsystemState = OSGiSubsystemAdd.this.createSubsystemState(operation);
                    String value = SecurityActions.getSystemProperty("jboss.protocol.handler.modules", "org.jboss.osgi.framework");
                    if (!value.equals("org.jboss.osgi.framework")) {
                        value = value + "|org.jboss.osgi.framework";
                    }
                    SecurityActions.setSystemProperty("jboss.protocol.handler.modules", value);
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    BundleStartTracker.addService(serviceTarget);
                    InstallHandlerIntegration.addService(serviceTarget);
                    FrameworkBootstrapService.addService(serviceTarget, subsystemState);
                    ConfigAdminServiceImpl.addService(serviceTarget, subsystemState);
                    new OSGiDeploymentActivator().activate(updateContext);
                    resultHandler.handleResultComplete();
                    long end = System.currentTimeMillis();
                    log.debugf("Activated OSGi Subsystem in %dms", (Object)(end - begin));
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("remove");
        compensatingOperation.get("address").set(operation.require("address"));
        return new BasicOperationResult(compensatingOperation);
    }

    private SubsystemState createSubsystemState(ModelNode operation) {
        ModelNode modules;
        String value;
        ModelNode properties;
        Set keys;
        SubsystemState subsystemState = new SubsystemState();
        SubsystemState.Activation activation = DEFAULT_ACTIVATION;
        if (operation.has("activation")) {
            activation = SubsystemState.Activation.valueOf(operation.get("activation").asString().toUpperCase());
        }
        subsystemState.setActivation(activation);
        if (operation.has("configuration")) {
            ModelNode configurationProperties;
            Set keys2;
            ModelNode configuration = operation.get("configuration");
            String pid = configuration.require("pid").asString();
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            if (configuration.has("configuration_properties") && (keys2 = (configurationProperties = configuration.get("configuration_properties")).keys()) != null) {
                for (String current : keys2) {
                    String value2 = configurationProperties.get(current).asString();
                    dictionary.put(current, value2);
                }
            }
            subsystemState.putConfiguration(pid, dictionary);
        }
        if (operation.has("properties") && (keys = (properties = operation.get("properties")).keys()) != null) {
            for (String current : keys) {
                value = properties.get(current).asString();
                subsystemState.addProperty(current, value);
            }
        }
        if (operation.has("modules") && (keys = (modules = operation.get("modules")).keys()) != null) {
            for (String current : keys) {
                value = modules.get(current).get("start").asString();
                subsystemState.addModule(new SubsystemState.OSGiModule(ModuleIdentifier.fromString((String)current), Boolean.parseBoolean(value)));
            }
        }
        return subsystemState;
    }

    private void populateSubModel(ModelNode subModel, ModelNode operation) {
        if (operation.has("activation")) {
            subModel.get("activation").set(operation.get("activation"));
        }
        if (operation.has("configuration")) {
            subModel.get("configuration").set(operation.get("configuration"));
        }
        if (operation.has("properties")) {
            subModel.get("properties").set(operation.get("properties"));
        }
        if (operation.has("modules")) {
            subModel.get("modules").set(operation.get("modules"));
        }
    }
}

