/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.AutoInstallIntegration;
import org.jboss.as.osgi.service.ModuleLoaderIntegration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.BundleReferenceClassLoader;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemServicesProvider;
import org.jboss.osgi.framework.internal.FrameworkBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FrameworkBootstrapService
implements Service<Void> {
    public static final ServiceName SERVICE_BASE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "as"});
    public static final ServiceName FRAMEWORK_BASE_NAME = SERVICE_BASE_NAME.append(new String[]{"framework"});
    public static final ServiceName FRAMEWORK_BOOTSTRAP = FRAMEWORK_BASE_NAME.append(new String[]{"bootstrap"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private final InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<SocketBinding> httpServerPortBinding = new InjectedValue();
    private final SubsystemState subsystemState;

    public static void addService(ServiceTarget target, SubsystemState subsystemState) {
        FrameworkBootstrapService service = new FrameworkBootstrapService(subsystemState);
        ServiceBuilder builder = target.addService(FRAMEWORK_BOOTSTRAP, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedEnvironment);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"osgi-http"}), SocketBinding.class, service.httpServerPortBinding);
        builder.install();
        AutoInstallIntegration.addService(target, subsystemState);
        FrameworkModuleIntegration.addService(target, subsystemState);
        ModuleLoaderIntegration.addService(target);
        SystemServicesIntegration.addService(target);
    }

    private FrameworkBootstrapService(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            ServiceContainer serviceContainer = context.getController().getServiceContainer();
            HashMap<String, Object> props = new HashMap<String, Object>(this.subsystemState.getProperties());
            this.setupIntegrationProperties(context, props);
            FrameworkBuilder builder = new FrameworkBuilder(props);
            builder.setServiceContainer(serviceContainer);
            builder.setServiceTarget(context.getChildTarget());
            builder.addProvidedService(Services.AUTOINSTALL_PROVIDER);
            builder.addProvidedService(Services.BUNDLE_INSTALL_PROVIDER);
            builder.addProvidedService(Services.FRAMEWORK_MODULE_PROVIDER);
            builder.addProvidedService(Services.MODULE_LOADER_PROVIDER);
            builder.addProvidedService(Services.SYSTEM_SERVICES_PROVIDER);
            SubsystemState.Activation activation = this.subsystemState.getActivationPolicy();
            ServiceController.Mode initialMode = activation == SubsystemState.Activation.EAGER ? ServiceController.Mode.ACTIVE : ServiceController.Mode.ON_DEMAND;
            builder.createFrameworkServices(initialMode, true);
        }
        catch (Throwable t) {
            throw new StartException("Failed to create Framework services", t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.infof("Stopping OSGi Framework", new Object[0]);
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    private void setupIntegrationProperties(StartContext context, Map<String, Object> props) {
        props.put("org.osgi.service.http.port", "" + ((SocketBinding)this.httpServerPortBinding.getValue()).getSocketAddress().getPort());
        props.put("org.osgi.framework.storage.clean", "onFirstInit");
        String storage = (String)props.get("org.osgi.framework.storage");
        if (storage == null) {
            ServerEnvironment environment = (ServerEnvironment)this.injectedEnvironment.getValue();
            File dataDir = environment.getServerDataDir();
            storage = dataDir.getAbsolutePath() + File.separator + "osgi-store";
            props.put("org.osgi.framework.storage", storage);
        }
    }

    private static final class FrameworkModuleIntegration
    implements FrameworkModuleProvider {
        private final InjectedValue<Module> injectedSystemModule = new InjectedValue();
        private final SubsystemState subsystemState;
        private Module frameworkModule;

        private static void addService(ServiceTarget target, SubsystemState subsystemState) {
            FrameworkModuleIntegration service = new FrameworkModuleIntegration(subsystemState);
            ServiceBuilder builder = target.addService(Services.FRAMEWORK_MODULE_PROVIDER, (Service)service);
            builder.addDependency(Services.SYSTEM_MODULE_PROVIDER, Module.class, service.injectedSystemModule);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }

        private FrameworkModuleIntegration(SubsystemState subsystemState) {
            this.subsystemState = subsystemState;
        }

        public void start(StartContext context) throws StartException {
        }

        public void stop(StopContext context) {
            this.frameworkModule = null;
        }

        public FrameworkModuleProvider getValue() throws IllegalStateException {
            return this;
        }

        public Module getFrameworkModule(Bundle systemBundle) {
            if (this.frameworkModule == null) {
                this.frameworkModule = this.createFrameworkModule(systemBundle);
            }
            return this.frameworkModule;
        }

        private Module createFrameworkModule(Bundle systemBundle) {
            Module systemModule = (Module)this.injectedSystemModule.getValue();
            ModuleIdentifier systemIdentifier = systemModule.getIdentifier();
            ModuleLoader systemLoader = systemModule.getModuleLoader();
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create((String)"jbosgi.framework"));
            PathFilter acceptAll = PathFilters.acceptAll();
            specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)acceptAll, (PathFilter)acceptAll, (ModuleLoader)systemLoader, (ModuleIdentifier)systemIdentifier, (boolean)false));
            ModuleLoader bootLoader = Module.getBootModuleLoader();
            ModuleIdentifier frameworkIdentifier = ModuleIdentifier.create((String)"org.jboss.osgi.framework");
            specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)acceptAll, (PathFilter)acceptAll, (ModuleLoader)bootLoader, (ModuleIdentifier)frameworkIdentifier, (boolean)false));
            String modulesProps = (String)this.subsystemState.getProperties().get("org.jboss.osgi.system.modules");
            if (modulesProps != null) {
                for (String moduleProp : modulesProps.split(",")) {
                    if ((moduleProp = moduleProp.trim()).length() <= 0) continue;
                    ModuleIdentifier moduleId = ModuleIdentifier.create((String)moduleProp);
                    DependencySpec moduleDep = DependencySpec.createModuleDependencySpec((PathFilter)acceptAll, (PathFilter)acceptAll, (ModuleLoader)bootLoader, (ModuleIdentifier)moduleId, (boolean)false);
                    specBuilder.addDependency(moduleDep);
                }
            }
            specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new BundleReferenceClassLoader.Factory(systemBundle));
            try {
                final ModuleSpec moduleSpec = specBuilder.create();
                ModuleLoader moduleLoader = new ModuleLoader(){

                    protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                        return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                    }

                    public String toString() {
                        return ((Object)((Object)this)).getClass().getSimpleName();
                    }
                };
                return moduleLoader.loadModule(specBuilder.getIdentifier());
            }
            catch (ModuleLoadException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class SystemServicesIntegration
    extends AbstractService<SystemServicesProvider>
    implements SystemServicesProvider {
        private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
        private ServiceContainer serviceContainer;

        public static void addService(ServiceTarget target) {
            SystemServicesIntegration service = new SystemServicesIntegration();
            ServiceBuilder builder = target.addService(Services.SYSTEM_SERVICES_PROVIDER, (Service)service);
            builder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
            builder.addDependency(Services.FRAMEWORK_CREATE);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }

        private SystemServicesIntegration() {
        }

        public void start(StartContext context) throws StartException {
            this.serviceContainer = context.getController().getServiceContainer();
        }

        public SystemServicesProvider getValue() {
            return this;
        }

        public void registerSystemServices(BundleContext systemContext) {
            MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
            systemContext.registerService(MBeanServer.class.getName(), (Object)mbeanServer, null);
            systemContext.registerService(ServiceContainer.class.getName(), (Object)this.serviceContainer, null);
        }
    }
}

