/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleStartTracker
implements Service<BundleStartTracker> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    public static final ServiceName SERVICE_NAME = FrameworkBootstrapService.FRAMEWORK_BASE_NAME.append(new String[]{"starttracker"});
    private final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    private final Map<ServiceName, Tuple> pendingServices = new ConcurrentHashMap<ServiceName, Tuple>();
    private final Map<ServiceName, Tuple> startedServices = new ConcurrentHashMap<ServiceName, Tuple>();
    private ServiceContainer serviceContainer;

    public static final ServiceController<?> addService(ServiceTarget serviceTarget) {
        BundleStartTracker service = new BundleStartTracker();
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, service.injectedPackageAdmin);
        builder.setInitialMode(ServiceController.Mode.PASSIVE);
        return builder.install();
    }

    private BundleStartTracker() {
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        log.debugf("Starting: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        log.debugf("Stopping: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
    }

    public BundleStartTracker getValue() throws IllegalStateException {
        return this;
    }

    void addInstalledBundle(ServiceName serviceName, Deployment deployment) {
        ServiceController controller = this.serviceContainer.getRequiredService(serviceName);
        this.pendingServices.put(serviceName, new Tuple((ServiceController<? extends Bundle>)controller, deployment));
        controller.addListener((ServiceListener)new AbstractServiceListener<Bundle>(){

            public void listenerAdded(ServiceController<? extends Bundle> controller) {
                ServiceController.State state = controller.getState();
                if (state == ServiceController.State.UP || state == ServiceController.State.START_FAILED) {
                    this.processService(controller);
                }
            }

            public void transition(ServiceController<? extends Bundle> controller, ServiceController.Transition transition) {
                if (transition.getBefore() == ServiceController.Substate.STARTING) {
                    switch (transition.getAfter()) {
                        case UP: {
                            ServiceName key = controller.getName();
                            Tuple value = (Tuple)BundleStartTracker.this.pendingServices.get(key);
                            BundleStartTracker.this.startedServices.put(key, value);
                        }
                        case START_FAILED: {
                            this.processService(controller);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void processService(ServiceController<? extends Bundle> controller) {
                controller.removeListener((ServiceListener)this);
                HashMap bundlesToStart = null;
                1 var3_3 = this;
                synchronized (var3_3) {
                    ServiceName key = controller.getName();
                    BundleStartTracker.this.pendingServices.remove(key);
                    if (BundleStartTracker.this.pendingServices.isEmpty()) {
                        bundlesToStart = new HashMap(BundleStartTracker.this.startedServices);
                        BundleStartTracker.this.startedServices.clear();
                    }
                }
                if (bundlesToStart != null) {
                    PackageAdmin packageAdmin = (PackageAdmin)BundleStartTracker.this.injectedPackageAdmin.getValue();
                    for (Tuple tuple : bundlesToStart.values()) {
                        Bundle bundle = (Bundle)tuple.controller.getValue();
                        Deployment dep = tuple.deployment;
                        if (!dep.isAutoStart()) continue;
                        try {
                            int bundleType = packageAdmin.getBundleType(bundle);
                            if (bundleType == 1) continue;
                            bundle.start(1);
                        }
                        catch (BundleException ex) {
                            log.errorf((Throwable)ex, "Cannot start bundle: %s", (Object)bundle);
                        }
                    }
                }
            }
        });
    }

    private static final class Tuple {
        private ServiceController<? extends Bundle> controller;
        private Deployment deployment;

        Tuple(ServiceController<? extends Bundle> controller, Deployment deployment) {
            this.controller = controller;
            this.deployment = deployment;
        }
    }
}

