/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.deployment.BundleStartTracker;
import org.jboss.as.osgi.deployment.OSGiDeploymentActivator;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.BundleInstallProviderIntegration;
import org.jboss.as.osgi.service.ConfigAdminServiceImpl;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class OSGiSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private static final SubsystemState.Activation DEFAULT_ACTIVATION = SubsystemState.Activation.LAZY;
    static final OSGiSubsystemAdd INSTANCE = new OSGiSubsystemAdd();

    private OSGiSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode subModel) {
        if (operation.has("activation")) {
            subModel.get("activation").set(operation.get("activation"));
        }
        if (operation.has("configuration")) {
            subModel.get("configuration").set(operation.get("configuration"));
        }
        if (operation.has("properties")) {
            subModel.get("properties").set(operation.get("properties"));
        }
        if (operation.has("modules")) {
            subModel.get("modules").set(operation.get("modules"));
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                new OSGiDeploymentActivator().activate(processorTarget);
            }
        }, OperationContext.Stage.RUNTIME);
        log.infof("Activating OSGi Subsystem", new Object[0]);
        long begin = System.currentTimeMillis();
        SubsystemState subsystemState = this.createSubsystemState(operation);
        ServiceTarget serviceTarget = context.getServiceTarget();
        newControllers.add(BundleStartTracker.addService(serviceTarget));
        newControllers.add(BundleInstallProviderIntegration.addService(serviceTarget));
        newControllers.addAll(FrameworkBootstrapService.addService(serviceTarget, subsystemState, new ServiceListener[]{verificationHandler}));
        newControllers.add(ConfigAdminServiceImpl.addService(serviceTarget, subsystemState, new ServiceListener[]{verificationHandler}));
        long end = System.currentTimeMillis();
        log.debugf("Activated OSGi Subsystem in %dms", (Object)(end - begin));
    }

    private SubsystemState createSubsystemState(ModelNode operation) {
        ModelNode modules;
        ModelNode properties;
        Set keys;
        SubsystemState subsystemState = new SubsystemState();
        SubsystemState.Activation activation = DEFAULT_ACTIVATION;
        if (operation.has("activation")) {
            activation = SubsystemState.Activation.valueOf(operation.get("activation").asString().toUpperCase());
        }
        subsystemState.setActivation(activation);
        if (operation.has("configuration")) {
            ModelNode configurationProperties;
            Set keys2;
            ModelNode configuration = operation.get("configuration");
            String pid = configuration.require("pid").asString();
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            if (configuration.has("configuration_properties") && (keys2 = (configurationProperties = configuration.get("configuration_properties")).keys()) != null) {
                for (String current : keys2) {
                    String value = configurationProperties.get(current).asString();
                    dictionary.put(current, value);
                }
            }
            subsystemState.putConfiguration(pid, dictionary);
        }
        if (operation.has("properties") && (keys = (properties = operation.get("properties")).keys()) != null) {
            for (String current : keys) {
                String value = properties.get(current).asString();
                subsystemState.addProperty(current, value);
            }
        }
        if (operation.has("modules") && (keys = (modules = operation.get("modules")).keys()) != null) {
            for (String current : keys) {
                ModelNode modelNode = modules.get(current).get("start");
                Integer startLevel = modelNode.isDefined() ? Integer.valueOf(modelNode.asInt()) : null;
                subsystemState.addModule(new SubsystemState.OSGiModule(ModuleIdentifier.fromString((String)current), startLevel));
            }
        }
        return subsystemState;
    }
}

