/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiPropertyRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    static final OSGiPropertyRemove INSTANCE = new OSGiPropertyRemove();

    private OSGiPropertyRemove() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(OSGiSubsystemProviders.getResourceBundle(locale).getString("property.remove"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String propName = operation.get("address").asObject().get("property").asString();
        SubsystemState stateService = (SubsystemState)context.getServiceRegistry(true).getRequiredService(SubsystemState.SERVICE_NAME).getValue();
        Object oldVal = stateService.setProperty(propName, null);
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
            stateService.setProperty(propName, oldVal);
        }
    }
}

