/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.osgi.deployment.DeploymentAttachment;
import org.jboss.as.osgi.deployment.OSGiMetaDataAttachment;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Version;

public class OSGiXServicesDeploymentProcessor
implements DeploymentUnitProcessor {
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        Deployment deployment = DeploymentAttachment.getDeploymentAttachment(context);
        if (deployment != null) {
            return;
        }
        String resName = "META-INF/jbosgi-xservice.properties";
        org.jboss.vfs.VirtualFile virtualFile = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        org.jboss.vfs.VirtualFile xserviceFile = virtualFile.getChild(resName);
        if (xserviceFile.exists()) {
            try {
                OSGiMetaData metadata = OSGiMetaDataBuilder.load((InputStream)xserviceFile.openStream());
                String location = virtualFile.getPathName();
                String symbolicName = metadata.getBundleSymbolicName();
                Version version = metadata.getBundleVersion();
                deployment = DeploymentFactory.createDeployment((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)location, (String)symbolicName, (Version)version);
                deployment.addAttachment(OSGiMetaData.class, (Object)metadata);
                OSGiMetaDataAttachment.attachOSGiMetaData(context, metadata);
                DeploymentAttachment.attachDeployment(context, deployment);
            }
            catch (IOException ex) {
                throw new DeploymentUnitProcessingException("Cannot parse: " + xserviceFile);
            }
        }
    }
}

