/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.ModuleIdentifier;

public final class OSGiSubsystemState
implements Serializable {
    private static final long serialVersionUID = 6268537612248019022L;
    public static final OSGiSubsystemState DEFAULT_CONFIGURATION = new OSGiSubsystemState();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final List<OSGiModule> modules = new ArrayList<OSGiModule>();
    private Activation activationPolicy = Activation.LAZY;

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public List<OSGiModule> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    void addModule(OSGiModule module) {
        this.modules.add(module);
    }

    public Activation getActivationPolicy() {
        return this.activationPolicy;
    }

    void setActivation(Activation activation) {
        this.activationPolicy = activation;
    }

    boolean isEmpty() {
        return this.properties.isEmpty() && this.modules.isEmpty();
    }

    public static class OSGiModule
    implements Serializable {
        private static final long serialVersionUID = -2280880859263752474L;
        private final ModuleIdentifier identifier;
        private final boolean start;

        OSGiModule(ModuleIdentifier identifier, boolean start) {
            this.identifier = identifier;
            this.start = start;
        }

        public ModuleIdentifier getIdentifier() {
            return this.identifier;
        }

        public boolean isStart() {
            return this.start;
        }
    }

    public static enum Activation {
        EAGER,
        LAZY;

    }
}

