/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.deployment.module.ClassifyingModuleLoaderInjector;
import org.jboss.as.deployment.module.ClassifyingModuleLoaderService;
import org.jboss.as.osgi.service.Configuration;
import org.jboss.as.services.net.SocketBinding;
import org.jboss.as.util.SystemPropertyActions;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathFilter;
import org.jboss.modules.PathFilters;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;

public class BundleManagerService
implements Service<BundleManager> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "bundlemanager"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private InjectedValue<Configuration> injectedConfig = new InjectedValue();
    private InjectedValue<ClassifyingModuleLoaderService> injectedModuleLoader = new InjectedValue();
    private InjectedValue<SocketBinding> osgiHttpServerPortBinding = new InjectedValue();
    private Injector<ClassifyingModuleLoaderService> osgiModuleLoaderInjector;
    private BundleManager bundleManager;

    public static void addService(BatchBuilder batchBuilder) {
        BundleManagerService service = new BundleManagerService();
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(Configuration.SERVICE_NAME, Configuration.class, service.injectedConfig);
        serviceBuilder.addDependency(ClassifyingModuleLoaderService.SERVICE_NAME, ClassifyingModuleLoaderService.class, service.injectedModuleLoader);
        serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"osgi-http"}), SocketBinding.class, service.osgiHttpServerPortBinding);
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public synchronized void start(StartContext context) throws StartException {
        log.debugf("Starting OSGi BundleManager", new Object[0]);
        try {
            String handlerModules = SystemPropertyActions.getProperty((String)"jboss.protocol.handler.modules");
            if (handlerModules == null) {
                System.setProperty("jboss.protocol.handler.modules", "org.jboss.osgi.framework");
            }
            Configuration config = (Configuration)this.injectedConfig.getValue();
            HashMap<String, Object> props = new HashMap<String, Object>(config.getProperties());
            ServiceContainer container = context.getController().getServiceContainer();
            ModuleLoader moduleLoader = ((ClassifyingModuleLoaderService)this.injectedModuleLoader.getValue()).getModuleLoader();
            Module frameworkModule = new FrameworkModuleLoader(moduleLoader, props).getFrameworkModule();
            props.put(BundleManager.IntegrationMode.class.getName(), BundleManager.IntegrationMode.CONTAINER);
            props.put(ModuleLoader.class.getName(), moduleLoader);
            props.put(ServiceContainer.class.getName(), container);
            props.put(Module.class.getName(), frameworkModule);
            props.put("org.osgi.service.http.port", "" + ((SocketBinding)this.osgiHttpServerPortBinding.getValue()).getSocketAddress().getPort());
            props.put("org.osgi.framework.storage.clean", "onFirstInit");
            this.bundleManager = new BundleManager(props);
            ModuleManagerPlugin plugin = (ModuleManagerPlugin)this.bundleManager.getPlugin(ModuleManagerPlugin.class);
            ModuleLoader osgiModuleLoader = plugin.getModuleLoader();
            ServiceController controller = container.getRequiredService(ClassifyingModuleLoaderService.SERVICE_NAME);
            ClassifyingModuleLoaderService moduleLoaderService = (ClassifyingModuleLoaderService)controller.getValue();
            ImmediateValue value = new ImmediateValue((Object)osgiModuleLoader);
            this.osgiModuleLoaderInjector = new ClassifyingModuleLoaderInjector("jbosgi", (Value)value);
            this.osgiModuleLoaderInjector.inject((Object)moduleLoaderService);
        }
        catch (Throwable t) {
            throw new StartException("Failed to create BundleManager", t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.debugf("Stopping OSGi BundleManager", new Object[0]);
        try {
            if (this.osgiModuleLoaderInjector != null) {
                this.osgiModuleLoaderInjector.uninject();
            }
            this.bundleManager = null;
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot stop OSGi BundleManager", new Object[0]);
        }
    }

    public BundleManager getValue() throws IllegalStateException {
        return this.bundleManager;
    }

    static class FrameworkModuleLoader
    extends ModuleLoader {
        private final ModuleSpec moduleSpec;
        private final ModuleIdentifier frameworkIdentifier;
        private Module defaultFrameworkModule;

        FrameworkModuleLoader(ModuleLoader moduleLoader, Map<String, Object> props) throws ModuleLoadException {
            this.defaultFrameworkModule = moduleLoader.loadModule(ModuleIdentifier.create((String)"org.jboss.osgi.framework"));
            String modulesProps = (String)props.get("org.jboss.osgi.system.modules");
            if (modulesProps == null) {
                this.frameworkIdentifier = this.defaultFrameworkModule.getIdentifier();
                this.moduleSpec = null;
                return;
            }
            this.frameworkIdentifier = ModuleIdentifier.create((String)"org.jboss.osgi.framework.extended");
            ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)this.frameworkIdentifier);
            PathFilter all = PathFilters.acceptAll();
            ModuleIdentifier moduleId = this.defaultFrameworkModule.getIdentifier();
            DependencySpec moduleDep = DependencySpec.createModuleDependencySpec((PathFilter)all, (PathFilter)all, (ModuleLoader)moduleLoader, (ModuleIdentifier)moduleId, (boolean)false);
            builder.addDependency(moduleDep);
            for (String moduleProp : modulesProps.split(",")) {
                moduleId = ModuleIdentifier.create((String)moduleProp.trim());
                moduleDep = DependencySpec.createModuleDependencySpec((PathFilter)all, (PathFilter)all, (ModuleLoader)moduleLoader, (ModuleIdentifier)moduleId, (boolean)false);
                builder.addDependency(moduleDep);
            }
            this.moduleSpec = builder.create();
        }

        Module getFrameworkModule() throws ModuleLoadException {
            return this.moduleSpec != null ? this.loadModule(this.moduleSpec.getModuleIdentifier()) : this.defaultFrameworkModule;
        }

        protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
            if (this.moduleSpec == null || !identifier.equals(this.frameworkIdentifier)) {
                throw new IllegalStateException("Cannot provide ModuleSpec for: " + identifier);
            }
            return this.moduleSpec;
        }

        public String toString() {
            return "ExtendedFrameworkModuleLoader";
        }
    }
}

