/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.ParseResult;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.CallbackConfig;
import org.jboss.as.pojo.descriptor.CollectionConfig;
import org.jboss.as.pojo.descriptor.ConstructorConfig;
import org.jboss.as.pojo.descriptor.DependsConfig;
import org.jboss.as.pojo.descriptor.FactoryConfig;
import org.jboss.as.pojo.descriptor.InjectedValueConfig;
import org.jboss.as.pojo.descriptor.InstallConfig;
import org.jboss.as.pojo.descriptor.KernelDeploymentXmlDescriptor;
import org.jboss.as.pojo.descriptor.LifecycleConfig;
import org.jboss.as.pojo.descriptor.ListConfig;
import org.jboss.as.pojo.descriptor.MapConfig;
import org.jboss.as.pojo.descriptor.ModeConfig;
import org.jboss.as.pojo.descriptor.ModuleConfig;
import org.jboss.as.pojo.descriptor.PropertyConfig;
import org.jboss.as.pojo.descriptor.SetConfig;
import org.jboss.as.pojo.descriptor.StringValueConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.descriptor.ValueFactoryConfig;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class KernelDeploymentXmlDescriptorParser
implements XMLElementReader<ParseResult<KernelDeploymentXmlDescriptor>>,
XMLStreamConstants {
    public static final String NAMESPACE = "urn:jboss:pojo:7.0";

    public void readElement(XMLExtendedStreamReader reader, ParseResult<KernelDeploymentXmlDescriptor> value) throws XMLStreamException {
        KernelDeploymentXmlDescriptor kernelDeploymentXmlDescriptor = new KernelDeploymentXmlDescriptor();
        ArrayList<BeanMetaDataConfig> beansConfigs = new ArrayList<BeanMetaDataConfig>();
        kernelDeploymentXmlDescriptor.setBeans(beansConfigs);
        value.setResult(kernelDeploymentXmlDescriptor);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            QName attributeName = reader.getAttributeName(i);
            Attribute attribute = Attribute.of(attributeName);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case MODE: {
                    kernelDeploymentXmlDescriptor.setMode(ModeConfig.of(attributeValue));
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 5: {
                    break;
                }
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case BEAN: {
                            beansConfigs.add(this.parseBean(reader));
                            break block3;
                        }
                        case UNKNOWN: {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                    }
                }
            }
        }
    }

    private BeanMetaDataConfig parseBean(XMLExtendedStreamReader reader) throws XMLStreamException {
        BeanMetaDataConfig beanConfig = new BeanMetaDataConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block26: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    beanConfig.setName(attributeValue);
                    continue block26;
                }
                case CLASS: {
                    beanConfig.setBeanClass(attributeValue);
                    continue block26;
                }
                case MODE: {
                    beanConfig.setMode(ModeConfig.of(attributeValue));
                    continue block26;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            block5 : switch (reader.nextTag()) {
                case 5: {
                    break;
                }
                case 2: {
                    return beanConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case ALIAS: {
                            Set<String> aliases = beanConfig.getAliases();
                            if (aliases == null) {
                                aliases = new HashSet<String>();
                                beanConfig.setAliases(aliases);
                            }
                            aliases.add(this.parseAlias(reader));
                            break block5;
                        }
                        case CLASSLOADER: {
                            beanConfig.setModule(this.parseModuleConfig(reader));
                            break block5;
                        }
                        case CONSTRUCTOR: {
                            beanConfig.setConstructor(this.parseConstructor(reader));
                            break block5;
                        }
                        case PROPERTY: {
                            Set<PropertyConfig> properties = beanConfig.getProperties();
                            if (properties == null) {
                                properties = new HashSet<PropertyConfig>();
                                beanConfig.setProperties(properties);
                            }
                            properties.add(this.parseProperty(reader));
                            break block5;
                        }
                        case INSTALL: {
                            List<InstallConfig> installs = beanConfig.getInstalls();
                            if (installs == null) {
                                installs = new ArrayList<InstallConfig>();
                                beanConfig.setInstalls(installs);
                            }
                            installs.add(this.parseInstall(reader));
                            break block5;
                        }
                        case UNINSTALL: {
                            List<InstallConfig> uninstalls = beanConfig.getUninstalls();
                            if (uninstalls == null) {
                                uninstalls = new ArrayList<InstallConfig>();
                                beanConfig.setUninstalls(uninstalls);
                            }
                            uninstalls.add(this.parseInstall(reader));
                            break block5;
                        }
                        case INCALLBACK: {
                            List<CallbackConfig> incallbacks = beanConfig.getIncallbacks();
                            if (incallbacks == null) {
                                incallbacks = new ArrayList<CallbackConfig>();
                                beanConfig.setIncallbacks(incallbacks);
                            }
                            incallbacks.add(this.parseCallback(reader));
                            break block5;
                        }
                        case UNCALLBACK: {
                            List<CallbackConfig> uncallbacks = beanConfig.getUncallbacks();
                            if (uncallbacks == null) {
                                uncallbacks = new ArrayList<CallbackConfig>();
                                beanConfig.setUncallbacks(uncallbacks);
                            }
                            uncallbacks.add(this.parseCallback(reader));
                            break block5;
                        }
                        case DEPENDS: {
                            Set<DependsConfig> depends = beanConfig.getDepends();
                            if (depends == null) {
                                depends = new HashSet<DependsConfig>();
                                beanConfig.setDepends(depends);
                            }
                            depends.add(this.parseDepends(reader));
                            break block5;
                        }
                        case CREATE: {
                            beanConfig.setCreate(this.parseLifecycle(reader, "create"));
                            break block5;
                        }
                        case START: {
                            beanConfig.setStart(this.parseLifecycle(reader, "start"));
                            break block5;
                        }
                        case STOP: {
                            beanConfig.setStop(this.parseLifecycle(reader, "stop"));
                            break block5;
                        }
                        case DESTROY: {
                            beanConfig.setDestroy(this.parseLifecycle(reader, "destroy"));
                            break block5;
                        }
                        case UNKNOWN: {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                    }
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private String parseAlias(XMLExtendedStreamReader reader) throws XMLStreamException {
        String alias = this.parseTextElement(reader);
        if (alias == null || alias.trim().length() == 0) {
            throw new IllegalArgumentException("Null or empty alias");
        }
        return alias;
    }

    private ConstructorConfig parseConstructor(XMLExtendedStreamReader reader) throws XMLStreamException {
        ConstructorConfig ctorConfig = new ConstructorConfig();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case FACTORY_CLASS: {
                    ctorConfig.setFactoryClass(attributeValue);
                    continue block12;
                }
                case FACTORY_METHOD: {
                    ctorConfig.setFactoryMethod(attributeValue);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    ctorConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return ctorConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case FACTORY: {
                            ctorConfig.setFactory(this.parseFactory(reader));
                            break block4;
                        }
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block4;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ModuleConfig parseModuleConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModuleConfig moduleConfig = new ModuleConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    moduleConfig.setModuleName(attributeValue);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        return moduleConfig;
    }

    private PropertyConfig parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        PropertyConfig property = new PropertyConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    property.setPropertyName(attributeValue);
                    continue block16;
                }
                case CLASS: {
                    property.setType(attributeValue);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    return property;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case VALUE: {
                            property.setValue(this.parseValue(reader));
                            break block4;
                        }
                        case INJECT: {
                            property.setValue(this.parseInject(reader));
                            break block4;
                        }
                        case VALUE_FACTORY: {
                            property.setValue(this.parseValueFactory(reader));
                            break block4;
                        }
                        case LIST: {
                            property.setValue(this.parseList(reader));
                            break block4;
                        }
                        case SET: {
                            property.setValue(this.parseSet(reader));
                            break block4;
                        }
                        case MAP: {
                            property.setValue(this.parseMap(reader));
                            break block4;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private InstallConfig parseInstall(XMLExtendedStreamReader reader) throws XMLStreamException {
        InstallConfig installConfig = new InstallConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.METHOD);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case STATE: {
                    installConfig.setWhenRequired(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block13;
                }
                case TARGET_STATE: {
                    installConfig.setDependencyState(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block13;
                }
                case BEAN: {
                    installConfig.setDependency(attributeValue);
                    continue block13;
                }
                case METHOD: {
                    installConfig.setMethodName(attributeValue);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block6 : switch (reader.next()) {
                case 2: {
                    installConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return installConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private CallbackConfig parseCallback(XMLExtendedStreamReader reader) throws XMLStreamException {
        CallbackConfig callbackConfig = new CallbackConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.METHOD);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case STATE: {
                    callbackConfig.setWhenRequired(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block9;
                }
                case TARGET_STATE: {
                    callbackConfig.setState(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block9;
                }
                case METHOD: {
                    callbackConfig.setMethodName(attributeValue);
                    continue block9;
                }
                case SIGNATURE: {
                    callbackConfig.setSignature(attributeValue);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return callbackConfig;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private DependsConfig parseDepends(XMLExtendedStreamReader reader) throws XMLStreamException {
        DependsConfig dependsConfig = new DependsConfig();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case STATE: {
                    dependsConfig.setWhenRequired(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block5;
                }
                case TARGET_STATE: {
                    dependsConfig.setDependencyState(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block5;
                }
                case SERVICE: {
                    dependsConfig.setService(Boolean.parseBoolean(attributeValue));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        String dependency = this.parseTextElement(reader);
        if (dependency == null || dependency.trim().length() == 0) {
            throw new IllegalArgumentException("Null or empty dependency");
        }
        dependsConfig.setDependency(dependency);
        return dependsConfig;
    }

    private LifecycleConfig parseLifecycle(XMLExtendedStreamReader reader, String defaultMethodName) throws XMLStreamException {
        LifecycleConfig lifecycleConfig = new LifecycleConfig();
        lifecycleConfig.setMethodName(defaultMethodName);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case METHOD: {
                    lifecycleConfig.setMethodName(attributeValue);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block3 : switch (reader.next()) {
                case 2: {
                    lifecycleConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return lifecycleConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block3;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseParameter(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueConfig valueConfig = null;
        String type = null;
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    type = attributeValue;
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.next()) {
                case 2: {
                    if (valueConfig == null) {
                        throw new XMLStreamException("Missing value", reader.getLocation());
                    }
                    if (valueConfig.getType() == null) {
                        valueConfig.setType(type);
                    }
                    return valueConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case VALUE: {
                            valueConfig = this.parseValue(reader);
                            break block3;
                        }
                        case INJECT: {
                            valueConfig = this.parseInject(reader);
                            break block3;
                        }
                        case VALUE_FACTORY: {
                            valueConfig = this.parseValueFactory(reader);
                            break block3;
                        }
                        case LIST: {
                            valueConfig = this.parseList(reader);
                            break block3;
                        }
                        case SET: {
                            valueConfig = this.parseSet(reader);
                            break block3;
                        }
                        case MAP: {
                            valueConfig = this.parseMap(reader);
                            break block3;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private InjectedValueConfig parseInject(XMLExtendedStreamReader reader) throws XMLStreamException {
        InjectedValueConfig injectedValueConfig = new InjectedValueConfig();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    injectedValueConfig.setBean(attributeValue);
                    continue block9;
                }
                case STATE: {
                    injectedValueConfig.setState(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block9;
                }
                case SERVICE: {
                    injectedValueConfig.setService(attributeValue);
                    continue block9;
                }
                case PROPERTY: {
                    injectedValueConfig.setProperty(attributeValue);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return injectedValueConfig;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private FactoryConfig parseFactory(XMLExtendedStreamReader reader) throws XMLStreamException {
        FactoryConfig factoryConfig = new FactoryConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    factoryConfig.setBean(attributeValue);
                    continue block7;
                }
                case STATE: {
                    factoryConfig.setState(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return factoryConfig;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseList(XMLExtendedStreamReader reader) throws XMLStreamException {
        return this.parseCollection(reader, new ListConfig());
    }

    private ValueConfig parseSet(XMLExtendedStreamReader reader) throws XMLStreamException {
        return this.parseCollection(reader, new SetConfig());
    }

    private ValueConfig parseCollection(XMLExtendedStreamReader reader, CollectionConfig config) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    config.setType(attributeValue);
                    continue block16;
                }
                case ELEMENT: {
                    config.setElementType(attributeValue);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    return config;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case VALUE: {
                            config.addValue(this.parseValue(reader));
                            break block4;
                        }
                        case INJECT: {
                            config.addValue(this.parseInject(reader));
                            break block4;
                        }
                        case VALUE_FACTORY: {
                            config.addValue(this.parseValueFactory(reader));
                            break block4;
                        }
                        case LIST: {
                            config.addValue(this.parseList(reader));
                            break block4;
                        }
                        case SET: {
                            config.addValue(this.parseSet(reader));
                            break block4;
                        }
                        case MAP: {
                            config.addValue(this.parseMap(reader));
                            break block4;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseMap(XMLExtendedStreamReader reader) throws XMLStreamException {
        MapConfig mapConfig = new MapConfig();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    mapConfig.setType(attributeValue);
                    continue block12;
                }
                case KEY_ELEMENT: {
                    mapConfig.setKeyType(attributeValue);
                    continue block12;
                }
                case VALUE_ELEMENT: {
                    mapConfig.setValueType(attributeValue);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            block5 : switch (reader.next()) {
                case 2: {
                    return mapConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case ENTRY: {
                            ValueConfig[] entry = this.parseEntry(reader);
                            mapConfig.put(entry[0], entry[1]);
                            break block5;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig[] parseEntry(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueConfig[] entry = new ValueConfig[2];
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 2: {
                    return entry;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case KEY: {
                            entry[0] = this.parseValueValue(reader);
                            break block0;
                        }
                        case VALUE: {
                            entry[1] = this.parseValueValue(reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseValueValue(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueConfig value = null;
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 2: {
                    if (value == null) {
                        throw new IllegalArgumentException("Null value: " + reader.getLocation());
                    }
                    return value;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case VALUE: {
                            value = this.parseValue(reader);
                            break block0;
                        }
                        case INJECT: {
                            value = this.parseInject(reader);
                            break block0;
                        }
                        case VALUE_FACTORY: {
                            value = this.parseValueFactory(reader);
                            break block0;
                        }
                        case LIST: {
                            value = this.parseList(reader);
                            break block0;
                        }
                        case SET: {
                            value = this.parseSet(reader);
                            break block0;
                        }
                        case MAP: {
                            value = this.parseMap(reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case 4: {
                    StringValueConfig svc = new StringValueConfig();
                    svc.setValue(reader.getText());
                    value = svc;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueFactoryConfig parseValueFactory(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueFactoryConfig valueFactoryConfig = new ValueFactoryConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN, Attribute.METHOD);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    valueFactoryConfig.setBean(attributeValue);
                    continue block12;
                }
                case METHOD: {
                    valueFactoryConfig.setMethod(attributeValue);
                    continue block12;
                }
                case STATE: {
                    valueFactoryConfig.setState(BeanState.valueOf(attributeValue.toUpperCase()));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block5 : switch (reader.next()) {
                case 2: {
                    valueFactoryConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return valueFactoryConfig;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block5;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseValue(XMLExtendedStreamReader reader) throws XMLStreamException {
        StringValueConfig valueConfig = new StringValueConfig();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    valueConfig.setType(attributeValue);
                    continue block5;
                }
                case REPLACE: {
                    valueConfig.setReplaceProperties(Boolean.parseBoolean(attributeValue));
                    continue block5;
                }
                case TRIM: {
                    valueConfig.setTrim(Boolean.parseBoolean(attributeValue));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        valueConfig.setValue(this.parseTextElement(reader));
        return valueConfig;
    }

    private String parseTextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String value = null;
        block4: while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return value;
                }
                case 4: {
                    value = reader.getText();
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private static enum Attribute {
        MODE(new QName("mode")),
        NAME(new QName("name")),
        TYPE(new QName("type")),
        VALUE(new QName("value")),
        TRIM(new QName("trim")),
        REPLACE(new QName("replace")),
        BEAN(new QName("bean")),
        SERVICE(new QName("service")),
        PROPERTY(new QName("property")),
        CLASS(new QName("class")),
        ELEMENT(new QName("elementClass")),
        KEY_ELEMENT(new QName("keyClass")),
        VALUE_ELEMENT(new QName("valueClass")),
        METHOD(new QName("method")),
        SIGNATURE(new QName("signature")),
        FACTORY_CLASS(new QName("factory-class")),
        FACTORY_METHOD(new QName("factory-method")),
        STATE(new QName("state")),
        TARGET_STATE(new QName("targetState")),
        UNKNOWN(null);

        private final QName qName;
        private static final Map<QName, Attribute> QNAME_MAP;

        private Attribute(QName qName) {
            this.qName = qName;
        }

        static Attribute of(QName qName) {
            Attribute attribute = QNAME_MAP.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            QNAME_MAP = new HashMap<QName, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                QNAME_MAP.put(attribute.qName, attribute);
            }
        }
    }

    private static enum Element {
        BEAN(new QName("urn:jboss:pojo:7.0", "bean")),
        CLASSLOADER(new QName("urn:jboss:pojo:7.0", "classloader")),
        CONSTRUCTOR(new QName("urn:jboss:pojo:7.0", "constructor")),
        FACTORY(new QName("urn:jboss:pojo:7.0", "factory")),
        PROPERTY(new QName("urn:jboss:pojo:7.0", "property")),
        VALUE(new QName("urn:jboss:pojo:7.0", "value")),
        INJECT(new QName("urn:jboss:pojo:7.0", "inject")),
        VALUE_FACTORY(new QName("urn:jboss:pojo:7.0", "value-factory")),
        PARAMETER(new QName("urn:jboss:pojo:7.0", "parameter")),
        DEPENDS(new QName("urn:jboss:pojo:7.0", "depends")),
        ALIAS(new QName("urn:jboss:pojo:7.0", "alias")),
        ANNOTATION(new QName("urn:jboss:pojo:7.0", "annotation")),
        CREATE(new QName("urn:jboss:pojo:7.0", "create")),
        START(new QName("urn:jboss:pojo:7.0", "start")),
        STOP(new QName("urn:jboss:pojo:7.0", "stop")),
        DESTROY(new QName("urn:jboss:pojo:7.0", "destroy")),
        INSTALL(new QName("urn:jboss:pojo:7.0", "install")),
        UNINSTALL(new QName("urn:jboss:pojo:7.0", "uninstall")),
        INCALLBACK(new QName("urn:jboss:pojo:7.0", "incallback")),
        UNCALLBACK(new QName("urn:jboss:pojo:7.0", "uncallback")),
        LIST(new QName("urn:jboss:pojo:7.0", "list")),
        SET(new QName("urn:jboss:pojo:7.0", "set")),
        MAP(new QName("urn:jboss:pojo:7.0", "map")),
        ENTRY(new QName("urn:jboss:pojo:7.0", "entry")),
        KEY(new QName("urn:jboss:pojo:7.0", "key")),
        UNKNOWN(null);

        private final QName qName;
        private static final Map<QName, Element> QNAME_MAP;

        private Element(QName qName) {
            this.qName = qName;
        }

        static Element of(QName qName) {
            Element element = QNAME_MAP.get(qName);
            return element == null ? UNKNOWN : element;
        }

        static {
            QNAME_MAP = new HashMap<QName, Element>();
            for (Element element : Element.values()) {
                QNAME_MAP.put(element.qName, element);
            }
        }
    }
}

