/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.PropertyConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.AbstractPojoPhase;
import org.jboss.as.pojo.service.CreateDestroyPojoPhase;
import org.jboss.as.pojo.service.MethodJoinpoint;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class ConfiguredPojoPhase
extends AbstractPojoPhase {
    @Override
    protected BeanState getLifecycleState() {
        return BeanState.CONFIGURED;
    }

    @Override
    protected AbstractPojoPhase createNextPhase() {
        return new CreateDestroyPojoPhase();
    }

    protected void configure(boolean nullify) throws Throwable {
        Set<PropertyConfig> properties = this.getBeanConfig().getProperties();
        if (properties != null) {
            ArrayList<PropertyConfig> used = new ArrayList<PropertyConfig>();
            for (PropertyConfig pc : properties) {
                try {
                    this.configure(pc, nullify);
                    used.add(pc);
                }
                catch (Throwable t) {
                    if (nullify) continue;
                    for (PropertyConfig upc : used) {
                        try {
                            this.configure(upc, true);
                        }
                        catch (Throwable ignored) {}
                    }
                    throw new StartException(t);
                }
            }
        }
    }

    protected void configure(PropertyConfig pc, boolean nullify) throws Throwable {
        ValueConfig value = pc.getValue();
        Class clazz = null;
        String type = pc.getType();
        if (type == null) {
            type = value.getType();
        }
        if (type != null) {
            clazz = this.getModule().getClassLoader().loadClass(type);
        }
        Method setter = this.getBeanInfo().getSetter(pc.getPropertyName(), clazz);
        MethodJoinpoint joinpoint = new MethodJoinpoint(setter);
        ValueConfig param = !nullify ? value : null;
        joinpoint.setParameters(new ValueConfig[]{param});
        joinpoint.setTarget((Value<Object>)new ImmediateValue(this.getBean()));
        joinpoint.dispatch();
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            this.configure(false);
        }
        catch (StartException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new StartException(t);
        }
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        try {
            this.configure(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

