/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.jboss.as.process.ProcessController;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.logging.Logger;

final class ManagedProcess {
    private final String processName;
    private final List<String> command;
    private final Map<String, String> env;
    private final String workingDirectory;
    private final Logger log;
    private final Object lock;
    private final ProcessController processController;
    private final byte[] authKey;
    private final boolean isInitial;
    private OutputStream stdin;
    private State state = State.DOWN;
    private Process process;
    private boolean shutdown;

    public byte[] getAuthKey() {
        return this.authKey;
    }

    public boolean isInitial() {
        return this.isInitial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == State.STARTED;
        }
    }

    ManagedProcess(String processName, List<String> command, Map<String, String> env, String workingDirectory, Object lock, ProcessController controller, byte[] authKey, boolean initial) {
        if (processName == null) {
            throw new IllegalArgumentException("processName is null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        if (env == null) {
            throw new IllegalArgumentException("env is null");
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException("workingDirectory is null");
        }
        if (lock == null) {
            throw new IllegalArgumentException("lock is null");
        }
        if (controller == null) {
            throw new IllegalArgumentException("controller is null");
        }
        if (authKey == null) {
            throw new IllegalArgumentException("authKey is null");
        }
        if (authKey.length != 16) {
            throw new IllegalArgumentException("authKey length is invalid");
        }
        this.processName = processName;
        this.command = command;
        this.env = env;
        this.workingDirectory = workingDirectory;
        this.lock = lock;
        this.processController = controller;
        this.authKey = authKey;
        this.isInitial = initial;
        this.log = Logger.getLogger((String)("org.jboss.as.process." + processName + ".status"));
    }

    public String getProcessName() {
        return this.processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.DOWN) {
                this.log.debugf("Attempted to start already-running process '%s'", (Object)this.processName);
                return;
            }
            this.doStart();
        }
    }

    public void sendStdin(InputStream msg) {
        try {
            StreamUtils.copyStream((InputStream)msg, (OutputStream)this.stdin);
            this.stdin.flush();
        }
        catch (IOException e) {
            this.log.errorf((Throwable)e, "Failed to send data bytes to process '%s' input stream", (Object)this.processName);
        }
    }

    private void doStart() {
        Process process;
        this.log.infof("Starting process '%s'", (Object)this.processName);
        this.log.debugf("Process name='%s' command='%s' workingDirectory='%s'", (Object)this.processName, this.command, (Object)this.workingDirectory);
        ProcessBuilder builder = new ProcessBuilder(this.command);
        builder.environment().putAll(this.env);
        builder.directory(new File(this.workingDirectory));
        try {
            process = builder.start();
        }
        catch (IOException e) {
            this.log.errorf((Throwable)e, "Failed to start process '%s'", (Object)this.processName);
            return;
        }
        long startTime = System.currentTimeMillis();
        OutputStream stdin = process.getOutputStream();
        InputStream stderr = process.getErrorStream();
        InputStream stdout = process.getInputStream();
        Thread stderrThread = new Thread(new ReadTask(stderr, this.processController.getStderr()));
        stderrThread.setName(String.format("stderr for %s", this.processName));
        stderrThread.start();
        Thread stdoutThread = new Thread(new ReadTask(stdout, this.processController.getStdout()));
        stdoutThread.setName(String.format("stdout for %s", this.processName));
        stdoutThread.start();
        Thread joinThread = new Thread(new JoinTask(startTime));
        joinThread.setName(String.format("reaper for %s", this.processName));
        joinThread.start();
        try {
            stdin.write(this.authKey);
            stdin.flush();
        }
        catch (Exception e) {
            this.log.warnf("Failed to send authentication key to process '%s': %s", (Object)this.processName, (Object)e);
        }
        this.state = State.STARTED;
        this.process = process;
        this.stdin = stdin;
        this.processController.processStarted(this.processName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.STARTED) {
                this.log.debugf("Attempted to stop already-stopping or down process '%s'", (Object)this.processName);
                return;
            }
            this.log.infof("Stopping process '%s'", (Object)this.processName);
            StreamUtils.safeClose((Closeable)this.stdin);
            this.state = State.STOPPING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.shutdown = true;
            if (this.state == State.STARTED) {
                this.log.infof("Stopping process '%s'", (Object)this.processName);
                StreamUtils.safeClose((Closeable)this.stdin);
            }
            this.state = State.STOPPING;
        }
    }

    private final class ReadTask
    implements Runnable {
        private final InputStream source;
        private final PrintStream target;

        private ReadTask(InputStream source, PrintStream target) {
            this.source = source;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream source = this.source;
            String processName = ManagedProcess.this.processName;
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(source)));
                OutputStreamWriter writer = new OutputStreamWriter(this.target);
                while ((s = reader.readLine()) != null) {
                    PrintStream printStream = this.target;
                    synchronized (printStream) {
                        writer.write(91);
                        writer.write(processName);
                        writer.write("] ");
                        writer.write(s);
                        writer.write(10);
                        writer.flush();
                    }
                }
                source.close();
            }
            catch (IOException e) {
                ManagedProcess.this.log.error("Stream processing failed for process '%s': %s", (Object)processName, (Throwable)e);
            }
            finally {
                StreamUtils.safeClose((Closeable)source);
            }
        }
    }

    private final class JoinTask
    implements Runnable {
        private final long startTime;

        public JoinTask(long startTime) {
            this.startTime = startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process process;
            Object object = ManagedProcess.this.lock;
            synchronized (object) {
                process = ManagedProcess.this.process;
            }
            while (true) {
                try {
                    int value = process.waitFor();
                    ManagedProcess.this.log.infof("Process '%s' finished with an exit status of %d", (Object)ManagedProcess.this.processName, (Object)value);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            Object object2 = ManagedProcess.this.lock;
            synchronized (object2) {
                long endTime = System.currentTimeMillis();
                ManagedProcess.this.state = State.DOWN;
                if (ManagedProcess.this.shutdown) {
                    ManagedProcess.this.processController.removeProcess(ManagedProcess.this.processName);
                } else {
                    ManagedProcess.this.processController.processStopped(ManagedProcess.this.processName, endTime - this.startTime);
                    if (ManagedProcess.this.isInitial()) {
                        ManagedProcess.this.doStart();
                    }
                }
            }
        }
    }

    static enum State {
        DOWN,
        STARTED,
        STOPPING;

    }
}

