/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(final String moduleSpec) throws ModuleLoadException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ModuleClassLoader>(){

                @Override
                public ModuleClassLoader run() throws ModuleLoadException {
                    ModuleLoader loader = Module.getCurrentModuleLoader();
                    ModuleIdentifier identifier = ModuleIdentifier.fromString((String)moduleSpec);
                    return loader.loadModule(identifier).getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ModuleLoadException((Throwable)pae);
        }
    }
}

