/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.security.ACLResourceDefinition;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.AuditResourceDefinition;
import org.jboss.as.security.AuthorizationResourceDefinition;
import org.jboss.as.security.ClassicAuthenticationResourceDefinition;
import org.jboss.as.security.Element;
import org.jboss.as.security.IdentityTrustResourceDefinition;
import org.jboss.as.security.JASPIAuthenticationModulesAttributeDefinition;
import org.jboss.as.security.JASPIAuthenticationResourceDefinition;
import org.jboss.as.security.JSSEResourceDefinition;
import org.jboss.as.security.KeyManagerAttributeDefinition;
import org.jboss.as.security.KeyStoreAttributeDefinition;
import org.jboss.as.security.LoginModuleStackResourceDefinition;
import org.jboss.as.security.LoginModulesAttributeDefinition;
import org.jboss.as.security.MappingModulesAttributeDefinition;
import org.jboss.as.security.MappingResourceDefinition;
import org.jboss.as.security.ModulesMap;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.SecuritySubsystemRootResourceDefinition;
import org.jboss.as.security.VaultResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SecuritySubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext>,
ModulesMap {
    private static final SecuritySubsystemParser INSTANCE = new SecuritySubsystemParser();

    public static SecuritySubsystemParser getInstance() {
        return INSTANCE;
    }

    private SecuritySubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        ModelNode address = subsystem.get("address");
        address.add("subsystem", "security");
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        List<ModelNode> securityDomainsUpdates = null;
        ModelNode vault = null;
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
            Element element = Element.forName(reader.getLocalName());
            if (!visited.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case SECURITY_MANAGEMENT: {
                    this.parseSecurityManagement(reader, subsystem);
                    continue block9;
                }
                case SECURITY_DOMAINS: {
                    securityDomainsUpdates = this.parseSecurityDomains(reader, address);
                    continue block9;
                }
                case SECURITY_PROPERTIES: {
                    reader.discardRemainder();
                    continue block9;
                }
                case VAULT: {
                    if (schemaVer == Namespace.SECURITY_1_0) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    int count = reader.getAttributeCount();
                    vault = this.createAddOperation(address, "vault", "classic");
                    if (count > 1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)count);
                    }
                    block10: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case CODE: {
                                String code = value;
                                vault.get("code").set(code);
                                continue block10;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    this.parseVaultOptions(reader, vault);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(subsystem);
        if (vault != null) {
            list.add(vault);
        }
        if (securityDomainsUpdates != null) {
            list.addAll(securityDomainsUpdates);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined("deep-copy-subject-mode") && node.get("deep-copy-subject-mode").asBoolean()) {
            writer.writeEmptyElement(Element.SECURITY_MANAGEMENT.getLocalName());
            this.writeAttribute(writer, Attribute.DEEP_COPY_SUBJECT_MODE, node.get("deep-copy-subject-mode"));
        }
        if (node.hasDefined("security-domain") && node.get("security-domain").asInt() > 0) {
            writer.writeStartElement(Element.SECURITY_DOMAINS.getLocalName());
            for (Property policy : node.get("security-domain").asPropertyList()) {
                writer.writeStartElement(Element.SECURITY_DOMAIN.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), policy.getName());
                ModelNode policyDetails = policy.getValue();
                SecurityDomainResourceDefinition.CACHE_TYPE.marshallAsAttribute(policyDetails, (XMLStreamWriter)writer);
                this.writeSecurityDomainContent(writer, policyDetails);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (node.hasDefined("vault")) {
            ModelNode vault = node.get(new String[]{"vault", "classic"});
            writer.writeStartElement(Element.VAULT.getLocalName());
            VaultResourceDefinition.CODE.marshallAsAttribute(vault, (XMLStreamWriter)writer);
            if (vault.hasDefined("options")) {
                ModelNode properties = vault.get("options");
                for (Property prop : properties.asPropertyList()) {
                    writer.writeEmptyElement(Element.VAULT_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeSecurityDomainContent(XMLExtendedStreamWriter writer, ModelNode policyDetails) throws XMLStreamException {
        HashSet keys = new HashSet(policyDetails.keys());
        keys.remove("name");
        keys.remove("cache-type");
        block9: for (String key : keys) {
            Element element = Element.forName(key);
            switch (element) {
                case AUTHENTICATION: {
                    ModelNode kind = policyDetails.get("authentication");
                    for (Property prop : kind.asPropertyList()) {
                        if ("classic".equals(prop.getName())) {
                            this.writeAuthentication(writer, prop.getValue());
                            continue;
                        }
                        if (!"jaspi".equals(prop.getName())) continue;
                        this.writeAuthenticationJaspi(writer, prop.getValue());
                    }
                    continue block9;
                }
                case AUTHORIZATION: {
                    this.writeAuthorization(writer, policyDetails.get(new String[]{"authorization", "classic"}));
                    break;
                }
                case ACL: {
                    this.writeACL(writer, policyDetails.get(new String[]{"acl", "classic"}));
                    break;
                }
                case AUDIT: {
                    this.writeAudit(writer, policyDetails.get(new String[]{"audit", "classic"}));
                    break;
                }
                case IDENTITY_TRUST: {
                    this.writeIdentityTrust(writer, policyDetails.get(new String[]{"identity-trust", "classic"}));
                    break;
                }
                case MAPPING: {
                    this.writeMapping(writer, policyDetails.get(new String[]{"mapping", "classic"}));
                    break;
                }
                case JSSE: {
                    this.writeJSSE(writer, policyDetails.get(new String[]{"jsse", "classic"}));
                }
            }
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
            ClassicAuthenticationResourceDefinition.LOGIN_MODULES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeAuthorization(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
            AuthorizationResourceDefinition.POLICY_MODULES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeACL(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.ACL.getLocalName());
            ACLResourceDefinition.ACL_MODULES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeAudit(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUDIT.getLocalName());
            AuditResourceDefinition.PROVIDER_MODULES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeIdentityTrust(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.IDENTITY_TRUST.getLocalName());
            IdentityTrustResourceDefinition.TRUST_MODULES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeMapping(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.MAPPING.getLocalName());
            MappingResourceDefinition.MAPPING_MODULES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeAuthenticationJaspi(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION_JASPI.getLocalName());
            ModelNode moduleStack = modelNode.get("login-module-stack");
            this.writeLoginModuleStack(writer, moduleStack);
            JASPIAuthenticationResourceDefinition.AUTH_MODULES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeLoginModuleStack(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            List stacks = modelNode.asPropertyList();
            for (Property stack : stacks) {
                writer.writeStartElement(Element.LOGIN_MODULE_STACK.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), stack.getName());
                LoginModuleStackResourceDefinition.LOGIN_MODULES.marshallAsElement(stack.getValue(), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeJSSE(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.JSSE.getLocalName());
            JSSEResourceDefinition.KEYSTORE.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.TRUSTSTORE.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.KEYMANAGER.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.TRUSTMANAGER.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.CIPHER_SUITES.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.SERVER_ALIAS.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.SERVICE_AUTH_TOKEN.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.CLIENT_ALIAS.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.CLIENT_AUTH.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.PROTOCOLS.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.ADDITIONAL_PROPERTIES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    private void parseSecurityManagement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEEP_COPY_SUBJECT_MODE: {
                    SecuritySubsystemRootResourceDefinition.DEEP_COPY_SUBJECT_MODE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseVaultOptions(XMLExtendedStreamReader reader, ModelNode vault) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case VAULT_OPTION: {
                    this.parsePropertyElement(reader, vault.get("options"));
                }
            }
        }
    }

    private List<ModelNode> parseSecurityDomains(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_DOMAIN: {
                    this.parseSecurityDomain(list, reader, parentAddress);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return list;
    }

    private void parseSecurityDomain(List<ModelNode> list, XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        ModelNode address = op.get("address");
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (value == null || value.length() == 0) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    address.set(parentAddress).add("security-domain", value);
                    continue block14;
                }
                case CACHE_TYPE: {
                    SecurityDomainResourceDefinition.CACHE_TYPE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!visited.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case AUTHENTICATION: {
                    if (visited.contains((Object)Element.AUTHENTICATION_JASPI)) {
                        throw new XMLStreamException("A security domain can have either an <authentication> or <authentication-jaspi> element, not both", reader.getLocation());
                    }
                    this.parseAuthentication(list, address, reader);
                    continue block15;
                }
                case AUTHORIZATION: {
                    this.parseAuthorization(list, address, reader);
                    continue block15;
                }
                case ACL: {
                    this.parseACL(list, address, reader);
                    continue block15;
                }
                case AUDIT: {
                    this.parseAudit(list, address, reader);
                    continue block15;
                }
                case IDENTITY_TRUST: {
                    this.parseIdentityTrust(list, address, reader);
                    continue block15;
                }
                case MAPPING: {
                    this.parseMapping(list, address, reader);
                    continue block15;
                }
                case AUTHENTICATION_JASPI: {
                    if (visited.contains((Object)Element.AUTHENTICATION)) {
                        throw new XMLStreamException("A security domain can have either an <authentication> or <authentication-jaspi> element, not both", reader.getLocation());
                    }
                    this.parseAuthenticationJaspi(list, address, reader);
                    continue block15;
                }
                case JSSE: {
                    this.parseJSSE(list, address, reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthentication(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode op = this.appendAddOperation(list, parentAddress, "authentication", "classic");
        this.parseLoginModules(reader, op.get("login-modules"));
    }

    private void parseLoginModules(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                    this.parseCommonModule(reader, op.add(), required, notAllowed);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode appendAddOperation(List<ModelNode> list, ModelNode parentAddress, String name, String value) {
        ModelNode op = this.createAddOperation(parentAddress, name, value);
        list.add(op);
        return op;
    }

    private ModelNode createAddOperation(ModelNode parentAddress, String name, String value) {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(parentAddress).add(name, value);
        return op;
    }

    private void parseAuthorization(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode op = this.appendAddOperation(list, parentAddress, "authorization", "classic");
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case POLICY_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                    this.parseCommonModule(reader, op.get("policy-modules").add(), required, notAllowed);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseACL(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode op = this.appendAddOperation(list, parentAddress, "acl", "classic");
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACL_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                    this.parseCommonModule(reader, op.get("acl-modules").add(), required, notAllowed);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAudit(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode op = this.appendAddOperation(list, parentAddress, "audit", "classic");
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROVIDER_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.FLAG);
                    this.parseCommonModule(reader, op.get("provider-modules").add(), required, notAllowed);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentityTrust(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode op = this.appendAddOperation(list, parentAddress, "identity-trust", "classic");
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRUST_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                    this.parseCommonModule(reader, op.get("trust-modules").add(), required, notAllowed);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMapping(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode op = this.appendAddOperation(list, parentAddress, "mapping", "classic");
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MAPPING_MODULE: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                    EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.FLAG);
                    this.parseCommonModule(reader, op.get("mapping-modules").add(), required, notAllowed);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCommonModule(XMLExtendedStreamReader reader, ModelNode node, EnumSet<Attribute> required, EnumSet<Attribute> notAllowed) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (notAllowed.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            required.remove((Object)attribute);
            switch (attribute) {
                case CODE: {
                    ModelNode code = LoginModulesAttributeDefinition.parseField("code", value, (XMLStreamReader)reader);
                    node.get("code").set(code);
                    continue block6;
                }
                case FLAG: {
                    ModelNode flag = LoginModulesAttributeDefinition.parseField("flag", value, (XMLStreamReader)reader);
                    node.get("flag").set(flag);
                    continue block6;
                }
                case TYPE: {
                    ModelNode type = MappingModulesAttributeDefinition.parseField("type", value, (XMLStreamReader)reader);
                    node.get("type").set(type);
                    continue block6;
                }
                case MODULE: {
                    ModelNode module = MappingModulesAttributeDefinition.parseField("module", value, (XMLStreamReader)reader);
                    node.get("module").set(module);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        this.parseProperties(Element.MODULE_OPTION.getLocalName(), reader, node.get("module-options"));
    }

    private void parseAuthenticationJaspi(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode op = this.appendAddOperation(list, parentAddress, "authentication", "jaspi");
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN_MODULE_STACK: {
                    this.parseLoginModuleStack(list, op.get("address"), reader);
                    continue block4;
                }
                case AUTH_MODULE: {
                    ModelNode node = op.get("auth-modules");
                    this.parseAuthModule(reader, node.add());
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLoginModuleStack(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (value == null) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode op = this.appendAddOperation(list, parentAddress, "login-module-stack", name);
        this.parseLoginModules(reader, op.get("login-modules"));
    }

    private void parseAuthModule(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CODE: {
                    ModelNode code = JASPIAuthenticationModulesAttributeDefinition.parseField("code", value, (XMLStreamReader)reader);
                    op.get("code").set(code);
                    continue block4;
                }
                case LOGIN_MODULE_STACK_REF: {
                    ModelNode ref = JASPIAuthenticationModulesAttributeDefinition.parseField("login-module-stack-ref", value, (XMLStreamReader)reader);
                    op.get("login-module-stack-ref").set(ref);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        this.parseProperties(Element.MODULE_OPTION.getLocalName(), reader, op.get("module-options"));
    }

    private void parseProperties(String childElementName, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (childElementName.equals(element.getLocalName())) {
                this.parsePropertyElement(reader, node);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePropertyElement(XMLExtendedStreamReader reader, ModelNode properties) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (value == null) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    name = value.trim();
                    continue block4;
                }
                case VALUE: {
                    val = value != null ? value.trim() : value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        properties.add(name, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJSSE(List<ModelNode> list, ModelNode parentAddress, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode op = this.appendAddOperation(list, parentAddress, "jsse", "classic");
        EnumSet<Attribute> visited = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEYSTORE_PASSWORD: {
                    ModelNode password = KeyStoreAttributeDefinition.parseField("password", value, (XMLStreamReader)reader);
                    op.get(new String[]{"keystore", "password"}).set(password);
                    visited.add(attribute);
                    continue block22;
                }
                case KEYSTORE_TYPE: {
                    ModelNode type = KeyStoreAttributeDefinition.parseField("type", value, (XMLStreamReader)reader);
                    op.get(new String[]{"keystore", "type"}).set(type);
                    continue block22;
                }
                case KEYSTORE_URL: {
                    ModelNode url = KeyStoreAttributeDefinition.parseField("url", value, (XMLStreamReader)reader);
                    op.get(new String[]{"keystore", "url"}).set(url);
                    continue block22;
                }
                case KEYSTORE_PROVIDER: {
                    ModelNode provider = KeyStoreAttributeDefinition.parseField("provider", value, (XMLStreamReader)reader);
                    op.get(new String[]{"keystore", "provider"}).set(provider);
                    continue block22;
                }
                case KEYSTORE_PROVIDER_ARGUMENT: {
                    ModelNode argument = KeyStoreAttributeDefinition.parseField("provider-argument", value, (XMLStreamReader)reader);
                    op.get(new String[]{"keystore", "provider-argument"}).set(argument);
                    continue block22;
                }
                case KEY_MANAGER_FACTORY_PROVIDER: {
                    ModelNode provider = KeyManagerAttributeDefinition.parseField("provider", value, (XMLStreamReader)reader);
                    op.get(new String[]{"key-manager", "provider"}).set(provider);
                    continue block22;
                }
                case KEY_MANAGER_FACTORY_ALGORITHM: {
                    ModelNode provider = KeyManagerAttributeDefinition.parseField("algorithm", value, (XMLStreamReader)reader);
                    op.get(new String[]{"key-manager", "algorithm"}).set(provider);
                    continue block22;
                }
                case TRUSTSTORE_PASSWORD: {
                    ModelNode password = KeyStoreAttributeDefinition.parseField("password", value, (XMLStreamReader)reader);
                    op.get(new String[]{"truststore", "password"}).set(password);
                    visited.add(attribute);
                    continue block22;
                }
                case TRUSTSTORE_TYPE: {
                    ModelNode type = KeyStoreAttributeDefinition.parseField("type", value, (XMLStreamReader)reader);
                    op.get(new String[]{"truststore", "type"}).set(type);
                    continue block22;
                }
                case TRUSTSTORE_URL: {
                    ModelNode url = KeyStoreAttributeDefinition.parseField("url", value, (XMLStreamReader)reader);
                    op.get(new String[]{"truststore", "url"}).set(url);
                    continue block22;
                }
                case TRUSTSTORE_PROVIDER: {
                    ModelNode provider = KeyStoreAttributeDefinition.parseField("provider", value, (XMLStreamReader)reader);
                    op.get(new String[]{"truststore", "provider"}).set(provider);
                    continue block22;
                }
                case TRUSTSTORE_PROVIDER_ARGUMENT: {
                    ModelNode argument = KeyStoreAttributeDefinition.parseField("provider-argument", value, (XMLStreamReader)reader);
                    op.get(new String[]{"truststore", "provider-argument"}).set(argument);
                    continue block22;
                }
                case TRUST_MANAGER_FACTORY_PROVIDER: {
                    ModelNode provider = KeyManagerAttributeDefinition.parseField("provider", value, (XMLStreamReader)reader);
                    op.get(new String[]{"trust-manager", "provider"}).set(provider);
                    continue block22;
                }
                case TRUST_MANAGER_FACTORY_ALGORITHM: {
                    ModelNode provider = KeyManagerAttributeDefinition.parseField("algorithm", value, (XMLStreamReader)reader);
                    op.get(new String[]{"trust-manager", "algorithm"}).set(provider);
                    continue block22;
                }
                case CLIENT_ALIAS: {
                    JSSEResourceDefinition.CLIENT_ALIAS.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case SERVER_ALIAS: {
                    JSSEResourceDefinition.SERVER_ALIAS.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case CLIENT_AUTH: {
                    JSSEResourceDefinition.CLIENT_AUTH.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case SERVICE_AUTH_TOKEN: {
                    JSSEResourceDefinition.SERVICE_AUTH_TOKEN.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case CIPHER_SUITES: {
                    JSSEResourceDefinition.CIPHER_SUITES.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                case PROTOCOLS: {
                    JSSEResourceDefinition.PROTOCOLS.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block22;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (visited.size() == 0) {
            throw new XMLStreamException("Missing required attribute: either " + Attribute.KEYSTORE_PASSWORD.getLocalName() + " or " + Attribute.TRUSTSTORE_PASSWORD.getLocalName() + " must be present", reader.getLocation());
        }
        this.parseProperties(Element.PROPERTY.getLocalName(), reader, op.get("additional-properties"));
    }
}

