/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.io.BufferedInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.impl.HostUpdateApplierResponse;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.NewRepositoryContentUpdate;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.server.manager.HostConfigurationPersister;
import org.jboss.as.server.manager.HostConfigurationPersisterImpl;
import org.jboss.as.server.manager.ServerManagerEnvironment;
import org.jboss.as.server.manager.StandardElementReaderRegistrar;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLMapper;

public class ModelManager {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.manager");
    private final HostConfigurationPersister configPersister;
    private DomainModel domainModel;
    private volatile HostModel hostModel;
    private final StandardElementReaderRegistrar extensionRegistrar;
    private FileRepository repository;

    ModelManager(ServerManagerEnvironment environment, StandardElementReaderRegistrar extensionRegistrar) {
        this(new HostConfigurationPersisterImpl(environment.getDomainConfigurationDir()), extensionRegistrar);
    }

    ModelManager(HostConfigurationPersister configPersister, StandardElementReaderRegistrar extensionRegistrar) {
        assert (configPersister != null) : "configPersister is null";
        assert (extensionRegistrar != null) : "extensionRegistrar is null";
        this.configPersister = configPersister;
        this.extensionRegistrar = extensionRegistrar;
    }

    public void start() {
        this.getHostModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostModel getHostModel() {
        if (this.hostModel == null) {
            HostConfigurationPersister hostConfigurationPersister = this.configPersister;
            synchronized (hostConfigurationPersister) {
                if (this.hostModel == null) {
                    this.hostModel = this.parseHostXml();
                }
            }
        }
        return this.hostModel;
    }

    public DomainModel getDomainModel() {
        return this.domainModel;
    }

    void setDomainModel(DomainModel model) {
        assert (model != null) : "model is null";
        this.domainModel = model;
    }

    void setFileRepository(FileRepository repository) {
        this.repository = repository;
    }

    public List<ServerIdentity> applyDomainModelUpdate(AbstractDomainModelUpdate<?> update, boolean applyToDomain) throws UpdateFailedException {
        log.debugf("Received update %s", (Object)update.getClass().getSimpleName());
        if (applyToDomain) {
            if (update instanceof NewRepositoryContentUpdate && this.repository != null) {
                this.repository.getDeploymentFiles(((NewRepositoryContentUpdate)update).getHash());
            }
            this.domainModel.update(update);
        }
        List serverNames = update.getAffectedServers(this.domainModel, this.getHostModel());
        log.debugf("Servers affected by %s: %s", (Object)update.getClass().getSimpleName(), (Object)serverNames);
        if (serverNames.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ServerIdentity> ids = new ArrayList<ServerIdentity>(serverNames.size());
        String hostName = this.hostModel.getName();
        for (String server : serverNames) {
            ServerElement se = this.hostModel.getServer(server);
            ids.add(new ServerIdentity(hostName, se.getServerGroup(), server));
        }
        return ids;
    }

    public List<HostUpdateApplierResponse> applyHostModelUpdates(List<AbstractHostModelUpdate<?>> updates) {
        ArrayList<HostUpdateApplierResponse> result = new ArrayList<HostUpdateApplierResponse>(updates.size());
        boolean ok = true;
        ArrayList<AbstractHostModelUpdate> rollbacks = new ArrayList<AbstractHostModelUpdate>();
        for (AbstractHostModelUpdate<?> update : updates) {
            if (ok) {
                try {
                    AbstractHostModelUpdate rollback = update.getCompensatingUpdate(this.hostModel);
                    this.hostModel.update(update);
                    rollbacks.add(0, rollback);
                    result.add(new HostUpdateApplierResponse(false));
                }
                catch (UpdateFailedException e) {
                    ok = false;
                    result.add(new HostUpdateApplierResponse(e));
                }
                continue;
            }
            result.add(new HostUpdateApplierResponse(true));
        }
        if (!ok) {
            for (int i = 0; i < rollbacks.size(); ++i) {
                AbstractHostModelUpdate rollback = (AbstractHostModelUpdate)rollbacks.get(i);
                try {
                    this.hostModel.update((AbstractModelUpdate)rollback);
                    continue;
                }
                catch (UpdateFailedException e) {
                    // empty catch block
                }
            }
        } else {
            this.configPersister.persistConfiguration(this.hostModel);
            result.clear();
            for (AbstractHostModelUpdate<?> update : updates) {
                result.add(new HostUpdateApplierResponse(this.getAffectedServers(update)));
            }
        }
        return result;
    }

    public List<ServerIdentity> applyHostModelUpdate(AbstractHostModelUpdate<?> update) throws UpdateFailedException {
        List<HostUpdateApplierResponse> rsps = this.applyHostModelUpdates(Collections.singletonList(update));
        HostUpdateApplierResponse rsp = rsps.get(0);
        if (rsp.getHostFailure() != null) {
            throw rsp.getHostFailure();
        }
        return rsp.getServers();
    }

    private List<ServerIdentity> getAffectedServers(AbstractHostModelUpdate<?> update) {
        List serverNames = update.getAffectedServers(this.hostModel);
        if (serverNames.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ServerIdentity> ids = new ArrayList<ServerIdentity>(serverNames.size());
        String hostName = this.hostModel.getName();
        for (String server : serverNames) {
            ServerElement se = this.hostModel.getServer(server);
            ids.add(new ServerIdentity(hostName, se.getServerGroup(), server));
        }
        return ids;
    }

    private HostModel parseHostXml() {
        try {
            ArrayList hostUpdates = new ArrayList();
            XMLMapper mapper = XMLMapper.Factory.create();
            this.extensionRegistrar.registerStandardHostReaders(mapper);
            mapper.parseDocument(hostUpdates, XMLInputFactory.newInstance().createXMLStreamReader(new BufferedInputStream(this.configPersister.getConfigurationInputStream())));
            HostModel hostModel = new HostModel();
            for (AbstractHostModelUpdate update : hostUpdates) {
                hostModel.update((AbstractModelUpdate)update);
            }
            return hostModel;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception during processing of host.xml", e);
        }
    }
}

