/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.model.DomainModel;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementException;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.as.server.manager.DomainControllerConnection;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

public class RemoteDomainControllerConnection
implements DomainControllerConnection {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.management");
    private final String serverManagerId;
    private final InetAddress dcAddress;
    private final int dcPort;
    private final long connectTimeout;
    private final InetAddress localManagementAddress;
    private final int localManagementPort;
    private final RemoteFileRepository remoteFileRepository;
    private final ScheduledExecutorService executorService;
    private final ThreadFactory threadFactory;

    public RemoteDomainControllerConnection(String serverManagerId, InetAddress dcAddress, int dcPort, InetAddress localManagementAddress, int localManagementPort, FileRepository localFileRepository, long connectTimeout, ScheduledExecutorService executorService, ThreadFactory threadFactory) {
        this.serverManagerId = serverManagerId;
        this.dcAddress = dcAddress;
        this.dcPort = dcPort;
        this.localManagementAddress = localManagementAddress;
        this.localManagementPort = localManagementPort;
        this.remoteFileRepository = new RemoteFileRepository(this, localFileRepository);
        this.connectTimeout = connectTimeout;
        this.executorService = executorService;
        this.threadFactory = threadFactory;
    }

    @Override
    public DomainModel register() {
        try {
            return (DomainModel)new RegisterOperation(this.localManagementAddress, this.localManagementPort, this).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to register with the domain controller", (Throwable)e);
        }
    }

    @Override
    public void unregister() {
        try {
            new UnregisterOperation(this).execute(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to register with the domain controller", (Throwable)e);
        }
    }

    @Override
    public FileRepository getRemoteFileRepository() {
        return this.remoteFileRepository;
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)ProtocolUtils.MODULAR_CONFIG);
    }

    private ManagementRequestConnectionStrategy getConnectionStrategy() {
        return new ManagementRequestConnectionStrategy.EstablishConnectingStrategy(this.dcAddress, this.dcPort, this.connectTimeout, (ExecutorService)this.executorService, this.threadFactory);
    }

    private static class RemoteFileRepository
    implements FileRepository {
        private final RemoteDomainControllerConnection connection;
        private final FileRepository localFileRepository;

        private RemoteFileRepository(RemoteDomainControllerConnection connection, FileRepository localFileRepository) {
            this.connection = connection;
            this.localFileRepository = localFileRepository;
        }

        public final File getFile(String relativePath) {
            return this.getFile(relativePath, (byte)25);
        }

        public final File getConfigurationFile(String relativePath) {
            return this.getFile(relativePath, (byte)32);
        }

        public final File[] getDeploymentFiles(byte[] deploymentHash) {
            String hex = DeploymentUnitElement.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)33).listFiles();
        }

        public File getDeploymentRoot(byte[] deploymentHash) {
            String hex = DeploymentUnitElement.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)33);
        }

        private File getFile(String relativePath, byte repoId) {
            try {
                return (File)new GetFileOperation(repoId, relativePath, this.localFileRepository, this.connection).executeForResult(this.connection.getConnectionStrategy());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get file from remote repository", e);
            }
        }
    }

    private static class GetFileOperation
    extends DomainControllerRequest<File> {
        private final byte rootId;
        private final String filePath;
        private final FileRepository localFileRepository;

        private GetFileOperation(byte rootId, String filePath, FileRepository localFileRepository, RemoteDomainControllerConnection connection) {
            super(connection);
            this.rootId = rootId;
            this.filePath = filePath;
            this.localFileRepository = localFileRepository;
        }

        public final byte getRequestCode() {
            return 23;
        }

        protected final byte getResponseCode() {
            return 39;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            super.sendRequest(protocolVersion, outputStream);
            log.debugf("Requesting files for path %s", (Object)this.filePath);
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(24);
                output.writeByte((int)this.rootId);
                output.writeByte(34);
                output.writeUTF(this.filePath);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected final File receiveResponse(InputStream inputStream) throws IOException {
            switch (this.rootId) {
                case 25: {
                    localPath = this.localFileRepository.getFile(this.filePath);
                    break;
                }
                case 32: {
                    localPath = this.localFileRepository.getConfigurationFile(this.filePath);
                    break;
                }
                case 33: {
                    hash = DeploymentUnitElement.hexStringToBytes((String)this.filePath);
                    localPath = this.localFileRepository.getDeploymentRoot(hash);
                    break;
                }
                default: {
                    localPath = null;
                }
            }
            input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)35);
                numFiles = input.readInt();
                RemoteDomainControllerConnection.access$600().debugf("Received %d files for %s", (Object)numFiles, (Object)localPath);
                switch (numFiles) {
                    case -1: {
                        ** break;
                    }
                    case 0: {
                        if (localPath.mkdirs()) ** break;
                        throw new IOException("Unable to create local directory: " + localPath);
                    }
                    default: {
                        for (i = 0; i < numFiles; ++i) {
                            ProtocolUtils.expectHeader((DataInput)input, (int)37);
                            ProtocolUtils.expectHeader((DataInput)input, (int)34);
                            path = input.readUTF();
                            ProtocolUtils.expectHeader((DataInput)input, (int)36);
                            length = input.readLong();
                            RemoteDomainControllerConnection.access$600().debugf("Received file [%s] of length %d", (Object)path, (Object)length);
                            file = new File(localPath, path);
                            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                                throw new IOException("Unable to create local directory " + localPath.getParent());
                            }
                            totalRead = 0L;
                            fileOut = null;
                            try {
                                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                                buffer = new byte[8192];
                                while (totalRead < length && (read = input.read(buffer, 0, Math.min((int)(length - totalRead), buffer.length))) != -1) {
                                    if (read <= 0) continue;
                                    fileOut.write(buffer, 0, read);
                                    totalRead += (long)read;
                                }
                            }
                            finally {
                                if (fileOut != null) {
                                    fileOut.close();
                                }
                            }
                            if (totalRead != length) {
                                throw new IOException("Did not read the entire file. Missing: " + (length - totalRead));
                            }
                            ProtocolUtils.expectHeader((DataInput)input, (int)38);
                        }
                    }
                }
            }
            catch (Throwable var16_14) {
                StreamUtils.safeClose(input);
                throw var16_14;
            }
lbl60:
            // 3 sources

            StreamUtils.safeClose((Closeable)input);
            return localPath;
        }
    }

    private static class UnregisterOperation
    extends DomainControllerRequest<Void> {
        private UnregisterOperation(RemoteDomainControllerConnection connection) {
            super(connection);
        }

        public final byte getRequestCode() {
            return 21;
        }

        protected final byte getResponseCode() {
            return 22;
        }

        protected Void receiveResponse(InputStream input) throws IOException {
            log.infof("Unregistered with remote domain controller", new Object[0]);
            return null;
        }
    }

    private static class RegisterOperation
    extends DomainControllerRequest<DomainModel> {
        private final InetAddress localManagementAddress;
        private final int localManagementPort;

        private RegisterOperation(InetAddress localManagementAddress, int localManagementPort, RemoteDomainControllerConnection connection) {
            super(connection);
            this.localManagementAddress = localManagementAddress;
            this.localManagementPort = localManagementPort;
        }

        public final byte getRequestCode() {
            return 18;
        }

        protected final byte getResponseCode() {
            return 20;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            super.sendRequest(protocolVersion, outputStream);
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(16);
                byte[] address = this.localManagementAddress.getAddress();
                output.writeInt(address.length);
                output.write(address);
                output.writeByte(17);
                output.writeInt(this.localManagementPort);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        protected final DomainModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = RemoteDomainControllerConnection.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)19);
            log.infof("Registered with remote domain controller", new Object[0]);
            DomainModel domainModel = (DomainModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, DomainModel.class);
            unmarshaller.finish();
            return domainModel;
        }
    }

    private static abstract class DomainControllerRequest<T>
    extends ManagementRequest<T> {
        protected final String serverManagerId;

        private DomainControllerRequest(RemoteDomainControllerConnection connection) {
            this.serverManagerId = connection.serverManagerId;
        }

        protected byte getHandlerId() {
            return 8;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(9);
            StreamUtils.writeUTFZBytes((OutputStream)output, (String)this.serverManagerId);
        }
    }
}

