/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.manager;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Properties;

public class ServerManagerEnvironment {
    public static final String HOME_DIR = "jboss.home.dir";
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    public static final String DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    public static final String DOMAIN_SYSTEM_DEPLOYMENT_DIR = "jboss.domain.system.deployment.dir";
    public static final String DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    public static final String DOMAIN_SERVERS_DIR = "jboss.domain.servers.dir";
    public static final String DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    private final Properties props;
    private final String processName;
    private final InetAddress processManagerAddress;
    private final Integer processManagerPort;
    private final InetAddress serverManagerAddress;
    private final Integer serverManagerPort;
    private final File homeDir;
    private final File modulesDir;
    private final File domainBaseDir;
    private final File domainConfigurationDir;
    private final File domainDeploymentDir;
    private final File domainSystemDeploymentDir;
    private final File domainDataDir;
    private final File domainLogDir;
    private final File domainServersDir;
    private final File domainTempDir;
    private final File defaultJVM;
    private final boolean isRestart;
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public ServerManagerEnvironment(Properties props, boolean isRestart, InputStream stdin, PrintStream stdout, PrintStream stderr, String processName, InetAddress processManagerAddress, Integer processManagerPort, InetAddress serverManagerAddress, Integer serverManagerPort, String defaultJVM) {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        this.props = props;
        if (stdin == null) {
            throw new IllegalArgumentException("stdin is null");
        }
        this.stdin = stdin;
        if (stdout == null) {
            throw new IllegalArgumentException("stdout is null");
        }
        this.stdout = stdout;
        if (stderr == null) {
            throw new IllegalArgumentException("stderr is null");
        }
        this.stderr = stderr;
        if (processName == null) {
            throw new IllegalArgumentException("processName is null");
        }
        if (processManagerAddress == null) {
            throw new IllegalArgumentException("processManagerAddress is null");
        }
        if (processManagerPort == null) {
            throw new IllegalArgumentException("processManagerPort is null");
        }
        if (serverManagerAddress == null) {
            throw new IllegalArgumentException("serverManagerAddress is null");
        }
        if (serverManagerPort == null) {
            throw new IllegalArgumentException("serverManagerPort is null");
        }
        this.processName = processName;
        this.processManagerPort = processManagerPort;
        this.processManagerAddress = processManagerAddress;
        this.serverManagerAddress = serverManagerAddress;
        this.serverManagerPort = serverManagerPort;
        this.isRestart = isRestart;
        File home = this.getFileFromProperty(HOME_DIR);
        if (home == null) {
            home = new File(System.getProperty("user.dir"));
        }
        this.homeDir = home;
        System.setProperty(HOME_DIR, this.homeDir.getAbsolutePath());
        File tmp = this.getFileFromProperty(MODULES_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        }
        this.modulesDir = tmp;
        System.setProperty(MODULES_DIR, this.modulesDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_BASE_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "domain");
        }
        this.domainBaseDir = tmp;
        System.setProperty(DOMAIN_BASE_DIR, this.domainBaseDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_CONFIG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "configuration");
        }
        this.domainConfigurationDir = tmp;
        System.setProperty(DOMAIN_CONFIG_DIR, this.domainConfigurationDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_DEPLOYMENT_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "content");
        }
        this.domainDeploymentDir = tmp;
        System.setProperty(DOMAIN_DEPLOYMENT_DIR, this.domainDeploymentDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_SYSTEM_DEPLOYMENT_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "system-content");
        }
        this.domainSystemDeploymentDir = tmp;
        System.setProperty(DOMAIN_DEPLOYMENT_DIR, this.domainDeploymentDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_DATA_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "data");
        }
        this.domainDataDir = tmp;
        System.setProperty(DOMAIN_DATA_DIR, this.domainDataDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_LOG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "log");
        }
        this.domainLogDir = tmp;
        System.setProperty(DOMAIN_LOG_DIR, this.domainLogDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_SERVERS_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "servers");
        }
        this.domainServersDir = tmp;
        System.setProperty(DOMAIN_SERVERS_DIR, this.domainServersDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_TEMP_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "tmp");
        }
        this.domainTempDir = tmp;
        System.setProperty(DOMAIN_TEMP_DIR, this.domainTempDir.getAbsolutePath());
        this.defaultJVM = defaultJVM != null ? new File(defaultJVM) : null;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public String getProcessName() {
        return this.processName;
    }

    public InetAddress getProcessManagerAddress() {
        return this.processManagerAddress;
    }

    public Integer getProcessManagerPort() {
        return this.processManagerPort;
    }

    public InetAddress getServerManagerAddress() {
        return this.serverManagerAddress;
    }

    public Integer getServerManagerPort() {
        return this.serverManagerPort;
    }

    public boolean isRestart() {
        return this.isRestart;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getDomainBaseDir() {
        return this.domainBaseDir;
    }

    public File getDomainConfigurationDir() {
        return this.domainConfigurationDir;
    }

    public File getDomainDeploymentDir() {
        return this.domainDeploymentDir;
    }

    public File getDomainSystemDeploymentDir() {
        return this.domainSystemDeploymentDir;
    }

    public File getDomainDataDir() {
        return this.domainDataDir;
    }

    public File getDomainLogDir() {
        return this.domainLogDir;
    }

    public File getDomainServersDir() {
        return this.domainServersDir;
    }

    public File getDomainTempDir() {
        return this.domainTempDir;
    }

    public File getDefaultJVM() {
        return this.defaultJVM;
    }

    private File getFileFromProperty(String name) {
        String value = this.props.getProperty(name, null);
        if (value != null) {
            File f = new File(value);
            return f;
        }
        return null;
    }
}

