/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.controller.descriptions.DeploymentDescription;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private final DeploymentRepository deploymentRepository;
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address, ModelNode state) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("runtime-name").set(state.get("runtime-name"));
        op.get("hash").set(state.get("hash"));
        op.get("enabled").set(state.get("enabled"));
        return op;
    }

    public DeploymentAddHandler(DeploymentRepository deploymentRepository) {
        this.deploymentRepository = deploymentRepository;
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        this.validator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getAddDeploymentOperation(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        byte[] hash;
        String runtimeName;
        String name;
        block10: {
            this.validator.validate(operation);
            ModelNode opAddr = operation.get("address");
            PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
            name = address.getLastElement().getValue();
            String string = runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
            if (operation.hasDefined("input-stream-index") && operation.hasDefined("hash")) {
                throw new OperationFailedException(new ModelNode().set("Can't pass in both an input-stream-index and a hash"));
            }
            if (operation.hasDefined("input-stream-index")) {
                InputStream in = this.getContents(context, operation);
                try {
                    try {
                        hash = this.deploymentRepository.addDeploymentContent(in);
                        break block10;
                    }
                    catch (IOException e) {
                        throw new OperationFailedException(new ModelNode().set(e.toString()));
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                }
            }
            if (operation.hasDefined("hash")) {
                hash = operation.get("hash").asBytes();
            } else {
                throw new OperationFailedException(new ModelNode().set("Neither an attachment nor a hash were passed in"));
            }
        }
        if (!this.deploymentRepository.hasDeploymentContent(hash)) {
            throw new OperationFailedException(new ModelNode().set(String.format("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash))));
        }
        ModelNode subModel = context.getSubModel();
        subModel.get("name").set(name);
        subModel.get("runtime-name").set(runtimeName);
        subModel.get("hash").set(hash);
        subModel.get("enabled").set(operation.has("enabled") && operation.get("enabled").asBoolean());
        resultHandler.handleResultComplete();
        return new BasicOperationResult(Util.getResourceRemoveOperation((ModelNode)operation.get("address")));
    }

    private InputStream getContents(OperationContext context, ModelNode operation) {
        int streamIndex = operation.get("input-stream-index").asInt();
        if (streamIndex > context.getInputStreams().size() - 1) {
            throw new IllegalArgumentException("Invalid input-stream-index=" + streamIndex + ", the maximum index is " + (context.getInputStreams().size() - 1));
        }
        InputStream in = (InputStream)context.getInputStreams().get(streamIndex);
        if (in == null) {
            throw new IllegalStateException("Null stream at index " + streamIndex);
        }
        return in;
    }
}

