/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.List;
import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;

public class ModuleDependencyProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ServiceModuleLoader deploymentModuleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        List<ResourceRoot> allResourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        for (ResourceRoot resourceRoot : allResourceRoots) {
            String[] dependencyDefs;
            String dependencyString;
            Manifest manifest = resourceRoot.getAttachment(Attachments.MANIFEST);
            if (manifest == null || (dependencyString = manifest.getMainAttributes().getValue("Dependencies")) == null) continue;
            for (String dependencyDef : dependencyDefs = dependencyString.split(",")) {
                String[] dependencyParts = dependencyDef.split(" ");
                int dependencyPartsLength = dependencyParts.length;
                if (dependencyPartsLength == 0) {
                    throw new RuntimeException("Invalid dependency: " + dependencyString);
                }
                ModuleIdentifier dependencyId = ModuleIdentifier.fromString((String)dependencyParts[0]);
                boolean export = this.parseOptionalExportParams(dependencyParts, "export");
                boolean optional = this.parseOptionalExportParams(dependencyParts, "optional");
                boolean services = this.parseOptionalExportParams(dependencyParts, "services");
                ServiceModuleLoader dependencyLoader = dependencyId.getName().startsWith("deployment.") ? deploymentModuleLoader : Module.getBootModuleLoader();
                ModuleDependency dependency = new ModuleDependency(dependencyLoader, dependencyId, optional, export, services);
                moduleSpecification.addDependency(dependency);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    private boolean parseOptionalExportParams(String[] parts, String expected) {
        String part;
        if (parts.length > 1 && expected.equals(part = parts[1])) {
            return true;
        }
        return parts.length > 2 && expected.equals(part = parts[2]);
    }
}

