/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.ModelControllerOperationHandler;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementHeaderMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.as.server.ServerController;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HostControllerServerClient
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "client"});
    private final InjectedValue<Connection> smConnection = new InjectedValue();
    private final InjectedValue<ServerController> controller = new InjectedValue();
    private final String serverName;
    private volatile ModelControllerOperationHandler modelControllerOperationHandler;
    private final MessageHandler initialMessageHandler = new ManagementHeaderMessageHandler(){

        protected MessageHandler getHandlerForId(byte handlerId) {
            return HostControllerServerClient.this.modelControllerOperationHandler;
        }
    };

    public HostControllerServerClient(String serverName) {
        this.serverName = serverName;
    }

    public void start(StartContext context) throws StartException {
        Connection smConnection = (Connection)this.smConnection.getValue();
        try {
            new ServerRegisterRequest().executeForResult((ManagementRequestConnectionStrategy)new ManagementRequestConnectionStrategy.ExistingConnectionStrategy(smConnection));
        }
        catch (Exception e) {
            throw new StartException("Failed to send registration message to host controller", (Throwable)e);
        }
        this.modelControllerOperationHandler = ModelControllerOperationHandler.Factory.create((ModelController)((ModelController)this.controller.getValue()), (MessageHandler)this.initialMessageHandler);
        smConnection.setMessageHandler(this.initialMessageHandler);
    }

    public void stop(StopContext context) {
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public Injector<Connection> getSmConnectionInjector() {
        return this.smConnection;
    }

    public Injector<ServerController> getServerControllerInjector() {
        return this.controller;
    }

    private class ServerRegisterRequest
    extends ManagementRequest<Void> {
        private ServerRegisterRequest() {
        }

        protected byte getHandlerId() {
            return 127;
        }

        protected byte getRequestCode() {
            return 0;
        }

        protected byte getResponseCode() {
            return 2;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(1);
            StreamUtils.writeUTFZBytes((OutputStream)output, (String)HostControllerServerClient.this.serverName);
        }
    }
}

