/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.server.services.path.AbsolutePathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class SpecifiedPathAddHandler
extends PathAddHandler {
    public static SpecifiedPathAddHandler INSTANCE = new SpecifiedPathAddHandler();

    private SpecifiedPathAddHandler() {
        super(true);
    }

    protected OperationResult installPath(final String name, final String path, final String relativeTo, OperationContext context, final ResultHandler resultHandler, ModelNode compensatingOp) {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget().subTarget();
                    target.addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler));
                    if (relativeTo == null) {
                        AbsolutePathService.addService(name, path, target);
                    } else {
                        RelativePathService.addService(name, path, relativeTo, target);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOp);
    }
}

