/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.InitialModuleLoaderFactory;
import org.jboss.as.server.Main;
import org.jboss.as.server.SecurityActions;
import org.jboss.as.server.ServerStartException;
import org.jboss.as.server.StandaloneServer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.threads.AsyncFuture;

public class EmbeddedServerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";

    private EmbeddedServerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandaloneServer create(File jbossHomeDir, final Properties systemProps, final Map<String, String> systemEnv, String ... systemPackages) throws Throwable {
        if (jbossHomeDir == null || !jbossHomeDir.isDirectory()) {
            throw new IllegalStateException("Invalid jboss.home.dir: " + jbossHomeDir);
        }
        if (systemProps.getProperty("jboss.home.dir") == null) {
            systemProps.setProperty("jboss.home.dir", jbossHomeDir.getAbsolutePath());
        }
        EmbeddedServerFactory.setupCleanDirectories(jbossHomeDir, systemProps);
        File modulesDir = new File(jbossHomeDir + "/modules");
        final ModuleLoader moduleLoader = InitialModuleLoaderFactory.getModuleLoader(modulesDir, systemPackages);
        ModuleIdentifier logModuleId = ModuleIdentifier.create((String)"org.jboss.logmanager");
        ModuleClassLoader logModuleClassLoader = moduleLoader.loadModule(logModuleId).getClassLoader();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)logModuleClassLoader);
            systemProps.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            if (LogManager.getLogManager().getClass() == LogManager.class) {
                System.err.println("WARNING: Failed to load the specified logmodule " + logModuleId);
            } else {
                Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
        }
        ModuleIdentifier serverModuleId = ModuleIdentifier.create((String)"org.jboss.as.server");
        Module serverModule = moduleLoader.loadModule(serverModuleId);
        final ModuleClassLoader serverModuleClassLoader = serverModule.getClassLoader();
        StandaloneServer standaloneServer = new StandaloneServer(){
            private Object serviceContainer;

            @Override
            public void start() throws ServerStartException {
                try {
                    Class serverMainClass = serverModuleClassLoader.loadClass(Main.class.getName());
                    Method determineEnvironmentMethod = serverMainClass.getMethod("determineEnvironment", String[].class, Properties.class, Map.class);
                    Object serverEnvironment = determineEnvironmentMethod.invoke(null, new String[0], systemProps, systemEnv);
                    Class bootstrapFactoryClass = serverModuleClassLoader.loadClass(Bootstrap.Factory.class.getName());
                    Method newInstanceMethod = bootstrapFactoryClass.getMethod("newInstance", new Class[0]);
                    Object bootstrap = newInstanceMethod.invoke(null, new Object[0]);
                    Class configurationClass = serverModuleClassLoader.loadClass(Bootstrap.Configuration.class.getName());
                    Constructor configurationCtor = configurationClass.getConstructor(new Class[0]);
                    Object configuration = configurationCtor.newInstance(new Object[0]);
                    Method setServerEnvironmentMethod = configurationClass.getMethod("setServerEnvironment", serverEnvironment.getClass());
                    setServerEnvironmentMethod.invoke(configuration, serverEnvironment);
                    Method setModuleLoaderMethod = configurationClass.getMethod("setModuleLoader", ModuleLoader.class);
                    setModuleLoaderMethod.invoke(configuration, moduleLoader);
                    Class bootstrapClass = serverModuleClassLoader.loadClass(Bootstrap.class.getName());
                    Method bootstrapStartMethod = bootstrapClass.getMethod("startup", configurationClass, List.class);
                    Object future = bootstrapStartMethod.invoke(bootstrap, configuration, Collections.emptyList());
                    Class asyncFutureClass = serverModuleClassLoader.loadClass(AsyncFuture.class.getName());
                    Method getMethod = asyncFutureClass.getMethod("get", new Class[0]);
                    this.serviceContainer = getMethod.invoke(future, new Object[0]);
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw new ServerStartException(ex);
                }
            }

            @Override
            public void stop() {
                if (this.serviceContainer != null) {
                    try {
                        Class serverContainerClass = serverModuleClassLoader.loadClass(ServiceContainer.class.getName());
                        Method shutdownMethod = serverContainerClass.getMethod("shutdown", new Class[0]);
                        shutdownMethod.invoke(this.serviceContainer, new Object[0]);
                        Method awaitTerminationMethod = serverContainerClass.getMethod("awaitTermination", new Class[0]);
                        awaitTerminationMethod.invoke(this.serviceContainer, new Object[0]);
                    }
                    catch (RuntimeException rte) {
                        throw rte;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        return standaloneServer;
    }

    public static void setupCleanDirectories(Properties props) {
        File jbossHomeDir = new File(props.getProperty("jboss.home.dir"));
        EmbeddedServerFactory.setupCleanDirectories(jbossHomeDir, props);
    }

    static void setupCleanDirectories(File jbossHomeDir, Properties props) {
        File tempRoot = EmbeddedServerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.config.dir", "configuration", true);
        File originalDataDir = EmbeddedServerFactory.getFileUnderAsRoot(jbossHomeDir, props, "jboss.server.data.dir", "data", false);
        File configDir = new File(tempRoot, "config");
        configDir.mkdir();
        File dataDir = new File(tempRoot, "data");
        dataDir.mkdir();
        EmbeddedServerFactory.copyDirectory(originalConfigDir, configDir);
        if (originalDataDir.exists()) {
            EmbeddedServerFactory.copyDirectory(originalDataDir, dataDir);
        }
        props.put("jboss.server.base.dir", tempRoot.getAbsolutePath());
        props.put("jboss.server.config.dir", configDir.getAbsolutePath());
        props.put("jboss.server.data.dir", dataDir.getAbsolutePath());
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty("jboss.server.base.dir", null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "standalone/" + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw new IllegalArgumentException("No directory called 'standalone/' " + relativeLocation + " under " + jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedServerFactory.validateDirectory("jboss.server.base.dir", server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedServerFactory.validateDirectory("jboss.server.config.dir", dir);
        return dir;
    }

    private static File getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        File root = new File(tempRoot);
        if (!root.exists()) {
            root.mkdirs();
        }
        EmbeddedServerFactory.validateDirectory("jboss.test.clean.root", root);
        root = new File(root, "configs");
        root.mkdir();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        root = new File(root, format.format(new Date()));
        root.mkdir();
        return root;
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("-D" + property + "=" + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("-D" + property + "=" + file.getAbsolutePath() + " is not a directory");
        }
    }

    private static void copyDirectory(File src, File dest) {
        for (String current : src.list()) {
            File srcFile = new File(src, current);
            File destFile = new File(dest, current);
            if (srcFile.isDirectory()) {
                destFile.mkdir();
                EmbeddedServerFactory.copyDirectory(srcFile, destFile);
                continue;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                try {
                    int i;
                    while ((i = ((InputStream)in).read()) != -1) {
                        ((OutputStream)out).write(i);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error copying " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath(), e);
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                    StreamUtils.safeClose((Closeable)out);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) throws Throwable {
        SecurityActions.setSystemProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        String jbossHomeKey = "jboss.home";
        String jbossHomeProp = System.getProperty(jbossHomeKey);
        if (jbossHomeProp == null) {
            throw new IllegalStateException("Cannot find system property: " + jbossHomeKey);
        }
        File jbossHomeDir = new File(jbossHomeProp);
        if (!jbossHomeDir.isDirectory()) {
            throw new IllegalStateException("Invalid jboss home directory: " + jbossHomeDir);
        }
        StandaloneServer server = EmbeddedServerFactory.create(jbossHomeDir, System.getProperties(), System.getenv(), new String[0]);
        server.start();
    }
}

