/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import org.jboss.as.server.SecurityActions;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

final class InitialModuleLoaderFactory {
    private InitialModuleLoaderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleLoader getModuleLoader(File modulePath, String ... systemPackages) {
        if (modulePath == null || !modulePath.isDirectory()) {
            throw new IllegalArgumentException("Invalid module path: " + modulePath);
        }
        String oldClassPath = SecurityActions.getSystemProperty("java.class.path");
        try {
            SecurityActions.clearSystemProperty("java.class.path");
            SecurityActions.setSystemProperty("module.path", modulePath.getAbsolutePath());
            StringBuffer packages = new StringBuffer("org.jboss.modules");
            if (systemPackages != null) {
                for (String packageName : systemPackages) {
                    packages.append("," + packageName);
                }
            }
            SecurityActions.setSystemProperty("jboss.modules.system.pkgs", packages.toString());
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            try {
                ModuleClassLoader classLoader = moduleLoader.loadModule(ModuleIdentifier.SYSTEM).getClassLoader();
                classLoader.loadClass(InitialModuleLoaderFactory.class.getName());
                throw new IllegalStateException("Cannot initialize module system. There was probably a previous usage.");
            }
            catch (ModuleLoadException e) {
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            ModuleLoader moduleLoader2 = moduleLoader;
            return moduleLoader2;
        }
        finally {
            SecurityActions.setSystemProperty("java.class.path", oldClassPath);
        }
    }

    private static String classToResource(Class<?> clazz) {
        String base = clazz.getName().replace('.', '/');
        return base + ".class";
    }
}

