/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.InputStream;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.jboss.as.controller.BasicModelController;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelProvider;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationControllerContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersisterProvider;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.ServerControllerModelUtil;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerOperationContext;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.DelegatingServiceRegistry;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

class ServerControllerImpl
extends BasicModelController
implements ServerController {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private final ExecutorService executorService;
    private final ServiceTarget serviceTarget;
    private final ServiceRegistry serviceRegistry;
    private final ServerEnvironment serverEnvironment;
    private final AtomicInteger stamp = new AtomicInteger(0);
    private final AtomicStampedReference<ServerController.State> state = new AtomicStampedReference<Object>(null, 0);
    private final ExtensibleConfigurationPersister extensibleConfigurationPersister;
    private final DeploymentRepository deploymentRepository;
    private final EnumMap<Phase, SortedSet<RegisteredProcessor>> deployers = new EnumMap(Phase.class);

    ServerControllerImpl(ServiceContainer container, ServiceTarget serviceTarget, ServerEnvironment serverEnvironment, ExtensibleConfigurationPersister configurationPersister, DeploymentRepository deploymentRepository, ExecutorService executorService) {
        super(ServerControllerModelUtil.createCoreModel(), (ConfigurationPersister)configurationPersister, ServerDescriptionProviders.ROOT_PROVIDER);
        this.serviceTarget = serviceTarget;
        this.extensibleConfigurationPersister = configurationPersister;
        this.serverEnvironment = serverEnvironment;
        this.deploymentRepository = deploymentRepository;
        this.serviceRegistry = new DelegatingServiceRegistry((ServiceRegistry)container);
        this.executorService = executorService;
    }

    void init() {
        this.state.set(ServerController.State.STARTING, this.stamp.incrementAndGet());
        this.registerInternalOperations();
        ServerControllerModelUtil.initOperations(this.getRegistry(), this.deploymentRepository, this.extensibleConfigurationPersister, this.serverEnvironment);
        this.deployers.clear();
        for (Phase phase : Phase.values()) {
            this.deployers.put(phase, new ConcurrentSkipListSet());
        }
    }

    EnumMap<Phase, SortedSet<RegisteredProcessor>> finishBoot() {
        this.state.set(ServerController.State.RUNNING, this.stamp.incrementAndGet());
        EnumMap<Phase, SortedSet<RegisteredProcessor>> copy = new EnumMap<Phase, SortedSet<RegisteredProcessor>>(Phase.class);
        for (Map.Entry<Phase, SortedSet<RegisteredProcessor>> entry : this.deployers.entrySet()) {
            copy.put((Phase)((Enum)entry.getKey()), new ConcurrentSkipListSet<RegisteredProcessor>(entry.getValue()));
        }
        return copy;
    }

    @Override
    public ServerEnvironment getServerEnvironment() {
        return this.serverEnvironment;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public ServerController.State getState() {
        return this.state.getReference();
    }

    protected OperationContext getOperationContext(ModelNode subModel, OperationHandler operationHandler, Operation operation, ModelProvider modelProvider) {
        if (operationHandler instanceof BootOperationHandler) {
            if (this.getState() == ServerController.State.STARTING) {
                return new BootContextImpl(subModel, this.getRegistry(), this.deployers, modelProvider, (OperationAttachments)operation);
            }
            this.state.set(ServerController.State.RESTART_REQUIRED, this.stamp.incrementAndGet());
            return super.getOperationContext(subModel, operationHandler, operation, modelProvider);
        }
        if (this.getState() != ServerController.State.RESTART_REQUIRED || !(operationHandler instanceof ModelUpdateOperationHandler)) {
            return new ServerOperationContextImpl(this, this.getRegistry(), subModel, modelProvider, (OperationAttachments)operation);
        }
        return super.getOperationContext(subModel, operationHandler, operation, modelProvider);
    }

    protected OperationResult doExecute(OperationContext context, Operation operation, OperationHandler operationHandler, ResultHandler resultHandler, PathAddress address, OperationControllerContext operationControllerContext) throws OperationFailedException {
        boolean rollback = this.isRollbackOnRuntimeFailure(context, operation.getOperation());
        RollbackAwareResultHandler rollbackAwareHandler = null;
        if (rollback) {
            rollbackAwareHandler = new RollbackAwareResultHandler(resultHandler);
            resultHandler = rollbackAwareHandler;
        }
        OperationResult result = super.doExecute(context, operation, operationHandler, resultHandler, address, operationControllerContext);
        if (context instanceof ServerOperationContextImpl) {
            ServerOperationContextImpl serverOperationContext;
            if (rollbackAwareHandler != null) {
                rollbackAwareHandler.setRollbackOperation(result.getCompensatingOperation());
            }
            if ((serverOperationContext = (ServerOperationContextImpl)ServerOperationContextImpl.class.cast(context)).getRuntimeTask() != null) {
                try {
                    serverOperationContext.getRuntimeTask().execute(new RuntimeTaskContext(){

                        public ServiceTarget getServiceTarget() {
                            return ServerControllerImpl.this.serviceTarget;
                        }

                        public ServiceRegistry getServiceRegistry() {
                            return ServerControllerImpl.this.serviceRegistry;
                        }
                    });
                }
                catch (OperationFailedException e) {
                    resultHandler.handleFailed(e.getFailureDescription());
                }
                catch (Exception e) {
                    resultHandler.handleFailed(new ModelNode().set(e.toString()));
                }
            }
        }
        return result;
    }

    protected void persistConfiguration(ModelNode model, ConfigurationPersisterProvider configurationPersisterFactory) {
        if (this.getState() != ServerController.State.STARTING) {
            super.persistConfiguration(model, configurationPersisterFactory);
        }
    }

    protected BasicModelController.MultiStepOperationController getMultiStepOperationController(Operation operation, ResultHandler handler, OperationControllerContext operationControllerContext) throws OperationFailedException {
        return new ServerMultiStepOperationController(operation, handler, operationControllerContext);
    }

    private boolean isRollbackOnRuntimeFailure(OperationContext context, ModelNode operation) {
        return context instanceof ServerOperationContextImpl && (!operation.hasDefined("rollback-on-runtime-failure") || operation.get("rollback-on-runtime-failure").asBoolean());
    }

    private class ServerMultiStepOperationController
    extends BasicModelController.MultiStepOperationController {
        private ServerMultiStepOperationController(Operation operation, ResultHandler resultHandler, OperationControllerContext injectedOperationControllerContext) throws OperationFailedException {
            super((BasicModelController)ServerControllerImpl.this, operation, resultHandler, injectedOperationControllerContext);
        }

        public OperationContext getOperationContext(ModelProvider modelSource, PathAddress address, OperationHandler operationHandler, Operation operation) {
            OperationContext delegate = super.getOperationContext(modelSource, address, operationHandler, operation);
            return delegate.getRuntimeContext() == null ? delegate : new StepRuntimeOperationContext(this.currentOperation, (ServerOperationContext)ServerOperationContext.class.cast(delegate), (OperationAttachments)operation);
        }

        protected void handleFailures() {
            if (!this.modelComplete.get()) {
                super.handleFailures();
            } else if (this.rollbackOnRuntimeFailure) {
                final ModelNode compensatingOp = this.getOverallCompensatingOperation();
                if (compensatingOp.isDefined()) {
                    final RollbackResultHandler rollbackResultHandler = new RollbackResultHandler();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ServerControllerImpl.this.execute(OperationBuilder.Factory.create((ModelNode)compensatingOp).build(), rollbackResultHandler);
                        }
                    };
                    ServerControllerImpl.this.executorService.execute(r);
                } else {
                    super.handleFailures();
                }
            } else if (this.resultHandler instanceof BasicModelController.StepResultHandler) {
                this.resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, this.resultsNode);
                ModelNode failureMsg = new ModelNode();
                String baseMsg = "Composite operation failed. Steps that failed:";
                for (Property property : this.resultsNode.asPropertyList()) {
                    ModelNode stepResult = property.getValue();
                    if (!stepResult.hasDefined("failure-description")) continue;
                    failureMsg.get(new String[]{"Composite operation failed. Steps that failed:", "Operation " + property.getName()}).set(stepResult.get("failure-description"));
                }
                this.resultHandler.handleFailed(failureMsg);
            } else {
                this.resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, this.resultsNode);
                this.resultHandler.handleResultComplete();
            }
        }

        protected void recordModelComplete() {
            super.recordModelComplete();
            if (this.runtimeTasks.size() > 0) {
                RuntimeTaskContext rtc = new RuntimeTaskContext(){

                    public ServiceTarget getServiceTarget() {
                        return ServerControllerImpl.this.serviceTarget;
                    }

                    public ServiceRegistry getServiceRegistry() {
                        return ServerControllerImpl.this.serviceRegistry;
                    }
                };
                for (int i = 0; i < this.steps.size(); ++i) {
                    Integer id = i;
                    RuntimeTask runtimeTask = (RuntimeTask)this.runtimeTasks.get(id);
                    if (runtimeTask == null) continue;
                    try {
                        runtimeTask.execute(rtc);
                        continue;
                    }
                    catch (OperationFailedException e) {
                        ((ResultHandler)this.stepResultHandlers.get(id)).handleFailed(e.getFailureDescription());
                        continue;
                    }
                    catch (Throwable t) {
                        ((ResultHandler)this.stepResultHandlers.get(id)).handleFailed(new ModelNode().set(t.toString()));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rollbackComplete(ModelNode rollbackResult) {
            ModelNode modelNode = this.resultsNode;
            synchronized (modelNode) {
                for (int i = 0; i < this.steps.size(); ++i) {
                    String stepKey = this.getStepKey(i);
                    ModelNode stepResult = this.resultsNode.get(stepKey);
                    if (!stepResult.hasDefined("outcome") || "cancelled".equals(stepResult.get("outcome").asString())) continue;
                    ModelNode rollbackStepOutcome = null;
                    ModelNode rollbackStepResult = null;
                    String rollbackKey = (String)this.rollbackStepNames.get(i);
                    if (rollbackKey != null) {
                        rollbackStepResult = rollbackResult.get(rollbackKey);
                        ModelNode modelNode2 = rollbackStepOutcome = rollbackStepResult.isDefined() ? rollbackStepResult.get("outcome") : null;
                    }
                    if (rollbackStepOutcome == null || !rollbackStepOutcome.isDefined()) {
                        stepResult.get("rolled-back").set(false);
                        stepResult.get("rollback-failure-description").set(new ModelNode().set("No compensating operations was available"));
                        continue;
                    }
                    if ("cancelled".equals(rollbackStepOutcome.asString())) {
                        stepResult.get("rolled-back").set(false);
                        stepResult.get("rollback-failure-description").set(new ModelNode().set("Execution of the compensating operation was cancelled"));
                        continue;
                    }
                    if ("success".equals(rollbackStepOutcome.asString())) {
                        stepResult.get("rolled-back").set(true);
                        continue;
                    }
                    stepResult.get("rolled-back").set(false);
                    ModelNode rollbackFailureCause = rollbackStepResult.get("failure-description");
                    if (!rollbackFailureCause.isDefined()) {
                        rollbackFailureCause = new ModelNode().set("Compensating operation was reverted due to failure of other compensating operations");
                    }
                    stepResult.get("rollback-failure-description").set(rollbackFailureCause);
                }
            }
            super.handleFailures();
        }

        private class RollbackResultHandler
        implements ResultHandler {
            private final ModelNode rollbackResult = new ModelNode();

            private RollbackResultHandler() {
            }

            public void handleResultFragment(String[] location, ModelNode result) {
                this.rollbackResult.get(location).set(result);
            }

            public void handleResultComplete() {
                ServerMultiStepOperationController.this.rollbackComplete(this.rollbackResult);
            }

            public void handleFailed(ModelNode failureDescription) {
                ServerMultiStepOperationController.this.rollbackComplete(this.rollbackResult);
            }

            public void handleCancellation() {
                ServerMultiStepOperationController.this.rollbackComplete(this.rollbackResult);
            }
        }

        private class StepRuntimeOperationContext
        implements ServerOperationContext,
        RuntimeOperationContext {
            private final Integer id;
            private final ServerOperationContext delegate;
            private final OperationAttachments executionAttachments;

            private StepRuntimeOperationContext(Integer id, ServerOperationContext delegate, OperationAttachments executionAttachments) {
                this.id = id;
                this.delegate = delegate;
                this.executionAttachments = executionAttachments;
            }

            public ModelNode getSubModel() throws IllegalArgumentException {
                return this.delegate.getSubModel();
            }

            public ModelNode getSubModel(PathAddress address) throws IllegalArgumentException {
                return this.delegate.getSubModel(address);
            }

            public ModelNodeRegistration getRegistry() {
                return this.delegate.getRegistry();
            }

            @Override
            public ServerController getController() {
                return this.delegate.getController();
            }

            @Override
            public void restartRequired() {
                this.delegate.restartRequired();
            }

            @Override
            public void revertRestartRequired() {
                this.delegate.revertRestartRequired();
            }

            public RuntimeOperationContext getRuntimeContext() {
                return this;
            }

            public void setRuntimeTask(RuntimeTask runtimeTask) {
                ServerMultiStepOperationController.this.runtimeTasks.put(this.id, runtimeTask);
            }

            public List<InputStream> getInputStreams() {
                return this.executionAttachments.getInputStreams();
            }
        }
    }

    class RollbackAwareResultHandler
    implements ResultHandler {
        private final ResultHandler delegate;
        private ModelNode rollbackOperation;

        public RollbackAwareResultHandler(ResultHandler resultHandler) {
            this.delegate = resultHandler;
        }

        public void handleResultFragment(String[] location, ModelNode result) {
            this.delegate.handleResultFragment(location, result);
        }

        public void handleResultComplete() {
            this.delegate.handleResultComplete();
        }

        public void handleFailed(final ModelNode failureDescription) {
            if (this.rollbackOperation == null || !this.rollbackOperation.isDefined()) {
                this.delegate.handleFailed(failureDescription);
                return;
            }
            final ResultHandler rollbackHandler = new ResultHandler(){

                public void handleResultFragment(String[] location, ModelNode result) {
                }

                public void handleResultComplete() {
                    RollbackAwareResultHandler.this.delegate.handleFailed(failureDescription);
                }

                public void handleFailed(ModelNode rollbackFailureDescription) {
                    ModelNode rollbackResult = new ModelNode();
                    rollbackResult = new ModelNode();
                    rollbackResult.get("rollback-failure-description").set(rollbackFailureDescription);
                    RollbackAwareResultHandler.this.delegate.handleFailed(failureDescription);
                }

                public void handleCancellation() {
                    this.handleFailed(new ModelNode().set("Rollback was cancelled"));
                }
            };
            this.rollbackOperation.get("rollback-on-runtime-failure").set(false);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ServerControllerImpl.this.execute(OperationBuilder.Factory.create((ModelNode)RollbackAwareResultHandler.this.rollbackOperation).build(), rollbackHandler);
                }
            };
            ServerControllerImpl.this.executorService.execute(r);
        }

        public void handleCancellation() {
            this.delegate.handleCancellation();
        }

        private void setRollbackOperation(ModelNode compensatingOperation) {
            this.rollbackOperation = compensatingOperation;
        }
    }

    static final class RegisteredProcessor
    implements Comparable<RegisteredProcessor> {
        private final int priority;
        private final DeploymentUnitProcessor processor;

        RegisteredProcessor(int priority, DeploymentUnitProcessor processor) {
            this.priority = priority;
            this.processor = processor;
        }

        @Override
        public int compareTo(RegisteredProcessor o) {
            int rel = Integer.signum(this.priority - o.priority);
            return rel == 0 ? this.processor.getClass().getName().compareTo(o.getClass().getName()) : rel;
        }

        int getPriority() {
            return this.priority;
        }

        DeploymentUnitProcessor getProcessor() {
            return this.processor;
        }
    }

    private class BootContextImpl
    extends ServerOperationContextImpl
    implements BootOperationContext {
        private final EnumMap<Phase, SortedSet<RegisteredProcessor>> deployers;

        private BootContextImpl(ModelNode subModel, ModelNodeRegistration registry, EnumMap<Phase, SortedSet<RegisteredProcessor>> deployers, ModelProvider modelProvider, OperationAttachments executionAttachments) {
            super(ServerControllerImpl.this, registry, subModel, modelProvider, executionAttachments);
            this.deployers = deployers;
        }

        @Override
        public void addDeploymentProcessor(Phase phase, int priority, DeploymentUnitProcessor processor) {
            if (phase == null) {
                throw new IllegalArgumentException("phase is null");
            }
            if (processor == null) {
                throw new IllegalArgumentException("processor is null");
            }
            if (priority < 0) {
                throw new IllegalArgumentException("priority is invalid (must be >= 0)");
            }
            this.deployers.get((Object)phase).add(new RegisteredProcessor(priority, processor));
        }
    }

    private class ServerOperationContextImpl
    extends OperationContextImpl
    implements ServerOperationContext,
    RuntimeOperationContext {
        private int ourStamp;
        private RuntimeTask runtimeTask;

        public ServerOperationContextImpl(ModelController controller, ModelNodeRegistration registry, ModelNode subModel, ModelProvider modelProvider, OperationAttachments executionAttachments) {
            super(controller, registry, subModel, modelProvider, executionAttachments);
            this.ourStamp = -1;
        }

        @Override
        public ServerController getController() {
            return (ServerController)super.getController();
        }

        @Override
        public synchronized void restartRequired() {
            ServerController.State was;
            AtomicStampedReference stateRef = ServerControllerImpl.this.state;
            int newStamp = ServerControllerImpl.this.stamp.incrementAndGet();
            int[] receiver = new int[1];
            while ((was = (ServerController.State)((Object)stateRef.get(receiver))) != ServerController.State.STARTING) {
                if (!stateRef.compareAndSet(was, ServerController.State.RESTART_REQUIRED, receiver[0], newStamp)) continue;
                this.ourStamp = newStamp;
                break;
            }
        }

        @Override
        public synchronized void revertRestartRequired() {
            ServerControllerImpl.this.state.compareAndSet(ServerController.State.RESTART_REQUIRED, ServerController.State.RUNNING, this.ourStamp, ServerControllerImpl.this.stamp.incrementAndGet());
        }

        public RuntimeOperationContext getRuntimeContext() {
            return this;
        }

        public RuntimeTask getRuntimeTask() {
            return this.runtimeTask;
        }

        public void setRuntimeTask(RuntimeTask runtimeTask) {
            this.runtimeTask = runtimeTask;
        }
    }
}

