/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ExtensionContextImpl;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.deployment.DeploymentAddHandler;
import org.jboss.as.server.deployment.DeploymentDeployHandler;
import org.jboss.as.server.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.server.deployment.DeploymentRedeployHandler;
import org.jboss.as.server.deployment.DeploymentRemoveHandler;
import org.jboss.as.server.deployment.DeploymentReplaceHandler;
import org.jboss.as.server.deployment.DeploymentUndeployHandler;
import org.jboss.as.server.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.server.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.server.deployment.DeploymentUploadURLHandler;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.as.server.operations.ExtensionAddHandler;
import org.jboss.as.server.operations.ExtensionRemoveHandler;
import org.jboss.as.server.operations.HttpManagementAddHandler;
import org.jboss.as.server.operations.NativeManagementAddHandler;
import org.jboss.as.server.operations.ServerOperationHandlers;
import org.jboss.as.server.operations.ServerReloadHandler;
import org.jboss.as.server.operations.ServerShutdownHandler;
import org.jboss.as.server.operations.SpecifiedPathAddHandler;
import org.jboss.as.server.operations.SpecifiedPathRemoveHandler;
import org.jboss.as.server.operations.SystemPropertyAddHandler;
import org.jboss.as.server.operations.SystemPropertyRemoveHandler;
import org.jboss.as.server.operations.sockets.BindingAddHandler;
import org.jboss.as.server.operations.sockets.BindingFixedPortHandler;
import org.jboss.as.server.operations.sockets.BindingGroupAddHandler;
import org.jboss.as.server.operations.sockets.BindingGroupDefaultInterfaceHandler;
import org.jboss.as.server.operations.sockets.BindingGroupPortOffsetHandler;
import org.jboss.as.server.operations.sockets.BindingGroupRemoveHandler;
import org.jboss.as.server.operations.sockets.BindingInterfaceHandler;
import org.jboss.as.server.operations.sockets.BindingMulticastAddressHandler;
import org.jboss.as.server.operations.sockets.BindingPortHandler;
import org.jboss.as.server.operations.sockets.BindingRemoveHandler;
import org.jboss.as.server.operations.sockets.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.operations.sockets.SpecifiedInterfaceRemoveHandler;
import org.jboss.dmr.ModelNode;

public class ServerControllerModelUtil {
    public static ModelNode createCoreModel() {
        ModelNode root = new ModelNode();
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
        root.get("name");
        root.get("management-interfaces");
        root.get("profile-name");
        root.get("system-properties");
        root.get("extension");
        root.get("path");
        root.get("subsystem");
        root.get("interface");
        root.get("socket-binding-group");
        root.get("deployment");
        return root;
    }

    public static void initOperations(ModelNodeRegistration root, DeploymentRepository deploymentRepository, ExtensibleConfigurationPersister extensibleConfigurationPersister, ServerEnvironment serverEnvironment) {
        root.registerReadWriteAttribute("name", null, (OperationHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        root.registerOperationHandler("resolve-address", (OperationHandler)GlobalOperationHandlers.RESOLVE, (DescriptionProvider)GlobalOperationHandlers.RESOLVE, false, OperationEntry.EntryType.PRIVATE);
        root.registerOperationHandler("read-resource", ServerOperationHandlers.SERVER_READ_RESOURCE_HANDLER, CommonProviders.READ_RESOURCE_PROVIDER, true);
        root.registerOperationHandler("read-attribute", ServerOperationHandlers.SERVER_READ_ATTRIBUTE_HANDLER, CommonProviders.READ_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("read-resource-description", (OperationHandler)GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true);
        root.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-children-types", (OperationHandler)GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true);
        root.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true);
        root.registerOperationHandler("read-operation-names", (OperationHandler)GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true);
        root.registerOperationHandler("read-operation-description", (OperationHandler)GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true);
        root.registerOperationHandler("write-attribute", ServerOperationHandlers.SERVER_WRITE_ATTRIBUTE_HANDLER, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("add-namespace", (OperationHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-namespace", (OperationHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-schema-location", (OperationHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-schema-location", (OperationHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-system-property", (OperationHandler)SystemPropertyAddHandler.INSTANCE, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-system-property", (OperationHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        DeploymentUploadBytesHandler dubh = new DeploymentUploadBytesHandler(deploymentRepository);
        root.registerOperationHandler("upload-deployment-bytes", (OperationHandler)dubh, (DescriptionProvider)dubh, false);
        DeploymentUploadURLHandler duuh = new DeploymentUploadURLHandler(deploymentRepository);
        root.registerOperationHandler("upload-deployment-url", (OperationHandler)duuh, (DescriptionProvider)duuh, false);
        DeploymentUploadStreamAttachmentHandler dush = new DeploymentUploadStreamAttachmentHandler(deploymentRepository);
        root.registerOperationHandler("upload-deployment-stream", (OperationHandler)dush, (DescriptionProvider)dush, false);
        root.registerOperationHandler("replace-deployment", (OperationHandler)DeploymentReplaceHandler.INSTANCE, (DescriptionProvider)DeploymentReplaceHandler.INSTANCE, false);
        DeploymentFullReplaceHandler dfrh = new DeploymentFullReplaceHandler(deploymentRepository);
        root.registerOperationHandler("full-replace-deployment", (OperationHandler)dfrh, (DescriptionProvider)dfrh, false);
        root.registerOperationHandler("reload", (OperationHandler)ServerReloadHandler.INSTANCE, (DescriptionProvider)ServerReloadHandler.INSTANCE, false);
        if (serverEnvironment != null && serverEnvironment.isStandalone()) {
            root.registerOperationHandler("shutdown", (OperationHandler)ServerShutdownHandler.INSTANCE, (DescriptionProvider)ServerShutdownHandler.INSTANCE, false);
        }
        ModelNodeRegistration managementNative = root.registerSubModel(PathElement.pathElement((String)"management-interfaces", (String)"native-interface"), CommonProviders.MANAGEMENT_PROVIDER);
        managementNative.registerOperationHandler("add", (OperationHandler)NativeManagementAddHandler.INSTANCE, (DescriptionProvider)NativeManagementAddHandler.INSTANCE, false);
        ModelNodeRegistration managementHttp = root.registerSubModel(PathElement.pathElement((String)"management-interfaces", (String)"http-interface"), CommonProviders.MANAGEMENT_PROVIDER);
        managementHttp.registerOperationHandler("add", (OperationHandler)HttpManagementAddHandler.INSTANCE, (DescriptionProvider)HttpManagementAddHandler.INSTANCE, false);
        ModelNodeRegistration paths = root.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_PATH_PROVIDER);
        paths.registerOperationHandler("add", (OperationHandler)SpecifiedPathAddHandler.INSTANCE, (DescriptionProvider)SpecifiedPathAddHandler.INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationHandler)SpecifiedPathRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedPathRemoveHandler.INSTANCE, false);
        ModelNodeRegistration interfaces = root.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        ModelNodeRegistration socketGroup = root.registerSubModel(PathElement.pathElement((String)"socket-binding-group"), ServerDescriptionProviders.SOCKET_BINDING_GROUP_PROVIDER);
        socketGroup.registerOperationHandler("add", (OperationHandler)BindingGroupAddHandler.INSTANCE, (DescriptionProvider)BindingGroupAddHandler.INSTANCE, false);
        socketGroup.registerOperationHandler("remove", (OperationHandler)BindingGroupRemoveHandler.INSTANCE, (DescriptionProvider)BindingGroupRemoveHandler.INSTANCE, false);
        socketGroup.registerReadWriteAttribute("port-offset", null, (OperationHandler)BindingGroupPortOffsetHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketGroup.registerReadWriteAttribute("default-interface", null, (OperationHandler)BindingGroupDefaultInterfaceHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ModelNodeRegistration socketBinding = socketGroup.registerSubModel(PathElement.pathElement((String)"socket-binding"), CommonProviders.SOCKET_BINDING_PROVIDER);
        socketBinding.registerOperationHandler("add", (OperationHandler)BindingAddHandler.INSTANCE, (DescriptionProvider)BindingAddHandler.INSTANCE, false);
        socketBinding.registerOperationHandler("remove", (OperationHandler)BindingRemoveHandler.INSTANCE, (DescriptionProvider)BindingRemoveHandler.INSTANCE, false);
        socketBinding.registerReadWriteAttribute("interface", null, (OperationHandler)BindingInterfaceHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("port", null, (OperationHandler)BindingPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("fixed-port", null, (OperationHandler)BindingFixedPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("multicast-address", null, (OperationHandler)BindingMulticastAddressHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        socketBinding.registerReadWriteAttribute("multicast-port", null, (OperationHandler)BindingPortHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ModelNodeRegistration deployments = root.registerSubModel(PathElement.pathElement((String)"deployment"), ServerDescriptionProviders.DEPLOYMENT_PROVIDER);
        DeploymentAddHandler dah = new DeploymentAddHandler(deploymentRepository);
        deployments.registerOperationHandler("add", (OperationHandler)dah, (DescriptionProvider)dah, false);
        deployments.registerOperationHandler("remove", (OperationHandler)DeploymentRemoveHandler.INSTANCE, (DescriptionProvider)DeploymentRemoveHandler.INSTANCE, false);
        deployments.registerOperationHandler("deploy", (OperationHandler)DeploymentDeployHandler.INSTANCE, (DescriptionProvider)DeploymentDeployHandler.INSTANCE, false);
        deployments.registerOperationHandler("undeploy", (OperationHandler)DeploymentUndeployHandler.INSTANCE, (DescriptionProvider)DeploymentUndeployHandler.INSTANCE, false);
        deployments.registerOperationHandler("redeploy", (OperationHandler)DeploymentRedeployHandler.INSTANCE, (DescriptionProvider)DeploymentRedeployHandler.INSTANCE, false);
        ModelNodeRegistration extensions = root.registerSubModel(PathElement.pathElement((String)"extension"), CommonProviders.EXTENSION_PROVIDER);
        ExtensionContextImpl extensionContext = new ExtensionContextImpl(root, deployments, (SubsystemXmlWriterRegistry)extensibleConfigurationPersister);
        ExtensionAddHandler addExtensionHandler = new ExtensionAddHandler((ExtensionContext)extensionContext);
        extensions.registerOperationHandler("add", (OperationHandler)addExtensionHandler, (DescriptionProvider)addExtensionHandler, false);
        extensions.registerOperationHandler("remove", (OperationHandler)ExtensionRemoveHandler.INSTANCE, (DescriptionProvider)ExtensionRemoveHandler.INSTANCE, false);
    }
}

