/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.dmr.ModelNode;

public class DeploymentReplaceHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "replace-deployment";
    public static final DeploymentReplaceHandler INSTANCE = new DeploymentReplaceHandler();
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    private DeploymentReplaceHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("to-replace", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getDeployDeploymentOperation((Locale)locale);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode replaceNode;
        this.validator.validate(operation);
        ModelNode deployments = context.getSubModel().get("deployment");
        String name = operation.require("name").asString();
        String toReplace = operation.require("to-replace").asString();
        if (name.equals(toReplace)) {
            throw DeploymentReplaceHandler.operationFailed(String.format("Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.", OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment"));
        }
        ModelNode deployNode = deployments.hasDefined(name) ? deployments.get(name) : null;
        ModelNode modelNode = replaceNode = deployments.hasDefined(toReplace) ? deployments.get(toReplace) : null;
        if (deployNode == null) {
            throw DeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", name));
        }
        if (deployNode.get("enabled").asBoolean()) {
            throw DeploymentReplaceHandler.operationFailed(String.format("Deployment %s is already started", toReplace));
        }
        if (replaceNode == null) {
            throw DeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", toReplace));
        }
        deployNode.get("enabled").set(true);
        replaceNode.get("enabled").set(false);
        ModelNode compensatingOp = operation.clone();
        compensatingOp.get("name").set(toReplace);
        compensatingOp.get("to-replace").set(name);
        DeploymentHandlerUtil.replace(deployNode, toReplace, context, resultHandler);
        return new BasicOperationResult();
    }

    private static OperationFailedException operationFailed(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }
}

