/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class DeploymentRootMountProcessor
implements DeploymentUnitProcessor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        MountHandle mountHandle;
        VirtualFile deploymentRoot;
        DeploymentUnit deploymentUnit;
        block7: {
            deploymentUnit = phaseContext.getDeploymentUnit();
            if (deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT) != null) {
                return;
            }
            ServerDeploymentRepository serverDeploymentRepository = deploymentUnit.getAttachment(Attachments.SERVER_DEPLOYMENT_REPOSITORY);
            if (serverDeploymentRepository == null) {
                throw new DeploymentUnitProcessingException("No deployment repository available.");
            }
            String deploymentName = deploymentUnit.getName();
            String deploymentRuntimeName = deploymentUnit.getAttachment(Attachments.RUNTIME_NAME);
            byte[] deploymentHash = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_HASH);
            deploymentRoot = VFS.getChild((String)("content/" + deploymentRuntimeName));
            boolean failed = false;
            Closeable handle = null;
            try {
                boolean mountExploded = deploymentName.endsWith("war");
                handle = serverDeploymentRepository.mountDeploymentContent(deploymentName, deploymentRuntimeName, deploymentHash, deploymentRoot, mountExploded);
                mountHandle = new MountHandle(handle);
                if (!failed) break block7;
            }
            catch (IOException e) {
                try {
                    failed = true;
                    throw new DeploymentUnitProcessingException("Failed to mount deployment content", e);
                }
                catch (Throwable throwable) {
                    if (failed) {
                        VFSUtils.safeClose(handle);
                    }
                    throw throwable;
                }
            }
            VFSUtils.safeClose((Closeable)handle);
        }
        ResourceRoot resourceRoot = new ResourceRoot(deploymentRoot, mountHandle);
        ModuleRootMarker.mark(resourceRoot);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, resourceRoot);
        deploymentUnit.putAttachment(Attachments.MODULE_SPECIFICATION, new ModuleSpecification());
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        ResourceRoot resourceRoot = context.removeAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot != null) {
            MountHandle mountHandle = resourceRoot.getMountHandle();
            VFSUtils.safeClose((Closeable)mountHandle);
        }
    }
}

