/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.jboss.as.server.services.net.ManagedBinding;
import org.jboss.as.server.services.net.ManagedDatagramSocketBinding;
import org.jboss.as.server.services.net.ManagedMulticastSocketBinding;
import org.jboss.as.server.services.net.ManagedServerSocketBinding;
import org.jboss.as.server.services.net.ManagedSocketBinding;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.SocketBindingManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SocketBindingManagerService
implements SocketBindingManager,
Service<SocketBindingManager> {
    private final InjectedValue<NetworkInterfaceBinding> defaultInterfaceBinding = new InjectedValue();
    private final int portOffSet;
    private final SocketFactory socketFactory = new ManagedSocketFactory();
    private final ServerSocketFactory serverSocketFactory = new ManagedServerSocketFactory();
    private final Map<InetSocketAddress, ManagedBinding> managedBindings = new ConcurrentHashMap<InetSocketAddress, ManagedBinding>();

    public SocketBindingManagerService(int portOffSet) {
        this.portOffSet = portOffSet;
    }

    public InjectedValue<NetworkInterfaceBinding> getDefaultInterfaceBinding() {
        return this.defaultInterfaceBinding;
    }

    @Override
    public InetAddress getDefaultInterfaceAddress() {
        return ((NetworkInterfaceBinding)this.defaultInterfaceBinding.getValue()).getAddress();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public SocketBindingManager getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public int getPortOffset() {
        return this.portOffSet;
    }

    @Override
    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public DatagramSocket createDatagramSocket(SocketAddress address) throws SocketException {
        return new ManagedDatagramSocketBinding(this, address);
    }

    @Override
    public MulticastSocket createMulticastSocket(SocketAddress address) throws IOException {
        return new ManagedMulticastSocketBinding(this, address);
    }

    @Override
    public Collection<ManagedBinding> listActiveBindings() {
        return this.managedBindings.values();
    }

    @Override
    public Closeable registerBinding(ManagedBinding binding) {
        this.managedBindings.put(binding.getBindAddress(), binding);
        return binding;
    }

    @Override
    public Closeable registerSocket(DatagramSocket socket) {
        return this.registerBinding(new WrappedManagedDatagramSocket(socket));
    }

    @Override
    public Closeable registerSocket(ServerSocket socket) {
        return this.registerBinding(new WrappedManagedServerSocket(socket));
    }

    @Override
    public Closeable registerSocket(Socket socket) {
        return this.registerBinding(new WrappedManagedSocket(socket));
    }

    @Override
    public Closeable registerChannel(DatagramChannel channel) {
        return this.registerBinding((InetSocketAddress)channel.socket().getLocalSocketAddress(), channel);
    }

    @Override
    public Closeable registerChannel(ServerSocketChannel channel) {
        return this.registerBinding((InetSocketAddress)channel.socket().getLocalSocketAddress(), channel);
    }

    @Override
    public Closeable registerChannel(SocketChannel channel) {
        return this.registerBinding((InetSocketAddress)channel.socket().getLocalSocketAddress(), channel);
    }

    @Override
    public void unregisterBinding(ManagedBinding binding) {
        this.unregisterBinding(binding.getBindAddress());
    }

    @Override
    public void unregisterSocket(DatagramSocket socket) {
        this.unregisterBinding((InetSocketAddress)socket.getLocalSocketAddress());
    }

    @Override
    public void unregisterSocket(ServerSocket socket) {
        this.unregisterBinding((InetSocketAddress)socket.getLocalSocketAddress());
    }

    @Override
    public void unregisterSocket(Socket socket) {
        this.unregisterBinding((InetSocketAddress)socket.getLocalSocketAddress());
    }

    @Override
    public void unregisterChannel(DatagramChannel channel) {
        this.unregisterBinding((InetSocketAddress)channel.socket().getLocalSocketAddress());
    }

    @Override
    public void unregisterChannel(ServerSocketChannel channel) {
        this.unregisterBinding((InetSocketAddress)channel.socket().getLocalSocketAddress());
    }

    @Override
    public void unregisterChannel(SocketChannel channel) {
        this.unregisterBinding((InetSocketAddress)channel.socket().getLocalSocketAddress());
    }

    Closeable registerBinding(InetSocketAddress address, Closeable closeable) {
        return this.registerBinding(new CloseableManagedBinding(address, closeable));
    }

    void unregisterBinding(InetSocketAddress address) {
        this.managedBindings.remove(address);
    }

    class WrappedManagedServerSocket
    implements ManagedBinding {
        private final ServerSocket socket;

        public WrappedManagedServerSocket(ServerSocket socket) {
            this.socket = socket;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.socket.close();
            }
            finally {
                SocketBindingManagerService.this.unregisterBinding(this.getBindAddress());
            }
        }
    }

    class WrappedManagedSocket
    implements ManagedBinding {
        private final Socket socket;

        public WrappedManagedSocket(Socket socket) {
            this.socket = socket;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.socket.close();
            }
            finally {
                SocketBindingManagerService.this.unregisterBinding(this.getBindAddress());
            }
        }
    }

    class WrappedManagedDatagramSocket
    implements ManagedBinding {
        private final DatagramSocket socket;

        public WrappedManagedDatagramSocket(DatagramSocket socket) {
            this.socket = socket;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.socket.close();
            }
            finally {
                SocketBindingManagerService.this.unregisterBinding(this.getBindAddress());
            }
        }
    }

    class CloseableManagedBinding
    implements ManagedBinding {
        private final InetSocketAddress address;
        private final Closeable closeable;

        public CloseableManagedBinding(InetSocketAddress address, Closeable closeable) {
            this.address = address;
            this.closeable = closeable;
        }

        @Override
        public InetSocketAddress getBindAddress() {
            return this.address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.closeable.close();
            }
            finally {
                SocketBindingManagerService.this.unregisterBinding(this.address);
            }
        }
    }

    class ManagedServerSocketFactory
    extends ServerSocketFactory {
        ManagedServerSocketFactory() {
        }

        @Override
        public ServerSocket createServerSocket() throws IOException {
            return new ManagedServerSocketBinding(SocketBindingManagerService.this);
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket serverSocket = this.createServerSocket();
            serverSocket.bind(new InetSocketAddress(port));
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            ServerSocket serverSocket = this.createServerSocket();
            serverSocket.bind(new InetSocketAddress(port), backlog);
            return serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            ServerSocket serverSocket = this.createServerSocket();
            serverSocket.bind(new InetSocketAddress(ifAddress, port), backlog);
            return serverSocket;
        }
    }

    class ManagedSocketFactory
    extends SocketFactory {
        ManagedSocketFactory() {
        }

        @Override
        public Socket createSocket() {
            return new ManagedSocketBinding(SocketBindingManagerService.this);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.createSocket(InetAddress.getByName(host), port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket socket = this.createSocket();
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.createSocket(InetAddress.getByName(host), port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.createSocket();
            socket.bind(new InetSocketAddress(localAddress, localPort));
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }
    }
}

