/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.server.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentUploadBytesHandler
extends AbstractDeploymentUploadHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "upload-deployment-bytes";
    private final ParametersValidator bytesValidator = new ParametersValidator();

    public DeploymentUploadBytesHandler(DeploymentRepository repository) {
        super(repository);
        this.bytesValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getUploadDeploymentBytesOperation((Locale)locale);
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws OperationFailedException {
        this.bytesValidator.validate(operation);
        byte[] bytes = operation.get("bytes").asBytes();
        return new ByteArrayInputStream(bytes);
    }
}

