/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.server.operations.SystemPropertyRemoveHandler;
import org.jboss.dmr.ModelNode;

public class SystemPropertyAddHandler
extends org.jboss.as.controller.operations.common.SystemPropertyAddHandler {
    public static final SystemPropertyAddHandler INSTANCE = new SystemPropertyAddHandler();
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getOperation(ModelNode address, String name, String value) {
        ModelNode op = Util.getEmptyOperation((String)"add-system-property", (ModelNode)address);
        if (value == null) {
            op.get(name).set(new ModelNode());
        } else {
            op.get(name).set(value);
        }
        return op;
    }

    protected SystemPropertyAddHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("value", (ParameterValidator)new StringLengthValidator(0, true));
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        String name = operation.get("name").asString();
        String value = operation.get("value").isDefined() ? operation.get("value").asString() : null;
        ModelNode node = context.getSubModel().get(new String[]{"system-properties", name});
        if (value == null) {
            node.set(new ModelNode());
        } else {
            node.set(value);
        }
        ModelNode compensating = SystemPropertyRemoveHandler.getOperation(operation.get("address"), name);
        return this.updateSystemProperty(name, value, context, resultHandler, compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSystemPropertyOperation((Locale)locale, (boolean)true);
    }

    protected OperationResult updateSystemProperty(final String name, final String value, OperationContext context, final ResultHandler resultHandler, ModelNode compensating) {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    System.setProperty(name, value);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

