/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class NetworkInterfaceRuntimeHandler
implements OperationStepHandler {
    public static final OperationStepHandler INSTANCE = new NetworkInterfaceRuntimeHandler();
    public static final String RESOLVED_ADDRESS = "resolved-address";

    protected NetworkInterfaceRuntimeHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final String interfaceName = address.getLastElement().getValue();
        final String attributeName = operation.require("name").asString();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController controller = context.getServiceRegistry(false).getService(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}));
                if (controller != null) {
                    NetworkInterfaceBinding binding = (NetworkInterfaceBinding)NetworkInterfaceBinding.class.cast(controller.getValue());
                    InetAddress address = binding.getAddress();
                    ModelNode result = new ModelNode();
                    if (NetworkInterfaceRuntimeHandler.RESOLVED_ADDRESS.equals(attributeName)) {
                        result.set(address.getHostAddress());
                    }
                    context.getResult().set(result);
                }
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

