/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class DeploymentRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.controller");
    public static final String OPERATION_NAME = "remove";
    private final ContentRepository contentRepository;
    private final boolean standalone;

    public DeploymentRemoveHandler(ContentRepository contentRepository, boolean standalone) {
        this.contentRepository = contentRepository;
        this.standalone = standalone;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final List<byte[]> removedHashes = DeploymentUtils.getDeploymentHash(resource);
        final ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    block8: {
                        boolean enabled;
                        String deploymentUnitName;
                        block6: {
                            block7: {
                                deploymentUnitName = null;
                                boolean bl = enabled = model.hasDefined("enabled") ? model.get("enabled").asBoolean() : true;
                                if (enabled) {
                                    ModelNode opAddr = operation.get("address");
                                    PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
                                    String name = address.getLastElement().getValue();
                                    deploymentUnitName = model.hasDefined("runtime-name") ? model.get("runtime-name").asString() : name;
                                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                                    context.removeService(deploymentUnitServiceName);
                                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                                }
                                if (context.completeStep() != OperationContext.ResultAction.ROLLBACK) break block6;
                                DeploymentRemoveHandler.this.recoverServices(context, operation, model);
                                if (!enabled || !context.hasFailureDescription()) break block7;
                                ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                                break block8;
                            }
                            if (!enabled) break block8;
                            ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                            break block8;
                        }
                        if (enabled) {
                            ServerLogger.ROOT_LOGGER.deploymentUndeployed(deploymentUnitName);
                        }
                        if (DeploymentRemoveHandler.this.standalone) {
                            for (byte[] hash : removedHashes) {
                                try {
                                    DeploymentRemoveHandler.this.contentRepository.removeContent(hash);
                                }
                                catch (Exception e) {
                                    log.infof((Throwable)e, "Exception occurred removing %s", (Object)hash);
                                }
                            }
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER;
    }

    public ModelNode getModelDescription(Locale locale) {
        return ServerDescriptions.getRemoveDeploymentOperation(locale);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        boolean enabled;
        boolean bl = enabled = model.hasDefined("enabled") ? model.get("enabled").asBoolean() : true;
        if (!enabled) {
            return;
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

